/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.impl.DefaultTermDefinition;
import org.apache.james.jspf.parser.TermDefinition;
import org.apache.james.jspf.parser.TermsFactory;
import org.apache.james.jspf.terms.Configuration;
import org.apache.james.jspf.terms.ConfigurationEnabled;
import org.apache.james.jspf.wiring.WiringService;
import org.apache.james.jspf.wiring.WiringServiceException;
import org.apache.james.jspf.wiring.WiringServiceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTermsFactory
implements TermsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTermsFactory.class);
    private String termFile = "org/apache/james/jspf/parser/jspf.default.terms";
    private Collection<TermDefinition> mechanismsCollection;
    private Collection<TermDefinition> modifiersCollection;
    private WiringService wiringService;

    public DefaultTermsFactory() {
        this.wiringService = new WiringServiceTable();
        this.init();
    }

    public DefaultTermsFactory(WiringService wiringService) {
        this.wiringService = wiringService;
        this.init();
    }

    private void init() {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.termFile);
            if (is == null) {
                throw new NullPointerException("Unable to find the " + this.termFile + " resource in the classpath");
            }
            Properties p = new Properties();
            p.load(is);
            String mechs = p.getProperty("mechanisms");
            String mods = p.getProperty("modifiers");
            String[] classes = mechs.split(",");
            Class[] knownMechanisms = new Class[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                LOGGER.debug("Add following class as known mechanismn: {}", (Object)classes[i]);
                knownMechanisms[i] = Thread.currentThread().getContextClassLoader().loadClass(classes[i]);
            }
            this.mechanismsCollection = this.createTermDefinitionCollection(knownMechanisms);
            classes = mods.split(",");
            Class[] knownModifiers = new Class[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                LOGGER.debug("Add following class as known modifier: {}", (Object)classes[i]);
                knownModifiers[i] = Thread.currentThread().getContextClassLoader().loadClass(classes[i]);
            }
            this.modifiersCollection = this.createTermDefinitionCollection(knownModifiers);
        }
        catch (IOException e) {
            throw new IllegalStateException("Term configuration cannot be found");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("One configured class cannot be found");
        }
    }

    private Collection<TermDefinition> createTermDefinitionCollection(Class<?>[] classes) {
        ArrayList<DefaultTermDefinition> l = new ArrayList<DefaultTermDefinition>();
        for (int j = 0; j < classes.length; ++j) {
            try {
                l.add(new DefaultTermDefinition(classes[j]));
                continue;
            }
            catch (Exception e) {
                LOGGER.debug("Unable to create the term collection", (Throwable)e);
                throw new IllegalStateException("Unable to create the term collection");
            }
        }
        return Collections.synchronizedCollection(l);
    }

    @Override
    public Object createTerm(Class<?> termDef, Configuration subres) throws PermErrorException, InstantiationException {
        try {
            Object term = termDef.newInstance();
            try {
                this.wiringService.wire(term);
            }
            catch (WiringServiceException e) {
                throw new InstantiationException("Unexpected error adding dependencies to term: " + e.getMessage());
            }
            if (term instanceof ConfigurationEnabled) {
                if (subres == null || subres.groupCount() == 0) {
                    ((ConfigurationEnabled)term).config(null);
                } else {
                    ((ConfigurationEnabled)term).config(subres);
                }
            }
            return term;
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Unexpected error creating term: " + e.getMessage());
        }
    }

    @Override
    public Collection<TermDefinition> getMechanismsCollection() {
        return this.mechanismsCollection;
    }

    @Override
    public Collection<TermDefinition> getModifiersCollection() {
        return this.modifiersCollection;
    }
}

