/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.ir;

import java.time.ZoneId;
import javax.annotation.Nullable;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.DateBinFunctionColumnTransformer;

public class GapFillStartAndEndTimeExtractVisitor
extends AstVisitor<Boolean, Context> {
    private static final String UPDATE_START_TIME_ERROR_MSG = "Operator of updateStatTime should only be GREATER_THAN and GREATER_THAN_OR_EQUAL, now is %s";
    private static final String UPDATE_END_TIME_ERROR_MSG = "Operator of updateEndTime should only be LESS_THAN and LESS_THAN_OR_EQUAL, now is %s";
    private final Symbol timeColumn;
    public static final String CAN_NOT_INFER_TIME_RANGE = "could not infer startTime or endTime from WHERE clause";

    public GapFillStartAndEndTimeExtractVisitor(Symbol timeColumn) {
        this.timeColumn = timeColumn;
    }

    @Override
    public Boolean visitNode(Node node, Context context) {
        for (Node node2 : node.getChildren()) {
            if (!Boolean.TRUE.equals(super.process(node2, context))) continue;
            throw new SemanticException(CAN_NOT_INFER_TIME_RANGE);
        }
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitSymbolReference(SymbolReference node, Context context) {
        return this.isTimeIdentifier(node);
    }

    @Override
    protected Boolean visitLogicalExpression(LogicalExpression node, Context context) {
        if (node.getOperator() == LogicalExpression.Operator.AND) {
            boolean hasMeetGapFillTimeFilter = false;
            for (Expression term : node.getTerms()) {
                hasMeetGapFillTimeFilter = term.accept(this, context) != false || hasMeetGapFillTimeFilter;
            }
            return hasMeetGapFillTimeFilter;
        }
        if (node.getOperator() == LogicalExpression.Operator.OR) {
            for (Expression term : node.getTerms()) {
                if (!Boolean.TRUE.equals(term.accept(this, context))) continue;
                throw new SemanticException(CAN_NOT_INFER_TIME_RANGE);
            }
            return false;
        }
        throw new IllegalStateException("Illegal state in visitLogicalExpression");
    }

    @Override
    protected Boolean visitComparisonExpression(ComparisonExpression node, Context context) {
        Expression rightExpression;
        Expression leftExpression = node.getLeft();
        if (this.checkIsValidTimeFilter(leftExpression, rightExpression = node.getRight(), node.getOperator(), context) || this.checkIsValidTimeFilter(rightExpression, leftExpression, node.getOperator().flip(), context)) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(leftExpression.accept(this, context)) || Boolean.TRUE.equals(rightExpression.accept(this, context))) {
            throw new SemanticException(CAN_NOT_INFER_TIME_RANGE);
        }
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitBetweenPredicate(BetweenPredicate node, Context context) {
        Expression firstExpression = node.getValue();
        Expression secondExpression = node.getMin();
        Expression thirdExpression = node.getMax();
        boolean result1 = this.checkIsValidTimeFilter(firstExpression, secondExpression, ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, context);
        boolean result2 = this.checkIsValidTimeFilter(firstExpression, thirdExpression, ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, context);
        if (result1 || result2) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(firstExpression.accept(this, context)) || Boolean.TRUE.equals(secondExpression.accept(this, context)) || Boolean.TRUE.equals(thirdExpression.accept(this, context))) {
            throw new SemanticException(CAN_NOT_INFER_TIME_RANGE);
        }
        return Boolean.FALSE;
    }

    private boolean isTimeIdentifier(Expression e) {
        return e instanceof SymbolReference && this.timeColumn.getName().equalsIgnoreCase(((SymbolReference)e).getName());
    }

    private boolean checkIsValidTimeFilter(Expression timeExpression, Expression valueExpression, ComparisonExpression.Operator operator, Context context) {
        if (this.isTimeIdentifier(timeExpression) && valueExpression instanceof LongLiteral) {
            long value = ((LongLiteral)valueExpression).getParsedValue();
            switch (operator) {
                case EQUAL: 
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return false;
                }
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    context.updateEndTime(value, operator);
                    return true;
                }
                case GREATER_THAN_OR_EQUAL: 
                case GREATER_THAN: {
                    context.updateStartTime(value, operator);
                    return true;
                }
            }
        }
        return false;
    }

    public static class Context {
        @Nullable
        public ComparisonExpression.Operator leftOperator;
        long startTime;
        @Nullable
        public ComparisonExpression.Operator rightOperator;
        long endTime;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void updateStartTime(long startTime, ComparisonExpression.Operator operator) {
            if (this.leftOperator == null) {
                this.leftOperator = operator;
                this.startTime = startTime;
                return;
            } else if (this.leftOperator == ComparisonExpression.Operator.GREATER_THAN) {
                if (operator == ComparisonExpression.Operator.GREATER_THAN) {
                    this.startTime = Math.max(this.startTime, startTime);
                    return;
                } else {
                    if (operator != ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL) throw new IllegalArgumentException(String.format(GapFillStartAndEndTimeExtractVisitor.UPDATE_START_TIME_ERROR_MSG, new Object[]{operator}));
                    if (startTime <= this.startTime) return;
                    this.leftOperator = operator;
                    this.startTime = startTime;
                }
                return;
            } else {
                if (this.leftOperator != ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL) throw new IllegalArgumentException(String.format(GapFillStartAndEndTimeExtractVisitor.UPDATE_START_TIME_ERROR_MSG, new Object[]{operator}));
                if (operator == ComparisonExpression.Operator.GREATER_THAN) {
                    if (startTime < this.startTime) return;
                    this.leftOperator = operator;
                    this.startTime = startTime;
                    return;
                } else {
                    if (operator != ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL) throw new IllegalArgumentException(String.format(GapFillStartAndEndTimeExtractVisitor.UPDATE_START_TIME_ERROR_MSG, new Object[]{operator}));
                    this.startTime = Math.max(this.startTime, startTime);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void updateEndTime(long endTime, ComparisonExpression.Operator operator) {
            if (this.rightOperator == null) {
                this.rightOperator = operator;
                this.endTime = endTime;
                return;
            } else if (this.rightOperator == ComparisonExpression.Operator.LESS_THAN) {
                if (operator == ComparisonExpression.Operator.LESS_THAN) {
                    this.endTime = Math.min(this.endTime, endTime);
                    return;
                } else {
                    if (operator != ComparisonExpression.Operator.LESS_THAN_OR_EQUAL) throw new IllegalArgumentException(String.format(GapFillStartAndEndTimeExtractVisitor.UPDATE_END_TIME_ERROR_MSG, new Object[]{operator}));
                    if (endTime >= this.endTime) return;
                    this.rightOperator = operator;
                    this.endTime = endTime;
                }
                return;
            } else {
                if (this.rightOperator != ComparisonExpression.Operator.LESS_THAN_OR_EQUAL) throw new IllegalArgumentException(String.format(GapFillStartAndEndTimeExtractVisitor.UPDATE_START_TIME_ERROR_MSG, new Object[]{operator}));
                if (operator == ComparisonExpression.Operator.LESS_THAN) {
                    if (endTime > this.endTime) return;
                    this.rightOperator = operator;
                    this.endTime = endTime;
                    return;
                } else {
                    if (operator != ComparisonExpression.Operator.LESS_THAN_OR_EQUAL) throw new IllegalArgumentException(String.format(GapFillStartAndEndTimeExtractVisitor.UPDATE_START_TIME_ERROR_MSG, new Object[]{operator}));
                    this.endTime = Math.max(this.endTime, endTime);
                }
            }
        }

        public long[] getTimeRange(long origin, int monthDuration, long nonMonthDuration, ZoneId zoneId) {
            if (this.leftOperator == null || this.rightOperator == null) {
                throw new SemanticException(GapFillStartAndEndTimeExtractVisitor.CAN_NOT_INFER_TIME_RANGE);
            }
            long[] result = new long[2];
            if (this.leftOperator == ComparisonExpression.Operator.GREATER_THAN) {
                ++this.startTime;
            }
            result[0] = DateBinFunctionColumnTransformer.dateBin(this.startTime, origin, monthDuration, nonMonthDuration, zoneId);
            if (this.rightOperator == ComparisonExpression.Operator.LESS_THAN) {
                --this.endTime;
            }
            result[1] = DateBinFunctionColumnTransformer.dateBin(this.endTime, origin, monthDuration, nonMonthDuration, zoneId);
            return result;
        }
    }
}

