/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAggregator;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.RamUsageEstimator;

public class AggregationOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AggregationOperator.class);
    private final OperatorContext operatorContext;
    private final Operator child;
    private final List<TableAggregator> aggregators;
    private final TsBlockBuilder resultBuilder;
    private final ColumnBuilder[] resultColumnsBuilder;
    private final long maxReturnSize = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    protected MemoryReservationManager memoryReservationManager;
    private boolean finished = false;

    public AggregationOperator(OperatorContext operatorContext, Operator child, List<TableAggregator> aggregators) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.aggregators = aggregators;
        this.resultBuilder = new TsBlockBuilder((List)aggregators.stream().map(TableAggregator::getType).collect(ImmutableList.toImmutableList()));
        this.resultColumnsBuilder = this.resultBuilder.getValueColumnBuilders();
        this.memoryReservationManager = operatorContext.getDriverContext().getFragmentInstanceContext().getMemoryReservationContext();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.finished;
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.child.hasNextWithTimer()) {
            TsBlock block = this.child.nextWithTimer();
            if (block == null) {
                return null;
            }
            for (TableAggregator aggregator : this.aggregators) {
                aggregator.processBlock(block);
            }
            return null;
        }
        Column[] valueColumns = new Column[this.resultColumnsBuilder.length];
        for (int i = 0; i < this.aggregators.size(); ++i) {
            this.aggregators.get(i).evaluate(this.resultColumnsBuilder[i]);
            valueColumns[i] = this.resultColumnsBuilder[i].build();
        }
        this.finished = true;
        return TsBlock.wrapBlocksWithoutCopy((int)1, (Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, 1), (Column[])valueColumns);
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished;
    }

    @Override
    public void close() throws Exception {
        this.child.close();
        this.aggregators.forEach(TableAggregator::close);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.child.calculateMaxPeekMemoryWithCounter(), this.calculateRetainedSizeAfterCallingNext() + this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateMaxReturnSize() + this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + this.aggregators.stream().mapToLong(TableAggregator::getEstimatedSize).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.resultBuilder.getRetainedSizeInBytes();
    }
}

