/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.function.partition;

import org.apache.iotdb.db.queryengine.execution.operator.process.function.partition.Slice;

public class PartitionState {
    public static final PartitionState NEED_MORE_DATA_STATE = new PartitionState(StateType.NEED_MORE_DATA, null);
    public static final PartitionState FINISHED_STATE = new PartitionState(StateType.FINISHED, null);
    public static final PartitionState INIT_STATE = new PartitionState(StateType.INIT, null);
    private final StateType stateType;
    private final Slice slice;

    public static PartitionState newPartitionState(Slice slice) {
        return new PartitionState(StateType.NEW_PARTITION, slice);
    }

    public static PartitionState iteratingState(Slice slice) {
        return new PartitionState(StateType.ITERATING, slice);
    }

    protected PartitionState(StateType stateType, Slice slice) {
        this.stateType = stateType;
        this.slice = slice;
    }

    public StateType getStateType() {
        return this.stateType;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public static enum StateType {
        INIT,
        NEW_PARTITION,
        NEED_MORE_DATA,
        ITERATING,
        FINISHED;

    }
}

