/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;

public class TimSort {
    public static int SMALL_ARRAY_LENGTH = 32;
    protected final TVList tvList;
    private long[][] sortedTimestamps;
    private long pivotTime;
    private int[][] sortedIndices;
    private int pivotIndex;

    public TimSort(TVList tvList) {
        this.tvList = tvList;
    }

    public void tim_set(int src, int dest) {
        this.tvList.set(src, dest);
    }

    public void setToSorted(int src, int dest) {
        this.sortedTimestamps[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.tvList.getTime(src);
        this.sortedIndices[dest / PrimitiveArrayManager.ARRAY_SIZE][dest % PrimitiveArrayManager.ARRAY_SIZE] = this.tvList.getValueIndex(src);
    }

    public void saveAsPivot(int pos) {
        this.pivotTime = this.tvList.getTime(pos);
        this.pivotIndex = this.tvList.getValueIndex(pos);
    }

    public void setFromSorted(int src, int dest) {
        this.tvList.set(dest, this.sortedTimestamps[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE], this.sortedIndices[src / PrimitiveArrayManager.ARRAY_SIZE][src % PrimitiveArrayManager.ARRAY_SIZE]);
    }

    public void setPivotTo(int pos) {
        this.tvList.set(pos, this.pivotTime, this.pivotIndex);
    }

    public void clearSortedTime() {
        if (this.sortedTimestamps != null) {
            this.sortedTimestamps = null;
        }
    }

    public void clearSortedValue() {
        if (this.sortedIndices != null) {
            this.sortedIndices = null;
        }
    }

    public int compare(int idx1, int idx2) {
        long t1 = this.tvList.getTime(idx1);
        long t2 = this.tvList.getTime(idx2);
        return Long.compare(t1, t2);
    }

    public void reverseRange(int lo, int hi) {
        --hi;
        while (lo < hi) {
            long loT = this.tvList.getTime(lo);
            int loV = this.tvList.getValueIndex(lo);
            long hiT = this.tvList.getTime(hi);
            int hiV = this.tvList.getValueIndex(hi);
            this.tvList.set(lo++, hiT, hiV);
            this.tvList.set(hi--, loT, loV);
        }
    }

    public void checkSortedTimestampsAndIndices() {
        if (this.sortedTimestamps == null || this.sortedTimestamps.length < PrimitiveArrayManager.getArrayRowCount(this.tvList.rowCount())) {
            this.sortedTimestamps = (long[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT64, this.tvList.rowCount());
        }
        if (this.sortedIndices == null || this.sortedIndices.length < PrimitiveArrayManager.getArrayRowCount(this.tvList.rowCount())) {
            this.sortedIndices = (int[][])PrimitiveArrayManager.createDataListsByType(TSDataType.INT32, this.tvList.rowCount());
        }
    }

    public void sort(int lo, int hi) {
        if (lo == hi) {
            return;
        }
        if (hi - lo <= SMALL_ARRAY_LENGTH) {
            int initRunLen = this.countRunAndMakeAscending(lo, hi);
            this.binarySort(lo, hi, lo + initRunLen);
            return;
        }
        int mid = lo + hi >>> 1;
        this.sort(lo, mid);
        this.sort(mid, hi);
        this.merge(lo, mid, hi);
    }

    public int countRunAndMakeAscending(int lo, int hi) {
        assert (lo < hi);
        int runHi = lo + 1;
        if (runHi == hi) {
            return 1;
        }
        if (this.compare(runHi++, lo) == -1) {
            while (runHi < hi && this.compare(runHi, runHi - 1) == -1) {
                ++runHi;
            }
            this.reverseRange(lo, runHi);
        } else {
            while (runHi < hi && this.compare(runHi, runHi - 1) >= 0) {
                ++runHi;
            }
        }
        return runHi - lo;
    }

    public void binarySort(int lo, int hi, int start) {
        assert (lo <= start && start <= hi);
        if (start == lo) {
            ++start;
        }
        while (start < hi) {
            int n;
            this.saveAsPivot(start);
            int left = lo;
            int right = start;
            assert (left <= right);
            while (left < right) {
                int mid = left + right >>> 1;
                if (this.compare(start, mid) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            assert (left == right);
            for (int i = n = start - left; i >= 1; --i) {
                this.tim_set(left + i - 1, left + i);
            }
            this.setPivotTo(left);
            ++start;
        }
        for (int i = lo; i < hi; ++i) {
            this.setToSorted(i, i);
        }
    }

    public void merge(int lo, int mid, int hi) {
        int end;
        int start;
        int tmpIdx = 0;
        int leftIdx = lo;
        int rightIdx = mid;
        int endSide = 0;
        while (endSide == 0) {
            if (this.compare(leftIdx, rightIdx) <= 0) {
                this.setToSorted(leftIdx, lo + tmpIdx);
                ++tmpIdx;
                if (++leftIdx != mid) continue;
                endSide = 1;
                continue;
            }
            this.setToSorted(rightIdx, lo + tmpIdx);
            ++tmpIdx;
            if (++rightIdx != hi) continue;
            endSide = 2;
        }
        if (endSide == 1) {
            start = rightIdx;
            end = hi;
        } else {
            start = leftIdx;
            end = mid;
        }
        while (start < end) {
            this.setToSorted(start, lo + tmpIdx);
            ++tmpIdx;
            ++start;
        }
        for (int i = lo; i < hi; ++i) {
            this.setFromSorted(i, i);
        }
    }
}

