/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.quotas;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetSpaceQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSpaceQuota;
import org.apache.iotdb.confignode.rpc.thrift.TSpaceQuotaResp;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.storageengine.rescon.quotas.DataNodeSizeStore;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeSpaceQuotaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeSpaceQuotaManager.class);
    private Map<String, TSpaceQuota> spaceQuotaLimit;
    private Map<String, TSpaceQuota> spaceQuotaUsage;
    private DataNodeSizeStore dataNodeSizeStore;

    public DataNodeSpaceQuotaManager() {
        this.spaceQuotaLimit = new HashMap<String, TSpaceQuota>();
        this.spaceQuotaUsage = new HashMap<String, TSpaceQuota>();
        this.dataNodeSizeStore = new DataNodeSizeStore();
        this.recover();
    }

    public DataNodeSpaceQuotaManager(Map<String, TSpaceQuota> spaceQuotaLimit, Map<String, TSpaceQuota> spaceQuotaUsage) {
        this.spaceQuotaLimit = spaceQuotaLimit;
        this.spaceQuotaUsage = spaceQuotaUsage;
    }

    public static DataNodeSpaceQuotaManager getInstance() {
        return DataNodeSpaceQuotaManagerHolder.INSTANCE;
    }

    public TSStatus setSpaceQuota(TSetSpaceQuotaReq req) {
        for (String database : req.getDatabase()) {
            this.spaceQuotaLimit.put(database, req.getSpaceLimit());
            this.spaceQuotaUsage.put(database, new TSpaceQuota());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    private void recover() {
        TSpaceQuotaResp spaceQuota = ClusterConfigTaskExecutor.getInstance().getSpaceQuota();
        if (spaceQuota.getStatus() != null) {
            if (spaceQuota.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && spaceQuota.getSpaceQuota() != null) {
                for (String database : spaceQuota.getSpaceQuota().keySet()) {
                    this.spaceQuotaLimit.put(database, (TSpaceQuota)spaceQuota.getSpaceQuota().get(database));
                    this.spaceQuotaUsage.put(database, new TSpaceQuota());
                }
            }
            LOGGER.info("Space quota limit restored succeeded. " + this.spaceQuotaLimit.toString());
        } else {
            LOGGER.error("Space quota limit restored failed. " + this.spaceQuotaLimit.toString());
        }
    }

    public boolean checkDeviceLimit(String database) {
        database = "root." + database;
        TSpaceQuota spaceQuota = this.spaceQuotaLimit.get(database);
        if (spaceQuota == null) {
            return true;
        }
        if (spaceQuota.getDeviceNum() == 0L || spaceQuota.getDeviceNum() == -1L) {
            return true;
        }
        long deviceNum = this.spaceQuotaUsage.get(database).getDeviceNum();
        return spaceQuota.getDeviceNum() - deviceNum > 0L;
    }

    public void updateSpaceQuotaUsage(Map<String, TSpaceQuota> spaceQuotaUsage) {
        this.spaceQuotaUsage = spaceQuotaUsage;
    }

    public boolean checkTimeSeriesNum(String database) {
        database = "root." + database;
        TSpaceQuota spaceQuota = this.spaceQuotaLimit.get(database);
        if (spaceQuota == null) {
            return true;
        }
        if (spaceQuota.getTimeserieNum() == 0L || spaceQuota.getTimeserieNum() == -1L) {
            return true;
        }
        long timeSeriesNum = this.spaceQuotaUsage.get(database).getTimeserieNum();
        return spaceQuota.getTimeserieNum() - timeSeriesNum > 0L;
    }

    public boolean checkRegionDisk(String database) {
        TSpaceQuota spaceQuota = this.spaceQuotaLimit.get(database);
        if (spaceQuota == null) {
            return true;
        }
        if (spaceQuota.getDiskSize() == 0L || spaceQuota.getDiskSize() == -1L) {
            return true;
        }
        long diskSize = this.spaceQuotaUsage.get(database).getDiskSize();
        return spaceQuota.getDiskSize() - diskSize > 0L;
    }

    public void setDataRegionIds(List<Integer> dataRegionIds) {
        this.dataNodeSizeStore.setDataRegionIds(dataRegionIds);
    }

    public Map<Integer, Long> getRegionDisk() {
        return this.dataNodeSizeStore.getDataRegionDisk();
    }

    public void setSpaceQuotaLimit(Map<String, TSpaceQuota> spaceQuotaLimit) {
        this.spaceQuotaLimit = spaceQuotaLimit;
    }

    private static class DataNodeSpaceQuotaManagerHolder {
        private static final DataNodeSpaceQuotaManager INSTANCE = new DataNodeSpaceQuotaManager();

        private DataNodeSpaceQuotaManagerHolder() {
        }
    }
}

