/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.io;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALInputStream;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALMetaData;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryPosition;

public class WALByteBufReader
implements Closeable {
    private WALMetaData metaData;
    private DataInputStream logStream;
    private Iterator<Integer> sizeIterator;

    public WALByteBufReader(File logFile) throws IOException {
        WALInputStream walInputStream = new WALInputStream(logFile);
        try {
            this.logStream = new DataInputStream(walInputStream);
            this.metaData = walInputStream.getWALMetaData();
            this.sizeIterator = this.metaData.getBuffersSize().iterator();
        }
        catch (Exception e) {
            walInputStream.close();
            throw e;
        }
    }

    public WALByteBufReader(WALEntryPosition walEntryPosition) throws IOException {
        WALInputStream walInputStream = walEntryPosition.openReadFileStream();
        try {
            this.logStream = new DataInputStream(walInputStream);
            this.metaData = walInputStream.getWALMetaData();
            this.sizeIterator = this.metaData.getBuffersSize().iterator();
        }
        catch (Exception e) {
            walInputStream.close();
            throw e;
        }
    }

    public boolean hasNext() {
        return this.sizeIterator.hasNext();
    }

    public ByteBuffer next() throws IOException {
        int size = this.sizeIterator.next();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        this.logStream.readFully(buffer.array(), 0, size);
        return buffer;
    }

    public WALMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void close() throws IOException {
        this.logStream.close();
    }

    public long getFirstSearchIndex() {
        return this.metaData.getFirstSearchIndex();
    }
}

