/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata;

import java.io.Serializable;
import java.util.Optional;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;

public class AlignedPageMetadata
implements IMetadata {
    private Statistics<? extends Serializable> timeStatistics;
    private Statistics<? extends Serializable>[] valueStatistics;

    public AlignedPageMetadata(Statistics<? extends Serializable> timeStatistics, Statistics<? extends Serializable>[] valuesStatistics) {
        this.timeStatistics = timeStatistics;
        this.valueStatistics = valuesStatistics;
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.valueStatistics.length == 1 && this.valueStatistics[0] != null ? this.valueStatistics[0] : this.timeStatistics;
    }

    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.timeStatistics;
    }

    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        return Optional.ofNullable(measurementIndex >= this.valueStatistics.length ? null : this.valueStatistics[measurementIndex]);
    }

    public boolean hasNullValue(int measurementIndex) {
        if (measurementIndex >= this.valueStatistics.length) {
            return false;
        }
        long rowCount = this.getTimeStatistics().getCount();
        Statistics<? extends Serializable> stats = this.valueStatistics[measurementIndex];
        return stats != null && stats.hasNullValue(rowCount);
    }

    public void setStatistics(Statistics<? extends Serializable> timeStatistics, Statistics<? extends Serializable>[] valueStatistics) {
        this.timeStatistics = timeStatistics;
        this.valueStatistics = valueStatistics;
    }
}

