/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DeviceLastFlushTime;
import org.apache.iotdb.db.storageengine.dataregion.ILastFlushTime;
import org.apache.iotdb.db.storageengine.dataregion.ILastFlushTimeMap;
import org.apache.iotdb.db.storageengine.dataregion.PartitionLastFlushTime;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashLastFlushTimeMap
implements ILastFlushTimeMap {
    private static final Logger logger = LoggerFactory.getLogger(HashLastFlushTimeMap.class);
    long LONG_SIZE = 24L;
    long HASHMAP_NODE_BASIC_SIZE = 14L + this.LONG_SIZE;
    private final Map<Long, ILastFlushTime> partitionLatestFlushedTime = new ConcurrentHashMap<Long, ILastFlushTime>();
    private final Map<IDeviceID, Long> globalLatestFlushedTimeForEachDevice = new ConcurrentHashMap<IDeviceID, Long>();
    private final Map<Long, Long> memCostForEachPartition = new ConcurrentHashMap<Long, Long>();

    @Override
    public void updateMultiDeviceFlushedTime(long timePartitionId, Map<IDeviceID, Long> flushedTimeMap) {
        ILastFlushTime flushTimeMapForPartition = this.partitionLatestFlushedTime.computeIfAbsent(timePartitionId, id -> new DeviceLastFlushTime());
        long memIncr = 0L;
        for (Map.Entry<IDeviceID, Long> entry : flushedTimeMap.entrySet()) {
            if (flushTimeMapForPartition.getLastFlushTime(entry.getKey()) == Long.MIN_VALUE) {
                memIncr += this.HASHMAP_NODE_BASIC_SIZE + entry.getKey().ramBytesUsed();
            }
            flushTimeMapForPartition.updateLastFlushTime(entry.getKey(), entry.getValue());
        }
        long finalMemIncr = memIncr;
        this.memCostForEachPartition.compute(timePartitionId, (k1, v1) -> v1 == null ? finalMemIncr : v1 + finalMemIncr);
    }

    @Override
    public void upgradeAndUpdateMultiDeviceFlushedTime(long timePartitionId, Map<IDeviceID, Long> flushedTimeMap) {
        ILastFlushTime flushTimeMapForPartition = this.partitionLatestFlushedTime.computeIfAbsent(timePartitionId, id -> new DeviceLastFlushTime());
        if (flushTimeMapForPartition instanceof PartitionLastFlushTime) {
            long maxFlushTime = flushTimeMapForPartition.getLastFlushTime(null);
            DeviceLastFlushTime newDeviceLastFlushTime = new DeviceLastFlushTime();
            long memIncr = 0L;
            for (Map.Entry<IDeviceID, Long> entry : flushedTimeMap.entrySet()) {
                memIncr += this.HASHMAP_NODE_BASIC_SIZE + entry.getKey().ramBytesUsed();
                newDeviceLastFlushTime.updateLastFlushTime(entry.getKey(), entry.getValue());
                maxFlushTime = Math.max(maxFlushTime, entry.getValue());
            }
            long finalMemIncr = memIncr;
            this.memCostForEachPartition.compute(timePartitionId, (k1, v1) -> v1 == null ? finalMemIncr : v1 + finalMemIncr);
        } else {
            long memIncr = 0L;
            for (Map.Entry<IDeviceID, Long> entry : flushedTimeMap.entrySet()) {
                if (flushTimeMapForPartition.getLastFlushTime(entry.getKey()) == Long.MIN_VALUE) {
                    memIncr += this.HASHMAP_NODE_BASIC_SIZE + entry.getKey().ramBytesUsed();
                }
                flushTimeMapForPartition.updateLastFlushTime(entry.getKey(), entry.getValue());
            }
            long finalMemIncr = memIncr;
            this.memCostForEachPartition.compute(timePartitionId, (k1, v1) -> v1 == null ? finalMemIncr : v1 + finalMemIncr);
        }
    }

    @Override
    public void updatePartitionFlushedTime(long timePartitionId, long maxFlushedTime) {
        ILastFlushTime flushTimeMapForPartition = this.partitionLatestFlushedTime.computeIfAbsent(timePartitionId, id -> new PartitionLastFlushTime(maxFlushedTime));
        if (flushTimeMapForPartition instanceof PartitionLastFlushTime) {
            long memIncr = 8L;
            flushTimeMapForPartition.updateLastFlushTime(null, maxFlushedTime);
            this.memCostForEachPartition.putIfAbsent(timePartitionId, memIncr);
        } else {
            DeviceLastFlushTime deviceLastFlushTime = (DeviceLastFlushTime)flushTimeMapForPartition;
            Map<IDeviceID, Long> flushedTimeMap = deviceLastFlushTime.getDeviceLastFlushTimeMap();
            for (Map.Entry<IDeviceID, Long> entry : flushedTimeMap.entrySet()) {
                flushTimeMapForPartition.updateLastFlushTime(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void updateMultiDeviceGlobalFlushedTime(Map<IDeviceID, Long> globalFlushedTimeMap) {
        for (Map.Entry<IDeviceID, Long> entry : globalFlushedTimeMap.entrySet()) {
            this.globalLatestFlushedTimeForEachDevice.merge(entry.getKey(), entry.getValue(), Math::max);
        }
    }

    @Override
    public boolean checkAndCreateFlushedTimePartition(long timePartitionId, boolean usingDeviceFlushTime) {
        if (!this.partitionLatestFlushedTime.containsKey(timePartitionId)) {
            this.partitionLatestFlushedTime.put(timePartitionId, usingDeviceFlushTime ? new DeviceLastFlushTime() : new PartitionLastFlushTime(Long.MIN_VALUE));
            return false;
        }
        return true;
    }

    @Override
    public void updateLatestFlushTime(long partitionId, Map<IDeviceID, Long> updateMap) {
        for (Map.Entry<IDeviceID, Long> entry : updateMap.entrySet()) {
            this.partitionLatestFlushedTime.computeIfAbsent(partitionId, id -> new DeviceLastFlushTime()).updateLastFlushTime(entry.getKey(), entry.getValue());
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(entry.getKey(), Long.MIN_VALUE) >= entry.getValue()) continue;
            this.globalLatestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public long getFlushedTime(long timePartitionId, IDeviceID deviceId) {
        return this.partitionLatestFlushedTime.get(timePartitionId).getLastFlushTime(deviceId);
    }

    @Override
    public long getGlobalFlushedTime(IDeviceID path) {
        if (!StorageEngine.getInstance().isReadyForNonReadWriteFunctions()) {
            return Long.MAX_VALUE;
        }
        return this.globalLatestFlushedTimeForEachDevice.getOrDefault(path, Long.MIN_VALUE);
    }

    @Override
    public void clearFlushedTime() {
        this.partitionLatestFlushedTime.clear();
    }

    @Override
    public void clearGlobalFlushedTime() {
        this.globalLatestFlushedTimeForEachDevice.clear();
    }

    @Override
    public void degradeLastFlushTime(long partitionId) {
        this.partitionLatestFlushedTime.computeIfPresent(partitionId, (id, lastFlushTime) -> lastFlushTime.degradeLastFlushTime());
        this.memCostForEachPartition.put(partitionId, 8L);
    }

    @Override
    public long getMemSize(long partitionId) {
        if (this.memCostForEachPartition.containsKey(partitionId)) {
            return this.memCostForEachPartition.get(partitionId);
        }
        return 0L;
    }
}

