/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.rescon;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.schema.ClusterSchemaQuotaLevel;
import org.apache.iotdb.db.exception.metadata.SchemaQuotaExceededException;

public class DataNodeSchemaQuotaManager {
    private boolean measurementLimit = false;
    private boolean deviceLimit = false;
    private final AtomicLong measurementRemain = new AtomicLong(0L);
    private final AtomicLong deviceRemain = new AtomicLong(0L);

    public void updateRemain(long measurementRemain, long deviceRemain) {
        if (measurementRemain == -1L) {
            this.measurementLimit = false;
        } else {
            this.measurementLimit = true;
            this.measurementRemain.set(measurementRemain);
        }
        if (deviceRemain == -1L) {
            this.deviceLimit = false;
        } else {
            this.deviceLimit = true;
            this.deviceRemain.set(deviceRemain);
        }
    }

    private void checkMeasurementLevel(long acquireNumber) throws SchemaQuotaExceededException {
        if (this.measurementLimit) {
            if (this.measurementRemain.get() <= 0L) {
                throw new SchemaQuotaExceededException(ClusterSchemaQuotaLevel.TIMESERIES);
            }
            this.measurementRemain.addAndGet(-acquireNumber);
        }
    }

    private void checkDeviceLevel() throws SchemaQuotaExceededException {
        if (this.deviceLimit) {
            if (this.deviceRemain.get() <= 0L) {
                throw new SchemaQuotaExceededException(ClusterSchemaQuotaLevel.DEVICE);
            }
            this.deviceRemain.addAndGet(-1L);
        }
    }

    public void check(long acquireMeasurementNumber, int acquireDeviceNumber) throws SchemaQuotaExceededException {
        if (acquireDeviceNumber > 0) {
            this.checkDeviceLevel();
        }
        try {
            this.checkMeasurementLevel(acquireMeasurementNumber);
        }
        catch (SchemaQuotaExceededException e) {
            if (acquireDeviceNumber > 0) {
                this.deviceRemain.addAndGet(1L);
            }
            throw e;
        }
    }

    public boolean isMeasurementLimit() {
        return this.measurementLimit;
    }

    public boolean isDeviceLimit() {
        return this.deviceLimit;
    }

    private DataNodeSchemaQuotaManager() {
    }

    public static DataNodeSchemaQuotaManager getInstance() {
        return DataNodeSchemaQuotaManagerHolder.INSTANCE;
    }

    private static class DataNodeSchemaQuotaManagerHolder {
        private static final DataNodeSchemaQuotaManager INSTANCE = new DataNodeSchemaQuotaManager();

        private DataNodeSchemaQuotaManagerHolder() {
        }
    }
}

