/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.scalar;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;

public class DiffFunctionTransformer
extends UnaryTransformer {
    private final boolean ignoreNull;
    private double lastValue;
    private boolean lastValueIsNull = true;

    public DiffFunctionTransformer(LayerReader layerReader, boolean ignoreNull) {
        super(layerReader);
        this.ignoreNull = ignoreNull;
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.DOUBLE};
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) throws QueryProcessException {
        switch (this.layerReaderDataType) {
            case INT32: {
                this.transformInt(columns, builder);
                return;
            }
            case INT64: {
                this.transformLong(columns, builder);
                return;
            }
            case FLOAT: {
                this.transformFloat(columns, builder);
                return;
            }
            case DOUBLE: {
                this.transformDouble(columns, builder);
                return;
            }
        }
        throw new QueryProcessException("Unsupported data type: " + this.layerReaderDataType);
    }

    private void transformInt(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (columns[0].isNull(i)) {
                this.lastValueIsNull |= !this.ignoreNull;
                builder.appendNull();
                continue;
            }
            double currentValue = columns[0].getInt(i);
            if (this.lastValueIsNull) {
                builder.appendNull();
            } else {
                builder.writeDouble(currentValue - this.lastValue);
            }
            this.lastValue = currentValue;
            this.lastValueIsNull = false;
        }
    }

    private void transformLong(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (columns[0].isNull(i)) {
                this.lastValueIsNull |= !this.ignoreNull;
                builder.appendNull();
                continue;
            }
            double currentValue = columns[0].getLong(i);
            if (this.lastValueIsNull) {
                builder.appendNull();
            } else {
                builder.writeDouble(currentValue - this.lastValue);
            }
            this.lastValue = currentValue;
            this.lastValueIsNull = false;
        }
    }

    private void transformFloat(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (columns[0].isNull(i)) {
                this.lastValueIsNull |= !this.ignoreNull;
                builder.appendNull();
                continue;
            }
            double currentValue = columns[0].getFloat(i);
            if (this.lastValueIsNull) {
                builder.appendNull();
            } else {
                builder.writeDouble(currentValue - this.lastValue);
            }
            this.lastValue = currentValue;
            this.lastValueIsNull = false;
        }
    }

    private void transformDouble(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (columns[0].isNull(i)) {
                this.lastValueIsNull |= !this.ignoreNull;
                builder.appendNull();
                continue;
            }
            double currentValue = columns[0].getDouble(i);
            if (this.lastValueIsNull) {
                builder.appendNull();
            } else {
                builder.writeDouble(currentValue - this.lastValue);
            }
            this.lastValue = currentValue;
            this.lastValueIsNull = false;
        }
    }
}

