/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;

public class LogicNotColumnTransformer
extends UnaryColumnTransformer {
    public LogicNotColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer) {
        super(returnType, childColumnTransformer);
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.returnType.writeBoolean(columnBuilder, !this.childColumnTransformer.getType().getBoolean(column, i));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void checkType() {
        if (!this.childColumnTransformer.typeEquals(TypeEnum.BOOLEAN)) {
            throw new UnsupportedOperationException("Unsupported Type: " + this.childColumnTransformer.getType().getTypeEnum());
        }
    }
}

