/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.schemaengine.schemaregion.view.visitor.GetSourcePathsVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.view.ICreateLogicalViewPlan;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CreateLogicalViewNode
extends WritePlanNode
implements ICreateLogicalViewPlan {
    private Map<PartialPath, ViewExpression> viewPathToSourceMap;
    private TRegionReplicaSet regionReplicaSet = null;

    public CreateLogicalViewNode(PlanNodeId id, List<PartialPath> paths, List<ViewExpression> expressions) {
        super(id);
        this.viewPathToSourceMap = this.convertTargetAndSourceListsToMap(paths, expressions);
    }

    public CreateLogicalViewNode(PlanNodeId id, Map<PartialPath, ViewExpression> viewPathToSourceMap) {
        super(id);
        this.viewPathToSourceMap = viewPathToSourceMap;
    }

    public CreateLogicalViewNode(PlanNodeId id, Map<PartialPath, ViewExpression> viewPathToSourceMap, TRegionReplicaSet regionReplicaSet) {
        super(id);
        this.viewPathToSourceMap = viewPathToSourceMap;
        this.regionReplicaSet = regionReplicaSet;
    }

    protected final Map<PartialPath, ViewExpression> convertTargetAndSourceListsToMap(List<PartialPath> paths, List<ViewExpression> expressions) {
        if (paths.size() != expressions.size()) {
            return null;
        }
        HashMap<PartialPath, ViewExpression> result = new HashMap<PartialPath, ViewExpression>();
        for (int i = 0; i < paths.size(); ++i) {
            result.put(paths.get(i), expressions.get(i));
        }
        return result;
    }

    @Override
    public int getViewSize() {
        return this.viewPathToSourceMap.size();
    }

    @Override
    public Map<PartialPath, ViewExpression> getViewPathToSourceExpressionMap() {
        return this.viewPathToSourceMap;
    }

    @Override
    public List<PartialPath> getViewPathList() {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>(this.viewPathToSourceMap.keySet());
        return result;
    }

    @Override
    public void setViewPathToSourceExpressionMap(Map<PartialPath, ViewExpression> viewPathToSourceExpressionMap) {
        this.viewPathToSourceMap = viewPathToSourceExpressionMap;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C schemaRegion) {
        return visitor.visitCreateLogicalView(this, schemaRegion);
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.CREATE_LOGICAL_VIEW;
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("Clone of CreateMultiTimeSeriesNode is not implemented");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateLogicalViewNode that = (CreateLogicalViewNode)obj;
        return this.getPlanNodeId().equals(that.getPlanNodeId()) && Objects.equals(this.viewPathToSourceMap, that.viewPathToSourceMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getPlanNodeId(), this.viewPathToSourceMap);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new NotImplementedException("getOutputColumnNames of CreateMultiTimeSeriesNode is not implemented");
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.CREATE_LOGICAL_VIEW.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.viewPathToSourceMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<PartialPath, ViewExpression> entry : this.viewPathToSourceMap.entrySet()) {
            entry.getKey().serialize(byteBuffer);
            ViewExpression.serialize((ViewExpression)entry.getValue(), (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.CREATE_LOGICAL_VIEW.serialize(stream);
        ReadWriteIOUtils.write((int)this.viewPathToSourceMap.size(), (OutputStream)stream);
        for (Map.Entry<PartialPath, ViewExpression> entry : this.viewPathToSourceMap.entrySet()) {
            entry.getKey().serialize((OutputStream)stream);
            ViewExpression.serialize((ViewExpression)entry.getValue(), (OutputStream)stream);
        }
    }

    public static CreateLogicalViewNode deserialize(ByteBuffer byteBuffer) {
        HashMap<PartialPath, ViewExpression> viewPathToSourceMap = new HashMap<PartialPath, ViewExpression>();
        int size = byteBuffer.getInt();
        for (int i = 0; i < size; ++i) {
            PartialPath path = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
            ViewExpression viewExpression = ViewExpression.deserialize((ByteBuffer)byteBuffer);
            viewPathToSourceMap.put(path, viewExpression);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new CreateLogicalViewNode(planNodeId, viewPathToSourceMap);
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        HashMap<TRegionReplicaSet, Map> splitMap = new HashMap<TRegionReplicaSet, Map>();
        for (Map.Entry<PartialPath, ViewExpression> entry : this.viewPathToSourceMap.entrySet()) {
            TRegionReplicaSet regionReplicaSet = analysis.getSchemaPartitionInfo().getSchemaRegionReplicaSet(entry.getKey().getDevice());
            splitMap.computeIfAbsent(regionReplicaSet, k -> new HashMap()).put(entry.getKey(), entry.getValue());
        }
        ArrayList<WritePlanNode> result = new ArrayList<WritePlanNode>();
        int maxSingleRequestSize = IoTDBDescriptor.getInstance().getConfig().getMaxMeasurementNumOfInternalRequest();
        for (Map.Entry entry : splitMap.entrySet()) {
            if (((Map)entry.getValue()).size() > maxSingleRequestSize) {
                for (Map<PartialPath, ViewExpression> splitRequest : this.splitRequest((Map)entry.getValue(), maxSingleRequestSize)) {
                    result.add(new CreateLogicalViewNode(this.getPlanNodeId(), splitRequest, (TRegionReplicaSet)entry.getKey()));
                }
                continue;
            }
            result.add(new CreateLogicalViewNode(this.getPlanNodeId(), (Map)entry.getValue(), (TRegionReplicaSet)entry.getKey()));
        }
        return result;
    }

    private List<Map<PartialPath, ViewExpression>> splitRequest(Map<PartialPath, ViewExpression> rawRequest, int maxSize) {
        int num = 0;
        ArrayList<Map<PartialPath, ViewExpression>> result = new ArrayList<Map<PartialPath, ViewExpression>>(rawRequest.size() / maxSize + 1);
        HashMap<PartialPath, ViewExpression> map = new HashMap<PartialPath, ViewExpression>();
        for (Map.Entry<PartialPath, ViewExpression> entry : rawRequest.entrySet()) {
            if (num == maxSize) {
                result.add(map);
                num = 0;
                map = new HashMap();
            }
            map.put(entry.getKey(), entry.getValue());
            ++num;
        }
        if (num > 0) {
            result.add(map);
        }
        return result;
    }

    public List<PartialPath> getAllTimeSeriesPathInSource() {
        ArrayList<ViewExpression> sourceExpressions = new ArrayList<ViewExpression>();
        for (Map.Entry<PartialPath, ViewExpression> entry : this.viewPathToSourceMap.entrySet()) {
            sourceExpressions.add(entry.getValue());
        }
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        GetSourcePathsVisitor getSourcePathsVisitor = new GetSourcePathsVisitor();
        for (ViewExpression expression : sourceExpressions) {
            result.addAll((Collection)getSourcePathsVisitor.process(expression, null));
        }
        return result;
    }
}

