/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.lastcache;

import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.SchemaCacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.lastcache.ILastCacheContainer;
import org.apache.tsfile.read.TimeValuePair;

public class DataNodeLastCacheManager {
    private static final boolean CACHE_ENABLED = CommonDescriptor.getInstance().getConfig().isLastCacheEnable();

    public static TimeValuePair getLastCache(SchemaCacheEntry entry) {
        if (!CACHE_ENABLED || null == entry) {
            return null;
        }
        ILastCacheContainer lastCacheContainer = entry.getLastCacheContainer();
        return lastCacheContainer == null ? null : lastCacheContainer.getCachedLast();
    }

    public static int updateLastCache(SchemaCacheEntry entry, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        if (!CACHE_ENABLED || null == entry) {
            return 0;
        }
        return entry.updateLastCache(timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public static int invalidateLastCache(SchemaCacheEntry entry) {
        if (!CACHE_ENABLED || null == entry) {
            return 0;
        }
        return entry.invalidateLastCache();
    }
}

