/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionFactory;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.UnknownExpressionTypeException;
import org.apache.iotdb.db.queryengine.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.logical.PredicateCanPushDownToSourceChecker;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.logical.TimeFilterExistChecker;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate.ConvertPredicateToFilterVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate.ConvertPredicateToTimeFilterVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate.PredicatePushIntoScanChecker;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate.PredicateSimplifier;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.predicate.ReversePredicateVisitor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Pair;

public class PredicateUtils {
    private PredicateUtils() {
    }

    public static Pair<Expression, Boolean> extractGlobalTimePredicate(Expression predicate, boolean canRewrite, boolean isFirstOr) {
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_AND)) {
            Pair<Expression, Boolean> leftResultPair = PredicateUtils.extractGlobalTimePredicate(((BinaryExpression)predicate).getLeftExpression(), canRewrite, isFirstOr);
            Pair<Expression, Boolean> rightResultPair = PredicateUtils.extractGlobalTimePredicate(((BinaryExpression)predicate).getRightExpression(), canRewrite, isFirstOr);
            if (canRewrite) {
                if (leftResultPair.left != null && !((Boolean)leftResultPair.right).booleanValue()) {
                    ((BinaryExpression)predicate).setLeftExpression(new ConstantOperand(TSDataType.BOOLEAN, "true"));
                }
                if (rightResultPair.left != null && !((Boolean)rightResultPair.right).booleanValue()) {
                    ((BinaryExpression)predicate).setRightExpression(new ConstantOperand(TSDataType.BOOLEAN, "true"));
                }
            }
            if (leftResultPair.left != null && rightResultPair.left != null) {
                return new Pair((Object)ExpressionFactory.and((Expression)leftResultPair.left, (Expression)rightResultPair.left), (Object)((Boolean)leftResultPair.right != false || (Boolean)rightResultPair.right != false ? 1 : 0));
            }
            if (leftResultPair.left != null) {
                return new Pair((Object)((Expression)leftResultPair.left), (Object)true);
            }
            if (rightResultPair.left != null) {
                return new Pair((Object)((Expression)rightResultPair.left), (Object)true);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_OR)) {
            Pair<Expression, Boolean> leftResultPair = PredicateUtils.extractGlobalTimePredicate(((BinaryExpression)predicate).getLeftExpression(), false, false);
            Pair<Expression, Boolean> rightResultPair = PredicateUtils.extractGlobalTimePredicate(((BinaryExpression)predicate).getRightExpression(), false, false);
            if (leftResultPair.left != null && rightResultPair.left != null) {
                if (Boolean.TRUE.equals(isFirstOr && (Boolean)leftResultPair.right == false && (Boolean)rightResultPair.right == false)) {
                    ((BinaryExpression)predicate).setLeftExpression(new ConstantOperand(TSDataType.BOOLEAN, "true"));
                    ((BinaryExpression)predicate).setRightExpression(new ConstantOperand(TSDataType.BOOLEAN, "true"));
                }
                return new Pair((Object)ExpressionFactory.or((Expression)leftResultPair.left, (Expression)rightResultPair.left), (Object)((Boolean)leftResultPair.right != false || (Boolean)rightResultPair.right != false ? 1 : 0));
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_NOT)) {
            Pair<Expression, Boolean> childResultPair = PredicateUtils.extractGlobalTimePredicate(((UnaryExpression)predicate).getExpression(), canRewrite, isFirstOr);
            if (childResultPair.left != null) {
                return new Pair((Object)ExpressionFactory.not((Expression)childResultPair.left), (Object)((Boolean)childResultPair.right));
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.isCompareBinaryExpression()) {
            Expression rightExpression;
            Expression leftExpression = ((BinaryExpression)predicate).getLeftExpression();
            if (PredicateUtils.checkIsTimeFilter(leftExpression, rightExpression = ((BinaryExpression)predicate).getRightExpression()) || PredicateUtils.checkIsTimeFilter(rightExpression, leftExpression)) {
                return new Pair((Object)predicate, (Object)false);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.LIKE) || predicate.getExpressionType().equals((Object)ExpressionType.REGEXP)) {
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.BETWEEN)) {
            Expression firstExpression = ((TernaryExpression)predicate).getFirstExpression();
            Expression secondExpression = ((TernaryExpression)predicate).getSecondExpression();
            Expression thirdExpression = ((TernaryExpression)predicate).getThirdExpression();
            boolean isTimeFilter = false;
            if (firstExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
                isTimeFilter = PredicateUtils.checkBetweenConstantSatisfy(secondExpression, thirdExpression);
            } else if (secondExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
                isTimeFilter = PredicateUtils.checkBetweenConstantSatisfy(firstExpression, thirdExpression);
            } else if (thirdExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
                isTimeFilter = PredicateUtils.checkBetweenConstantSatisfy(secondExpression, firstExpression);
            }
            if (isTimeFilter) {
                return new Pair((Object)predicate, (Object)false);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.IS_NULL)) {
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.IN)) {
            Expression timeExpression = ((InExpression)predicate).getExpression();
            if (timeExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP)) {
                return new Pair((Object)predicate, (Object)false);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.TIMESERIES) || predicate.getExpressionType().equals((Object)ExpressionType.CONSTANT) || predicate.getExpressionType().equals((Object)ExpressionType.NULL)) {
            return new Pair(null, (Object)true);
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.CASE_WHEN_THEN)) {
            return new Pair(null, (Object)true);
        }
        if (ExpressionType.FUNCTION.equals((Object)predicate.getExpressionType())) {
            return new Pair(null, (Object)true);
        }
        throw new UnknownExpressionTypeException(predicate.getExpressionType());
    }

    private static boolean checkIsTimeFilter(Expression timeExpression, Expression valueExpression) {
        return timeExpression.getExpressionType().equals((Object)ExpressionType.TIMESTAMP) && valueExpression instanceof ConstantOperand && ((ConstantOperand)valueExpression).getDataType() == TSDataType.INT64;
    }

    private static boolean checkBetweenConstantSatisfy(Expression e1, Expression e2) {
        return e1.isConstantOperand() && e2.isConstantOperand() && ((ConstantOperand)e1).getDataType() == TSDataType.INT64 && ((ConstantOperand)e2).getDataType() == TSDataType.INT64 && Long.parseLong(((ConstantOperand)e1).getValueString()) <= Long.parseLong(((ConstantOperand)e2).getValueString());
    }

    public static boolean checkIfTimeFilterExist(Expression predicate) {
        return (Boolean)new TimeFilterExistChecker().process(predicate, null);
    }

    public static Expression predicateRemoveNot(Expression predicate) {
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_AND)) {
            return ExpressionFactory.and(PredicateUtils.predicateRemoveNot(((BinaryExpression)predicate).getLeftExpression()), PredicateUtils.predicateRemoveNot(((BinaryExpression)predicate).getRightExpression()));
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_OR)) {
            return ExpressionFactory.or(PredicateUtils.predicateRemoveNot(((BinaryExpression)predicate).getLeftExpression()), PredicateUtils.predicateRemoveNot(((BinaryExpression)predicate).getRightExpression()));
        }
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_NOT)) {
            return PredicateUtils.reversePredicate(((LogicNotExpression)predicate).getExpression());
        }
        return predicate;
    }

    public static Expression reversePredicate(Expression predicate) {
        return (Expression)new ReversePredicateVisitor().process(predicate, null);
    }

    public static Expression simplifyPredicate(Expression predicate) {
        return (Expression)new PredicateSimplifier().process(predicate, null);
    }

    public static Filter convertPredicateToTimeFilter(Expression predicate) {
        if (predicate == null) {
            return null;
        }
        return predicate.accept(new ConvertPredicateToTimeFilterVisitor(), null);
    }

    public static Filter convertPredicateToFilter(Expression predicate, List<String> allMeasurements, boolean isBuildPlanUseTemplate, TypeProvider typeProvider, ZoneId zoneId) {
        if (predicate == null) {
            return null;
        }
        return predicate.accept(new ConvertPredicateToFilterVisitor(), new ConvertPredicateToFilterVisitor.Context(allMeasurements, isBuildPlanUseTemplate, typeProvider, zoneId));
    }

    public static Expression combineConjuncts(List<Expression> conjuncts) {
        if (conjuncts.size() == 1) {
            return conjuncts.get(0);
        }
        return PredicateUtils.constructRightDeepTreeWithAnd(conjuncts);
    }

    private static Expression constructRightDeepTreeWithAnd(List<Expression> conjuncts) {
        if (conjuncts.size() == 2) {
            return new LogicAndExpression(conjuncts.get(0), conjuncts.get(1));
        }
        return new LogicAndExpression(conjuncts.get(0), PredicateUtils.constructRightDeepTreeWithAnd(conjuncts.subList(1, conjuncts.size())));
    }

    public static Expression removeDuplicateConjunct(Expression predicate) {
        if (predicate == null) {
            return null;
        }
        HashSet<Expression> conjuncts = new HashSet<Expression>();
        PredicateUtils.extractConjuncts(predicate, conjuncts);
        return PredicateUtils.combineConjuncts(new ArrayList<Expression>(conjuncts));
    }

    public static List<Expression> extractConjuncts(Expression predicate) {
        HashSet<Expression> conjuncts = new HashSet<Expression>();
        PredicateUtils.extractConjuncts(predicate, conjuncts);
        return new ArrayList<Expression>(conjuncts);
    }

    private static void extractConjuncts(Expression predicate, Set<Expression> conjuncts) {
        if (predicate.getExpressionType().equals((Object)ExpressionType.LOGIC_AND)) {
            PredicateUtils.extractConjuncts(((BinaryExpression)predicate).getLeftExpression(), conjuncts);
            PredicateUtils.extractConjuncts(((BinaryExpression)predicate).getRightExpression(), conjuncts);
        } else {
            conjuncts.add(predicate);
        }
    }

    public static PartialPath extractPredicateSourceSymbol(Expression predicate) {
        List<Expression> sourceExpressions = ExpressionAnalyzer.searchSourceExpressions(predicate);
        Set sourcePaths = sourceExpressions.stream().map(expression -> ((TimeSeriesOperand)expression).getPath()).collect(Collectors.toSet());
        Iterator pathIterator = sourcePaths.iterator();
        MeasurementPath firstPath = (MeasurementPath)pathIterator.next();
        if (sourcePaths.size() == 1) {
            return firstPath.isUnderAlignedEntity() ? firstPath.getDevicePath() : firstPath;
        }
        if (!firstPath.isUnderAlignedEntity()) {
            return null;
        }
        PartialPath checkedDevice = firstPath.getDevicePath();
        while (pathIterator.hasNext()) {
            MeasurementPath path = (MeasurementPath)pathIterator.next();
            if (path.isUnderAlignedEntity() && path.getDevicePath().equals((Object)checkedDevice)) continue;
            return null;
        }
        return checkedDevice;
    }

    public static boolean predicateCanPushDownToSource(Expression predicate) {
        return (Boolean)new PredicateCanPushDownToSourceChecker().process(predicate, null);
    }

    public static boolean predicateCanPushIntoScan(Expression predicate) {
        return (Boolean)new PredicatePushIntoScanChecker().process(predicate, null);
    }
}

