/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeVisitor;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.tsfile.utils.Pair;

public class GroupByLevelHelper {
    private final int[] levels;
    private final Map<Expression, Set<Expression>> groupedAggregationExpressionToRawExpressionsMap;
    private final RawPathToGroupedPathMap rawPathToGroupedPathMap;
    private final Map<String, String> columnToAliasMap;
    private final Map<String, String> aliasToColumnMap;
    private final Map<Expression, Set<Expression>> groupByLevelExpressions;

    public GroupByLevelHelper(int[] levels) {
        this.levels = levels;
        this.groupedAggregationExpressionToRawExpressionsMap = new HashMap<Expression, Set<Expression>>();
        this.rawPathToGroupedPathMap = new RawPathToGroupedPathMap();
        this.columnToAliasMap = new HashMap<String, String>();
        this.aliasToColumnMap = new HashMap<String, String>();
        this.groupByLevelExpressions = new LinkedHashMap<Expression, Set<Expression>>();
    }

    public Expression applyLevels(Expression expression, Analysis analysis) {
        return this.applyLevels(false, expression, null, analysis);
    }

    public Expression applyLevels(boolean isCountStar, Expression expression, String alias, Analysis analysis) {
        AnalyzeVisitor.analyzeExpressionType(analysis, expression);
        Expression outputExpression = ExpressionAnalyzer.replaceSubTreeWithView(expression, analysis);
        Expression groupedOutputExpression = ExpressionAnalyzer.replaceRawPathWithGroupedPath(outputExpression, this.rawPathToGroupedPathMap, path -> this.transformPathByLevels(isCountStar, (PartialPath)path));
        if (alias != null) {
            this.checkAliasAndUpdateAliasMap(alias, groupedOutputExpression.toString());
        }
        HashSet<Expression> rawAggregationExpressions = new HashSet<Expression>(ExpressionAnalyzer.searchAggregationExpressions(expression));
        for (Expression rawAggregationExpression : rawAggregationExpressions) {
            Expression rawOutputAggregationExpression = ExpressionAnalyzer.replaceSubTreeWithView(rawAggregationExpression, analysis);
            Expression groupedOutputAggregationExpression = ExpressionAnalyzer.replaceRawPathWithGroupedPath(rawOutputAggregationExpression, this.rawPathToGroupedPathMap, path -> this.transformPathByLevels(isCountStar, (PartialPath)path));
            groupedOutputAggregationExpression = ExpressionAnalyzer.normalizeExpression(groupedOutputAggregationExpression);
            AnalyzeVisitor.analyzeExpressionType(analysis, groupedOutputAggregationExpression);
            rawAggregationExpression = ExpressionAnalyzer.normalizeExpression(rawAggregationExpression, false);
            AnalyzeVisitor.analyzeExpressionType(analysis, rawAggregationExpression);
            this.groupedAggregationExpressionToRawExpressionsMap.computeIfAbsent(groupedOutputAggregationExpression, key -> new HashSet()).add(rawAggregationExpression);
        }
        return groupedOutputExpression;
    }

    public void updateGroupByLevelExpressions(Expression groupedExpression) {
        for (Expression groupedAggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(groupedExpression)) {
            Set<Expression> groupedExpressionSet = this.groupedAggregationExpressionToRawExpressionsMap.get(groupedAggregationExpression);
            this.groupByLevelExpressions.computeIfAbsent(groupedAggregationExpression, key -> new HashSet()).addAll(groupedExpressionSet);
        }
    }

    private void checkAliasAndUpdateAliasMap(String alias, String groupedExpressionString) {
        if (this.columnToAliasMap.get(groupedExpressionString) == null) {
            if (this.aliasToColumnMap.get(alias) != null) {
                throw new SemanticException(String.format("alias '%s' can only be matched with one result column", alias));
            }
            this.columnToAliasMap.put(groupedExpressionString, alias);
            this.aliasToColumnMap.put(alias, groupedExpressionString);
        } else if (!this.columnToAliasMap.get(groupedExpressionString).equals(alias)) {
            throw new SemanticException(String.format("Result column %s with more than one alias[%s, %s]", groupedExpressionString, this.columnToAliasMap.get(groupedExpressionString), alias));
        }
    }

    private PartialPath transformPathByLevels(boolean isCountStar, PartialPath rawPath) {
        String[] nodes = rawPath.getNodes();
        HashSet<Integer> levelSet = new HashSet<Integer>();
        for (int level : this.levels) {
            levelSet.add(level);
        }
        ArrayList<String> transformedNodes = new ArrayList<String>(nodes.length);
        transformedNodes.add(nodes[0]);
        for (int k = 1; k < nodes.length - 1; ++k) {
            if (levelSet.contains(k)) {
                transformedNodes.add(nodes[k]);
                continue;
            }
            transformedNodes.add("*");
        }
        if (isCountStar) {
            transformedNodes.add("*");
        } else {
            transformedNodes.add(nodes[nodes.length - 1]);
        }
        MeasurementPath groupedPath = new MeasurementPath(new PartialPath(transformedNodes.toArray(new String[0])), ((MeasurementPath)rawPath).getMeasurementSchema());
        if (rawPath.isMeasurementAliasExists()) {
            groupedPath.setMeasurementAlias(rawPath.getMeasurementAlias());
        }
        return groupedPath;
    }

    public Map<Expression, Set<Expression>> getGroupByLevelExpressions() {
        return this.groupByLevelExpressions;
    }

    public String getAlias(String columnName) {
        return this.columnToAliasMap.get(columnName) != null ? this.columnToAliasMap.get(columnName) : null;
    }

    public static class RawPathToGroupedPathMap {
        private final Map<Pair<PartialPath, String>, PartialPath> map = new HashMap<Pair<PartialPath, String>, PartialPath>();

        public boolean containsKey(PartialPath rawPath) {
            return this.map.containsKey(new Pair((Object)rawPath, (Object)rawPath.getMeasurementAlias()));
        }

        public void put(PartialPath rawPath, PartialPath groupedPath) {
            this.map.put((Pair<PartialPath, String>)new Pair((Object)rawPath, (Object)rawPath.getMeasurementAlias()), groupedPath);
        }

        public PartialPath get(PartialPath rawPath) {
            PartialPath groupedPath = this.map.get(new Pair((Object)rawPath, (Object)rawPath.getMeasurementAlias()));
            Preconditions.checkState((groupedPath != null ? 1 : 0) != 0, (String)"path '%s' is not analyzed in GroupByLevelHelper.", (Object)rawPath);
            return groupedPath;
        }
    }
}

