/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.exchange.sink;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.DownStreamChannelIndex;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISink;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISinkChannel;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISinkHandle;
import org.apache.iotdb.db.queryengine.metric.DataExchangeCostMetricSet;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleSinkHandle
implements ISinkHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuffleSinkHandle.class);
    private final List<ISinkChannel> downStreamChannelList;
    private final boolean[] hasSetNoMoreTsBlocks;
    private final boolean[] channelOpened;
    private final DownStreamChannelIndex downStreamChannelIndex;
    private final int channelNum;
    private final ShuffleStrategy shuffleStrategy;
    private final TFragmentInstanceId localFragmentInstanceId;
    private final MPPDataExchangeManager.SinkListener sinkListener;
    private volatile boolean aborted = false;
    private volatile boolean closed = false;
    private static final DataExchangeCostMetricSet DATA_EXCHANGE_COST_METRIC_SET = DataExchangeCostMetricSet.getInstance();
    private final Lock lock = new ReentrantLock();
    private long maxBytesCanReserve = IoTDBDescriptor.getInstance().getConfig().getMaxBytesPerFragmentInstance();
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ShuffleSinkHandle.class) + RamUsageEstimator.shallowSizeOfInstance(TFragmentInstanceId.class) + RamUsageEstimator.shallowSizeOfInstance(DownStreamChannelIndex.class);

    public ShuffleSinkHandle(TFragmentInstanceId localFragmentInstanceId, List<ISinkChannel> downStreamChannelList, DownStreamChannelIndex downStreamChannelIndex, ShuffleStrategyEnum shuffleStrategyEnum, MPPDataExchangeManager.SinkListener sinkListener) {
        this.localFragmentInstanceId = (TFragmentInstanceId)Validate.notNull((Object)localFragmentInstanceId, (String)"localFragmentInstanceId can not be null.", (Object[])new Object[0]);
        this.downStreamChannelList = (List)Validate.notNull(downStreamChannelList, (String)"downStreamChannelList can not be null.", (Object[])new Object[0]);
        this.downStreamChannelIndex = (DownStreamChannelIndex)Validate.notNull((Object)downStreamChannelIndex, (String)"downStreamChannelIndex can not be null.", (Object[])new Object[0]);
        this.sinkListener = (MPPDataExchangeManager.SinkListener)Validate.notNull((Object)sinkListener, (String)"sinkListener can not be null.", (Object[])new Object[0]);
        this.channelNum = downStreamChannelList.size();
        this.shuffleStrategy = this.getShuffleStrategy(shuffleStrategyEnum);
        this.hasSetNoMoreTsBlocks = new boolean[this.channelNum];
        this.channelOpened = new boolean[this.channelNum];
    }

    @Override
    public TFragmentInstanceId getLocalFragmentInstanceId() {
        return this.localFragmentInstanceId;
    }

    @Override
    public ISinkChannel getChannel(int index) {
        return this.downStreamChannelList.get(index);
    }

    @Override
    public synchronized ListenableFuture<?> isFull() {
        int currentIndex = this.downStreamChannelIndex.getCurrentIndex();
        this.tryOpenChannel(currentIndex);
        return this.downStreamChannelList.get(currentIndex).isFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void send(TsBlock tsBlock) {
        long startTime = System.nanoTime();
        try {
            this.checkState();
            if (this.closed) {
                return;
            }
            ISinkChannel currentChannel = this.downStreamChannelList.get(this.downStreamChannelIndex.getCurrentIndex());
            currentChannel.send(tsBlock);
        }
        finally {
            this.switchChannelIfNecessary();
            DATA_EXCHANGE_COST_METRIC_SET.recordDataExchangeCost("sink_handle_send_tsblock_remote", System.nanoTime() - startTime);
        }
    }

    @Override
    public void setNoMoreTsBlocks() {
        if (this.closed || this.aborted) {
            return;
        }
        try {
            this.lock.lock();
            for (int i = 0; i < this.downStreamChannelList.size(); ++i) {
                if (this.hasSetNoMoreTsBlocks[i]) continue;
                this.downStreamChannelList.get(i).setNoMoreTsBlocks();
                this.hasSetNoMoreTsBlocks[i] = true;
            }
            this.sinkListener.onEndOfBlocks(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setNoMoreTsBlocksOfOneChannel(int channelIndex) {
        if (this.closed || this.aborted) {
            return;
        }
        try {
            this.lock.lock();
            if (!this.hasSetNoMoreTsBlocks[channelIndex]) {
                this.downStreamChannelList.get(channelIndex).setNoMoreTsBlocks();
                this.hasSetNoMoreTsBlocks[channelIndex] = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized boolean isAborted() {
        return this.aborted;
    }

    @Override
    public synchronized boolean isFinished() {
        for (ISink iSink : this.downStreamChannelList) {
            if (iSink.isFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void abort() {
        if (this.aborted || this.closed) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[StartAbortShuffleSinkHandle]");
        }
        boolean meetError = false;
        Exception firstException = null;
        for (ISink iSink : this.downStreamChannelList) {
            try {
                iSink.abort();
            }
            catch (Exception e) {
                if (meetError) continue;
                firstException = e;
                meetError = true;
            }
        }
        if (meetError) {
            LOGGER.warn("Error occurred when try to abort channel.", firstException);
        }
        this.sinkListener.onAborted(this);
        this.aborted = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[EndAbortShuffleSinkHandle]");
        }
    }

    @Override
    public void close() {
        if (this.closed || this.aborted) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[StartCloseShuffleSinkHandle]");
        }
        boolean meetError = false;
        Exception firstException = null;
        for (ISink iSink : this.downStreamChannelList) {
            try {
                iSink.close();
            }
            catch (Exception e) {
                if (meetError) continue;
                firstException = e;
                meetError = true;
            }
        }
        if (meetError) {
            LOGGER.warn("Error occurred when try to close channel.", firstException);
        }
        this.sinkListener.onFinish(this);
        this.closed = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[EndCloseShuffleSinkHandle]");
        }
    }

    @Override
    public void setMaxBytesCanReserve(long maxBytesCanReserve) {
        this.maxBytesCanReserve = maxBytesCanReserve;
        this.downStreamChannelList.forEach(sinkHandle -> sinkHandle.setMaxBytesCanReserve(maxBytesCanReserve));
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.downStreamChannelList.stream().map(Accountable::ramBytesUsed).reduce(Long::sum).orElse(0L) + RamUsageEstimator.sizeOf((boolean[])this.channelOpened) + RamUsageEstimator.sizeOf((boolean[])this.hasSetNoMoreTsBlocks);
    }

    private void checkState() {
        if (this.aborted) {
            throw new IllegalStateException("ShuffleSinkHandle is aborted.");
        }
    }

    private void switchChannelIfNecessary() {
        this.shuffleStrategy.shuffle();
    }

    @Override
    public void tryOpenChannel(int channelIndex) {
        if (!this.channelOpened[channelIndex]) {
            this.downStreamChannelList.get(channelIndex).open();
            this.channelOpened[channelIndex] = true;
        }
    }

    @Override
    public boolean isChannelClosed(int index) {
        return this.downStreamChannelList.get(index).isClosed();
    }

    private ShuffleStrategy getShuffleStrategy(ShuffleStrategyEnum strategyEnum) {
        switch (strategyEnum) {
            case PLAIN: {
                return new PlainShuffleStrategy();
            }
            case SIMPLE_ROUND_ROBIN: {
                return new SimpleRoundRobinStrategy();
            }
        }
        throw new UnsupportedOperationException("Unsupported type of shuffle strategy");
    }

    @Override
    public long getBufferRetainedSizeInBytes() {
        return this.downStreamChannelList.stream().map(ISink::getBufferRetainedSizeInBytes).reduce(Long::sum).orElse(0L);
    }

    public static enum ShuffleStrategyEnum {
        PLAIN,
        SIMPLE_ROUND_ROBIN;

    }

    @FunctionalInterface
    static interface ShuffleStrategy {
        public void shuffle();
    }

    class PlainShuffleStrategy
    implements ShuffleStrategy {
        PlainShuffleStrategy() {
        }

        @Override
        public void shuffle() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("PlainShuffleStrategy needs to do nothing, current channel index is {}", (Object)ShuffleSinkHandle.this.downStreamChannelIndex.getCurrentIndex());
            }
        }
    }

    class SimpleRoundRobinStrategy
    implements ShuffleStrategy {
        private final long channelMemoryThreshold;

        SimpleRoundRobinStrategy() {
            this.channelMemoryThreshold = ShuffleSinkHandle.this.maxBytesCanReserve / (long)ShuffleSinkHandle.this.channelNum * 3L;
        }

        @Override
        public void shuffle() {
            int currentIndex = ShuffleSinkHandle.this.downStreamChannelIndex.getCurrentIndex();
            for (int i = 1; i < ShuffleSinkHandle.this.channelNum; ++i) {
                int nextIndex = (currentIndex + i) % ShuffleSinkHandle.this.channelNum;
                if (!this.satisfy(nextIndex)) continue;
                ShuffleSinkHandle.this.downStreamChannelIndex.setCurrentIndex(nextIndex);
                return;
            }
        }

        private boolean satisfy(int channelIndex) {
            ISinkChannel channel = (ISinkChannel)ShuffleSinkHandle.this.downStreamChannelList.get(channelIndex);
            if (channel.isNoMoreTsBlocks() || channel.isClosed()) {
                return false;
            }
            return channel.getBufferRetainedSizeInBytes() <= this.channelMemoryThreshold && channel.getNumOfBufferedTsBlocks() < 3;
        }
    }
}

