/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.util;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class PipeTabletEventSorter {
    private final Tablet tablet;
    private boolean isSorted = true;
    private boolean isDeduplicated = true;
    private Integer[] index;
    private int deduplicatedSize;

    public PipeTabletEventSorter(Tablet tablet) {
        this.tablet = tablet;
        this.deduplicatedSize = tablet == null ? 0 : tablet.rowSize;
    }

    public void deduplicateAndSortTimestampsIfNecessary() {
        int i;
        if (this.tablet == null || this.tablet.rowSize == 0) {
            return;
        }
        int size = this.tablet.rowSize;
        for (i = 1; i < size; ++i) {
            long currentTimestamp = this.tablet.timestamps[i];
            long previousTimestamp = this.tablet.timestamps[i - 1];
            if (currentTimestamp < previousTimestamp) {
                this.isSorted = false;
            }
            if (currentTimestamp == previousTimestamp) {
                this.isDeduplicated = false;
            }
            if (!this.isSorted && !this.isDeduplicated) break;
        }
        if (this.isSorted && this.isDeduplicated) {
            return;
        }
        this.index = new Integer[this.tablet.rowSize];
        size = this.tablet.rowSize;
        for (i = 0; i < size; ++i) {
            this.index[i] = i;
        }
        if (!this.isSorted) {
            this.sortTimestamps();
            this.deduplicateTimestamps();
            this.isDeduplicated = true;
        }
        if (!this.isDeduplicated) {
            this.deduplicateTimestamps();
        }
        this.sortAndDeduplicateValuesAndBitMaps();
    }

    private void sortTimestamps() {
        Arrays.sort(this.index, Comparator.comparingLong(i -> this.tablet.timestamps[i]));
        Arrays.sort(this.tablet.timestamps, 0, this.tablet.rowSize);
    }

    private void deduplicateTimestamps() {
        this.deduplicatedSize = 1;
        int size = this.tablet.rowSize;
        for (int i = 1; i < size; ++i) {
            if (this.tablet.timestamps[i] == this.tablet.timestamps[i - 1]) continue;
            this.index[this.deduplicatedSize] = this.index[i];
            this.tablet.timestamps[this.deduplicatedSize] = this.tablet.timestamps[i];
            ++this.deduplicatedSize;
        }
        this.tablet.rowSize = this.deduplicatedSize;
    }

    private void sortAndDeduplicateValuesAndBitMaps() {
        int columnIndex = 0;
        int size = this.tablet.getSchemas().size();
        for (int i = 0; i < size; ++i) {
            IMeasurementSchema schema = (IMeasurementSchema)this.tablet.getSchemas().get(i);
            if (schema == null) continue;
            this.tablet.values[columnIndex] = PipeTabletEventSorter.reorderValueList(this.deduplicatedSize, this.tablet.values[columnIndex], schema.getType(), this.index);
            if (this.tablet.bitMaps != null && this.tablet.bitMaps[columnIndex] != null) {
                this.tablet.bitMaps[columnIndex] = PipeTabletEventSorter.reorderBitMap(this.deduplicatedSize, this.tablet.bitMaps[columnIndex], this.index);
            }
            ++columnIndex;
        }
    }

    private static Object reorderValueList(int deduplicatedSize, Object valueList, TSDataType dataType, Integer[] index) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] deduplicatedBoolValues = new boolean[boolValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedBoolValues[i] = boolValues[index[i]];
                }
                return deduplicatedBoolValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] deduplicatedIntValues = new int[intValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedIntValues[i] = intValues[index[i]];
                }
                return deduplicatedIntValues;
            }
            case DATE: {
                LocalDate[] dateValues = (LocalDate[])valueList;
                LocalDate[] deduplicatedDateValues = new LocalDate[dateValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedDateValues[i] = dateValues[index[i]];
                }
                return deduplicatedDateValues;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])valueList;
                long[] deduplicatedLongValues = new long[longValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedLongValues[i] = longValues[index[i]];
                }
                return deduplicatedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] deduplicatedFloatValues = new float[floatValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedFloatValues[i] = floatValues[index[i]];
                }
                return deduplicatedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] deduplicatedDoubleValues = new double[doubleValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedDoubleValues[i] = doubleValues[index[i]];
                }
                return deduplicatedDoubleValues;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] deduplicatedBinaryValues = new Binary[binaryValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedBinaryValues[i] = binaryValues[index[i]];
                }
                return deduplicatedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
    }

    private static BitMap reorderBitMap(int deduplicatedSize, BitMap bitMap, Integer[] index) {
        BitMap deduplicatedBitMap = new BitMap(bitMap.getSize());
        for (int i = 0; i < deduplicatedSize; ++i) {
            if (!bitMap.isMarked(index[i].intValue())) continue;
            deduplicatedBitMap.mark(i);
        }
        return deduplicatedBitMap;
    }
}

