/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.sync;

import java.net.UnknownHostException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClient;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClientManager;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBSslSyncConnector;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.client.IoTDBDataNodeSyncClientManager;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferPlanNodeReq;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBDataNodeSyncConnector
extends IoTDBSslSyncConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataNodeSyncConnector.class);
    protected IoTDBDataNodeSyncClientManager clientManager;

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        IoTDBConfig iotdbConfig = IoTDBDescriptor.getInstance().getConfig();
        LinkedHashSet givenNodeUrls = this.parseNodeUrls(validator.getParameters());
        validator.validate(empty -> {
            try {
                return !NodeUrlUtils.containsLocalAddress(givenNodeUrls.stream().filter(tEndPoint -> tEndPoint.getPort() == iotdbConfig.getRpcPort()).map(TEndPoint::getIp).collect(Collectors.toList()));
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Unknown host when checking pipe sink IP.", (Throwable)e);
                return false;
            }
        }, String.format("One of the endpoints %s of the receivers is pointing back to the thrift receiver %s on sender itself, or unknown host when checking pipe sink IP.", givenNodeUrls, new TEndPoint(iotdbConfig.getRpcAddress(), iotdbConfig.getRpcPort())), new Object[0]);
    }

    protected IoTDBSyncClientManager constructClient(List<TEndPoint> nodeUrls, String username, String password, boolean useSSL, String trustStorePath, String trustStorePwd, boolean useLeaderCache, String loadBalanceStrategy, boolean shouldReceiverConvertOnTypeMismatch, String loadTsFileStrategy, boolean validateTsFile, boolean shouldMarkAsPipeRequest) {
        this.clientManager = new IoTDBDataNodeSyncClientManager(nodeUrls, username, password, useSSL, Objects.nonNull(trustStorePath) ? IoTDBConfig.addDataHomeDir(trustStorePath) : null, trustStorePwd, useLeaderCache, loadBalanceStrategy, shouldReceiverConvertOnTypeMismatch, loadTsFileStrategy, validateTsFile, shouldMarkAsPipeRequest);
        return this.clientManager;
    }

    protected void doTransferWrapper(PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException {
        if (!pipeSchemaRegionWritePlanEvent.increaseReferenceCount(IoTDBDataNodeSyncConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeSchemaRegionWritePlanEvent);
        }
        finally {
            pipeSchemaRegionWritePlanEvent.decreaseReferenceCount(IoTDBDataNodeSyncConnector.class.getName(), false);
        }
    }

    protected void doTransfer(PipeSchemaRegionWritePlanEvent pipeSchemaRegionWritePlanEvent) throws PipeException {
        TPipeTransferResp resp;
        Pair clientAndStatus = this.clientManager.getClient();
        try {
            TPipeTransferReq req = this.compressIfNeeded(PipeTransferPlanNodeReq.toTPipeTransferReq(pipeSchemaRegionWritePlanEvent.getPlanNode()));
            this.rateLimitIfNeeded(pipeSchemaRegionWritePlanEvent.getPipeName(), pipeSchemaRegionWritePlanEvent.getCreationTime(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), req.getBody().length);
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when transfer schema region write plan %s, because %s.", new Object[]{pipeSchemaRegionWritePlanEvent.getPlanNode().getType(), e.getMessage()}), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && resp.getStatus().getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("Transfer data node write plan %s error, result status %s.", new Object[]{pipeSchemaRegionWritePlanEvent.getPlanNode().getType(), status}), pipeSchemaRegionWritePlanEvent.getPlanNode().toString());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully transferred schema event {}.", (Object)pipeSchemaRegionWritePlanEvent);
        }
    }
}

