/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferCompressedReq;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventPlainBatch;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBatchReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBDataRegionAsyncConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTrackableHandler;
import org.apache.iotdb.db.pipe.connector.util.LeaderCacheUtils;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferTabletBatchEventHandler
extends PipeTransferTrackableHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTabletBatchEventHandler.class);
    private final List<EnrichedEvent> events;
    private final Map<Pair<String, Long>, Long> pipeName2BytesAccumulated;
    private final TPipeTransferReq req;
    private final double reqCompressionRatio;

    public PipeTransferTabletBatchEventHandler(PipeTabletEventPlainBatch batch, IoTDBDataRegionAsyncConnector connector) throws IOException {
        super(connector);
        this.events = batch.deepCopyEvents();
        this.pipeName2BytesAccumulated = batch.deepCopyPipeName2BytesAccumulated();
        PipeTransferTabletBatchReq uncompressedReq = batch.toTPipeTransferReq();
        this.req = connector.isRpcCompressionEnabled() ? PipeTransferCompressedReq.toTPipeTransferReq((TPipeTransferReq)uncompressedReq, (List)connector.getCompressors()) : uncompressedReq;
        this.reqCompressionRatio = (double)this.req.getBody().length / (double)uncompressedReq.getBody().length;
    }

    public void transfer(AsyncPipeDataTransferServiceClient client) throws TException {
        for (Map.Entry<Pair<String, Long>, Long> entry : this.pipeName2BytesAccumulated.entrySet()) {
            this.connector.rateLimitIfNeeded((String)entry.getKey().getLeft(), (Long)entry.getKey().getRight(), client.getEndPoint(), (long)((double)entry.getValue().longValue() * this.reqCompressionRatio));
        }
        this.tryTransfer(client, this.req);
    }

    @Override
    protected boolean onCompleteInternal(TPipeTransferResp response) {
        if (response == null) {
            this.onError((Exception)((Object)new PipeException("TPipeTransferResp is null")));
            return false;
        }
        try {
            TSStatus status = response.getStatus();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                this.connector.statusHandler().handle(status, response.getStatus().getMessage(), this.events.toString());
            }
            for (Pair<String, TEndPoint> redirectPair : LeaderCacheUtils.parseRecommendedRedirections(status)) {
                this.connector.updateLeaderCache((String)redirectPair.getLeft(), (TEndPoint)redirectPair.getRight());
            }
            this.events.forEach(event -> event.decreaseReferenceCount(PipeTransferTabletBatchEventHandler.class.getName(), true));
        }
        catch (Exception e) {
            this.onError(e);
            return false;
        }
        return true;
    }

    @Override
    protected void onErrorInternal(Exception exception) {
        try {
            LOGGER.warn("Failed to transfer TabletInsertionEvent batch. Total failed events: {}, related pipe names: {}", new Object[]{this.events.size(), this.events.stream().map(EnrichedEvent::getPipeName).collect(Collectors.toSet()), exception});
        }
        finally {
            this.connector.addFailureEventsToRetryQueue(this.events);
        }
    }

    @Override
    protected void doTransfer(AsyncPipeDataTransferServiceClient client, TPipeTransferReq req) throws TException {
        client.pipeTransfer(req, (AsyncMethodCallback)this);
    }

    @Override
    public void clearEventsReferenceCount() {
        this.events.forEach(event -> event.clearReferenceCount(PipeTransferTabletBatchEventHandler.class.getName()));
    }
}

