/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.thrift.transport.TTransportException;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Driver.class}, immediate=true)
public class IoTDBDriver
implements Driver {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBDriver.class);
    private static final boolean TSFILE_JDBC_COMPLIANT = false;
    private static final String TSFILE_URL_PREFIX = "jdbc:iotdb://.*";

    @Override
    public boolean acceptsURL(String url) {
        return Pattern.matches(TSFILE_URL_PREFIX, url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            return this.acceptsURL(url) ? new IoTDBConnection(url, info) : null;
        }
        catch (TTransportException e) {
            throw new SQLException("Connection Error, please check whether the network is available or the server has started.", e);
        }
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new IoTDBDriver());
        }
        catch (SQLException e) {
            logger.error("Error occurs when registering TsFile driver", (Throwable)e);
        }
    }
}

