/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SessionSecurityDiagnosticsDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=868");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=869");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=870");
    private final NodeId sessionId;
    private final String clientUserIdOfSession;
    private final String[] clientUserIdHistory;
    private final String authenticationMechanism;
    private final String encoding;
    private final String transportProtocol;
    private final MessageSecurityMode securityMode;
    private final String securityPolicyUri;
    private final ByteString clientCertificate;

    public SessionSecurityDiagnosticsDataType(NodeId sessionId, String clientUserIdOfSession, String[] clientUserIdHistory, String authenticationMechanism, String encoding, String transportProtocol, MessageSecurityMode securityMode, String securityPolicyUri, ByteString clientCertificate) {
        this.sessionId = sessionId;
        this.clientUserIdOfSession = clientUserIdOfSession;
        this.clientUserIdHistory = clientUserIdHistory;
        this.authenticationMechanism = authenticationMechanism;
        this.encoding = encoding;
        this.transportProtocol = transportProtocol;
        this.securityMode = securityMode;
        this.securityPolicyUri = securityPolicyUri;
        this.clientCertificate = clientCertificate;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getSessionId() {
        return this.sessionId;
    }

    public String getClientUserIdOfSession() {
        return this.clientUserIdOfSession;
    }

    public String[] getClientUserIdHistory() {
        return this.clientUserIdHistory;
    }

    public String getAuthenticationMechanism() {
        return this.authenticationMechanism;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public ByteString getClientCertificate() {
        return this.clientCertificate;
    }

    protected SessionSecurityDiagnosticsDataType(SessionSecurityDiagnosticsDataTypeBuilder<?, ?> b) {
        super(b);
        this.sessionId = ((SessionSecurityDiagnosticsDataTypeBuilder)b).sessionId;
        this.clientUserIdOfSession = ((SessionSecurityDiagnosticsDataTypeBuilder)b).clientUserIdOfSession;
        this.clientUserIdHistory = ((SessionSecurityDiagnosticsDataTypeBuilder)b).clientUserIdHistory;
        this.authenticationMechanism = ((SessionSecurityDiagnosticsDataTypeBuilder)b).authenticationMechanism;
        this.encoding = ((SessionSecurityDiagnosticsDataTypeBuilder)b).encoding;
        this.transportProtocol = ((SessionSecurityDiagnosticsDataTypeBuilder)b).transportProtocol;
        this.securityMode = ((SessionSecurityDiagnosticsDataTypeBuilder)b).securityMode;
        this.securityPolicyUri = ((SessionSecurityDiagnosticsDataTypeBuilder)b).securityPolicyUri;
        this.clientCertificate = ((SessionSecurityDiagnosticsDataTypeBuilder)b).clientCertificate;
    }

    public static SessionSecurityDiagnosticsDataTypeBuilder<?, ?> builder() {
        return new SessionSecurityDiagnosticsDataTypeBuilderImpl();
    }

    public SessionSecurityDiagnosticsDataTypeBuilder<?, ?> toBuilder() {
        return new SessionSecurityDiagnosticsDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionSecurityDiagnosticsDataType)) {
            return false;
        }
        SessionSecurityDiagnosticsDataType other = (SessionSecurityDiagnosticsDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$sessionId = this.getSessionId();
        NodeId other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        String this$clientUserIdOfSession = this.getClientUserIdOfSession();
        String other$clientUserIdOfSession = other.getClientUserIdOfSession();
        if (this$clientUserIdOfSession == null ? other$clientUserIdOfSession != null : !this$clientUserIdOfSession.equals(other$clientUserIdOfSession)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getClientUserIdHistory(), other.getClientUserIdHistory())) {
            return false;
        }
        String this$authenticationMechanism = this.getAuthenticationMechanism();
        String other$authenticationMechanism = other.getAuthenticationMechanism();
        if (this$authenticationMechanism == null ? other$authenticationMechanism != null : !this$authenticationMechanism.equals(other$authenticationMechanism)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        String this$transportProtocol = this.getTransportProtocol();
        String other$transportProtocol = other.getTransportProtocol();
        if (this$transportProtocol == null ? other$transportProtocol != null : !this$transportProtocol.equals(other$transportProtocol)) {
            return false;
        }
        MessageSecurityMode this$securityMode = this.getSecurityMode();
        MessageSecurityMode other$securityMode = other.getSecurityMode();
        if (this$securityMode == null ? other$securityMode != null : !this$securityMode.equals(other$securityMode)) {
            return false;
        }
        String this$securityPolicyUri = this.getSecurityPolicyUri();
        String other$securityPolicyUri = other.getSecurityPolicyUri();
        if (this$securityPolicyUri == null ? other$securityPolicyUri != null : !this$securityPolicyUri.equals(other$securityPolicyUri)) {
            return false;
        }
        ByteString this$clientCertificate = this.getClientCertificate();
        ByteString other$clientCertificate = other.getClientCertificate();
        return !(this$clientCertificate == null ? other$clientCertificate != null : !((Object)this$clientCertificate).equals(other$clientCertificate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SessionSecurityDiagnosticsDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        String $clientUserIdOfSession = this.getClientUserIdOfSession();
        result = result * 59 + ($clientUserIdOfSession == null ? 43 : $clientUserIdOfSession.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getClientUserIdHistory());
        String $authenticationMechanism = this.getAuthenticationMechanism();
        result = result * 59 + ($authenticationMechanism == null ? 43 : $authenticationMechanism.hashCode());
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        String $transportProtocol = this.getTransportProtocol();
        result = result * 59 + ($transportProtocol == null ? 43 : $transportProtocol.hashCode());
        MessageSecurityMode $securityMode = this.getSecurityMode();
        result = result * 59 + ($securityMode == null ? 43 : $securityMode.hashCode());
        String $securityPolicyUri = this.getSecurityPolicyUri();
        result = result * 59 + ($securityPolicyUri == null ? 43 : $securityPolicyUri.hashCode());
        ByteString $clientCertificate = this.getClientCertificate();
        result = result * 59 + ($clientCertificate == null ? 43 : ((Object)$clientCertificate).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SessionSecurityDiagnosticsDataType(sessionId=" + this.getSessionId() + ", clientUserIdOfSession=" + this.getClientUserIdOfSession() + ", clientUserIdHistory=" + Arrays.deepToString(this.getClientUserIdHistory()) + ", authenticationMechanism=" + this.getAuthenticationMechanism() + ", encoding=" + this.getEncoding() + ", transportProtocol=" + this.getTransportProtocol() + ", securityMode=" + this.getSecurityMode() + ", securityPolicyUri=" + this.getSecurityPolicyUri() + ", clientCertificate=" + this.getClientCertificate() + ")";
    }

    private static final class SessionSecurityDiagnosticsDataTypeBuilderImpl
    extends SessionSecurityDiagnosticsDataTypeBuilder<SessionSecurityDiagnosticsDataType, SessionSecurityDiagnosticsDataTypeBuilderImpl> {
        private SessionSecurityDiagnosticsDataTypeBuilderImpl() {
        }

        @Override
        protected SessionSecurityDiagnosticsDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public SessionSecurityDiagnosticsDataType build() {
            return new SessionSecurityDiagnosticsDataType(this);
        }
    }

    public static abstract class SessionSecurityDiagnosticsDataTypeBuilder<C extends SessionSecurityDiagnosticsDataType, B extends SessionSecurityDiagnosticsDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId sessionId;
        private String clientUserIdOfSession;
        private String[] clientUserIdHistory;
        private String authenticationMechanism;
        private String encoding;
        private String transportProtocol;
        private MessageSecurityMode securityMode;
        private String securityPolicyUri;
        private ByteString clientCertificate;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SessionSecurityDiagnosticsDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SessionSecurityDiagnosticsDataType instance, SessionSecurityDiagnosticsDataTypeBuilder<?, ?> b) {
            b.sessionId(instance.sessionId);
            b.clientUserIdOfSession(instance.clientUserIdOfSession);
            b.clientUserIdHistory(instance.clientUserIdHistory);
            b.authenticationMechanism(instance.authenticationMechanism);
            b.encoding(instance.encoding);
            b.transportProtocol(instance.transportProtocol);
            b.securityMode(instance.securityMode);
            b.securityPolicyUri(instance.securityPolicyUri);
            b.clientCertificate(instance.clientCertificate);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B sessionId(NodeId sessionId) {
            this.sessionId = sessionId;
            return (B)this.self();
        }

        public B clientUserIdOfSession(String clientUserIdOfSession) {
            this.clientUserIdOfSession = clientUserIdOfSession;
            return (B)this.self();
        }

        public B clientUserIdHistory(String[] clientUserIdHistory) {
            this.clientUserIdHistory = clientUserIdHistory;
            return (B)this.self();
        }

        public B authenticationMechanism(String authenticationMechanism) {
            this.authenticationMechanism = authenticationMechanism;
            return (B)this.self();
        }

        public B encoding(String encoding) {
            this.encoding = encoding;
            return (B)this.self();
        }

        public B transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return (B)this.self();
        }

        public B securityMode(MessageSecurityMode securityMode) {
            this.securityMode = securityMode;
            return (B)this.self();
        }

        public B securityPolicyUri(String securityPolicyUri) {
            this.securityPolicyUri = securityPolicyUri;
            return (B)this.self();
        }

        public B clientCertificate(ByteString clientCertificate) {
            this.clientCertificate = clientCertificate;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SessionSecurityDiagnosticsDataType.SessionSecurityDiagnosticsDataTypeBuilder(super=" + super.toString() + ", sessionId=" + this.sessionId + ", clientUserIdOfSession=" + this.clientUserIdOfSession + ", clientUserIdHistory=" + Arrays.deepToString(this.clientUserIdHistory) + ", authenticationMechanism=" + this.authenticationMechanism + ", encoding=" + this.encoding + ", transportProtocol=" + this.transportProtocol + ", securityMode=" + this.securityMode + ", securityPolicyUri=" + this.securityPolicyUri + ", clientCertificate=" + this.clientCertificate + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SessionSecurityDiagnosticsDataType> {
        @Override
        public Class<SessionSecurityDiagnosticsDataType> getType() {
            return SessionSecurityDiagnosticsDataType.class;
        }

        @Override
        public SessionSecurityDiagnosticsDataType decode(SerializationContext context, UaDecoder decoder) {
            NodeId sessionId = decoder.readNodeId("SessionId");
            String clientUserIdOfSession = decoder.readString("ClientUserIdOfSession");
            String[] clientUserIdHistory = decoder.readStringArray("ClientUserIdHistory");
            String authenticationMechanism = decoder.readString("AuthenticationMechanism");
            String encoding = decoder.readString("Encoding");
            String transportProtocol = decoder.readString("TransportProtocol");
            MessageSecurityMode securityMode = decoder.readEnum("SecurityMode", MessageSecurityMode.class);
            String securityPolicyUri = decoder.readString("SecurityPolicyUri");
            ByteString clientCertificate = decoder.readByteString("ClientCertificate");
            return new SessionSecurityDiagnosticsDataType(sessionId, clientUserIdOfSession, clientUserIdHistory, authenticationMechanism, encoding, transportProtocol, securityMode, securityPolicyUri, clientCertificate);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SessionSecurityDiagnosticsDataType value) {
            encoder.writeNodeId("SessionId", value.getSessionId());
            encoder.writeString("ClientUserIdOfSession", value.getClientUserIdOfSession());
            encoder.writeStringArray("ClientUserIdHistory", value.getClientUserIdHistory());
            encoder.writeString("AuthenticationMechanism", value.getAuthenticationMechanism());
            encoder.writeString("Encoding", value.getEncoding());
            encoder.writeString("TransportProtocol", value.getTransportProtocol());
            encoder.writeEnum("SecurityMode", value.getSecurityMode());
            encoder.writeString("SecurityPolicyUri", value.getSecurityPolicyUri());
            encoder.writeByteString("ClientCertificate", value.getClientCertificate());
        }
    }
}

