/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeAttributes;

public class ReferenceTypeAttributes
extends NodeAttributes
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=367");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=369");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=368");
    private final Boolean isAbstract;
    private final Boolean symmetric;
    private final LocalizedText inverseName;

    public ReferenceTypeAttributes(UInteger specifiedAttributes, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean isAbstract, Boolean symmetric, LocalizedText inverseName) {
        super(specifiedAttributes, displayName, description, writeMask, userWriteMask);
        this.isAbstract = isAbstract;
        this.symmetric = symmetric;
        this.inverseName = inverseName;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    public Boolean getSymmetric() {
        return this.symmetric;
    }

    public LocalizedText getInverseName() {
        return this.inverseName;
    }

    protected ReferenceTypeAttributes(ReferenceTypeAttributesBuilder<?, ?> b) {
        super((NodeAttributes.NodeAttributesBuilder<?, ?>)b);
        this.isAbstract = ((ReferenceTypeAttributesBuilder)b).isAbstract;
        this.symmetric = ((ReferenceTypeAttributesBuilder)b).symmetric;
        this.inverseName = ((ReferenceTypeAttributesBuilder)b).inverseName;
    }

    public static ReferenceTypeAttributesBuilder<?, ?> builder() {
        return new ReferenceTypeAttributesBuilderImpl();
    }

    public ReferenceTypeAttributesBuilder<?, ?> toBuilder() {
        return new ReferenceTypeAttributesBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceTypeAttributes)) {
            return false;
        }
        ReferenceTypeAttributes other = (ReferenceTypeAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isAbstract = this.getIsAbstract();
        Boolean other$isAbstract = other.getIsAbstract();
        if (this$isAbstract == null ? other$isAbstract != null : !((Object)this$isAbstract).equals(other$isAbstract)) {
            return false;
        }
        Boolean this$symmetric = this.getSymmetric();
        Boolean other$symmetric = other.getSymmetric();
        if (this$symmetric == null ? other$symmetric != null : !((Object)this$symmetric).equals(other$symmetric)) {
            return false;
        }
        LocalizedText this$inverseName = this.getInverseName();
        LocalizedText other$inverseName = other.getInverseName();
        return !(this$inverseName == null ? other$inverseName != null : !((Object)this$inverseName).equals(other$inverseName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReferenceTypeAttributes;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isAbstract = this.getIsAbstract();
        result = result * 59 + ($isAbstract == null ? 43 : ((Object)$isAbstract).hashCode());
        Boolean $symmetric = this.getSymmetric();
        result = result * 59 + ($symmetric == null ? 43 : ((Object)$symmetric).hashCode());
        LocalizedText $inverseName = this.getInverseName();
        result = result * 59 + ($inverseName == null ? 43 : ((Object)$inverseName).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReferenceTypeAttributes(isAbstract=" + this.getIsAbstract() + ", symmetric=" + this.getSymmetric() + ", inverseName=" + this.getInverseName() + ")";
    }

    private static final class ReferenceTypeAttributesBuilderImpl
    extends ReferenceTypeAttributesBuilder<ReferenceTypeAttributes, ReferenceTypeAttributesBuilderImpl> {
        private ReferenceTypeAttributesBuilderImpl() {
        }

        @Override
        protected ReferenceTypeAttributesBuilderImpl self() {
            return this;
        }

        @Override
        public ReferenceTypeAttributes build() {
            return new ReferenceTypeAttributes(this);
        }
    }

    public static abstract class ReferenceTypeAttributesBuilder<C extends ReferenceTypeAttributes, B extends ReferenceTypeAttributesBuilder<C, B>>
    extends NodeAttributes.NodeAttributesBuilder<C, B> {
        private Boolean isAbstract;
        private Boolean symmetric;
        private LocalizedText inverseName;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReferenceTypeAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ReferenceTypeAttributes instance, ReferenceTypeAttributesBuilder<?, ?> b) {
            b.isAbstract(instance.isAbstract);
            b.symmetric(instance.symmetric);
            b.inverseName(instance.inverseName);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B isAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return (B)this.self();
        }

        public B symmetric(Boolean symmetric) {
            this.symmetric = symmetric;
            return (B)this.self();
        }

        public B inverseName(LocalizedText inverseName) {
            this.inverseName = inverseName;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ReferenceTypeAttributes.ReferenceTypeAttributesBuilder(super=" + super.toString() + ", isAbstract=" + this.isAbstract + ", symmetric=" + this.symmetric + ", inverseName=" + this.inverseName + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReferenceTypeAttributes> {
        @Override
        public Class<ReferenceTypeAttributes> getType() {
            return ReferenceTypeAttributes.class;
        }

        @Override
        public ReferenceTypeAttributes decode(SerializationContext context, UaDecoder decoder) {
            UInteger specifiedAttributes = decoder.readUInt32("SpecifiedAttributes");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            Boolean isAbstract = decoder.readBoolean("IsAbstract");
            Boolean symmetric = decoder.readBoolean("Symmetric");
            LocalizedText inverseName = decoder.readLocalizedText("InverseName");
            return new ReferenceTypeAttributes(specifiedAttributes, displayName, description, writeMask, userWriteMask, isAbstract, symmetric, inverseName);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReferenceTypeAttributes value) {
            encoder.writeUInt32("SpecifiedAttributes", value.getSpecifiedAttributes());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeBoolean("IsAbstract", value.getIsAbstract());
            encoder.writeBoolean("Symmetric", value.getSymmetric());
            encoder.writeLocalizedText("InverseName", value.getInverseName());
        }
    }
}

