/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class OptionSet
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12755");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12757");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12765");
    private final ByteString value;
    private final ByteString validBits;

    public OptionSet(ByteString value, ByteString validBits) {
        this.value = value;
        this.validBits = validBits;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public ByteString getValue() {
        return this.value;
    }

    public ByteString getValidBits() {
        return this.validBits;
    }

    protected OptionSet(OptionSetBuilder<?, ?> b) {
        super(b);
        this.value = ((OptionSetBuilder)b).value;
        this.validBits = ((OptionSetBuilder)b).validBits;
    }

    public static OptionSetBuilder<?, ?> builder() {
        return new OptionSetBuilderImpl();
    }

    public OptionSetBuilder<?, ?> toBuilder() {
        return new OptionSetBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptionSet)) {
            return false;
        }
        OptionSet other = (OptionSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ByteString this$value = this.getValue();
        ByteString other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        ByteString this$validBits = this.getValidBits();
        ByteString other$validBits = other.getValidBits();
        return !(this$validBits == null ? other$validBits != null : !((Object)this$validBits).equals(other$validBits));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OptionSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteString $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        ByteString $validBits = this.getValidBits();
        result = result * 59 + ($validBits == null ? 43 : ((Object)$validBits).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OptionSet(value=" + this.getValue() + ", validBits=" + this.getValidBits() + ")";
    }

    private static final class OptionSetBuilderImpl
    extends OptionSetBuilder<OptionSet, OptionSetBuilderImpl> {
        private OptionSetBuilderImpl() {
        }

        @Override
        protected OptionSetBuilderImpl self() {
            return this;
        }

        @Override
        public OptionSet build() {
            return new OptionSet(this);
        }
    }

    public static abstract class OptionSetBuilder<C extends OptionSet, B extends OptionSetBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ByteString value;
        private ByteString validBits;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            OptionSetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(OptionSet instance, OptionSetBuilder<?, ?> b) {
            b.value(instance.value);
            b.validBits(instance.validBits);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B value(ByteString value) {
            this.value = value;
            return (B)this.self();
        }

        public B validBits(ByteString validBits) {
            this.validBits = validBits;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "OptionSet.OptionSetBuilder(super=" + super.toString() + ", value=" + this.value + ", validBits=" + this.validBits + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<OptionSet> {
        @Override
        public Class<OptionSet> getType() {
            return OptionSet.class;
        }

        @Override
        public OptionSet decode(SerializationContext context, UaDecoder decoder) {
            ByteString value = decoder.readByteString("Value");
            ByteString validBits = decoder.readByteString("ValidBits");
            return new OptionSet(value, validBits);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, OptionSet value) {
            encoder.writeByteString("Value", value.getValue());
            encoder.writeByteString("ValidBits", value.getValidBits());
        }
    }
}

