/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class MonitoredItemCreateRequest
extends Structure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=743");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=745");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=744");
    private final ReadValueId itemToMonitor;
    private final MonitoringMode monitoringMode;
    private final MonitoringParameters requestedParameters;

    public MonitoredItemCreateRequest(ReadValueId itemToMonitor, MonitoringMode monitoringMode, MonitoringParameters requestedParameters) {
        this.itemToMonitor = itemToMonitor;
        this.monitoringMode = monitoringMode;
        this.requestedParameters = requestedParameters;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public ReadValueId getItemToMonitor() {
        return this.itemToMonitor;
    }

    public MonitoringMode getMonitoringMode() {
        return this.monitoringMode;
    }

    public MonitoringParameters getRequestedParameters() {
        return this.requestedParameters;
    }

    protected MonitoredItemCreateRequest(MonitoredItemCreateRequestBuilder<?, ?> b) {
        super(b);
        this.itemToMonitor = ((MonitoredItemCreateRequestBuilder)b).itemToMonitor;
        this.monitoringMode = ((MonitoredItemCreateRequestBuilder)b).monitoringMode;
        this.requestedParameters = ((MonitoredItemCreateRequestBuilder)b).requestedParameters;
    }

    public static MonitoredItemCreateRequestBuilder<?, ?> builder() {
        return new MonitoredItemCreateRequestBuilderImpl();
    }

    public MonitoredItemCreateRequestBuilder<?, ?> toBuilder() {
        return new MonitoredItemCreateRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoredItemCreateRequest)) {
            return false;
        }
        MonitoredItemCreateRequest other = (MonitoredItemCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ReadValueId this$itemToMonitor = this.getItemToMonitor();
        ReadValueId other$itemToMonitor = other.getItemToMonitor();
        if (this$itemToMonitor == null ? other$itemToMonitor != null : !((Object)this$itemToMonitor).equals(other$itemToMonitor)) {
            return false;
        }
        MonitoringMode this$monitoringMode = this.getMonitoringMode();
        MonitoringMode other$monitoringMode = other.getMonitoringMode();
        if (this$monitoringMode == null ? other$monitoringMode != null : !this$monitoringMode.equals(other$monitoringMode)) {
            return false;
        }
        MonitoringParameters this$requestedParameters = this.getRequestedParameters();
        MonitoringParameters other$requestedParameters = other.getRequestedParameters();
        return !(this$requestedParameters == null ? other$requestedParameters != null : !((Object)this$requestedParameters).equals(other$requestedParameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitoredItemCreateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReadValueId $itemToMonitor = this.getItemToMonitor();
        result = result * 59 + ($itemToMonitor == null ? 43 : ((Object)$itemToMonitor).hashCode());
        MonitoringMode $monitoringMode = this.getMonitoringMode();
        result = result * 59 + ($monitoringMode == null ? 43 : $monitoringMode.hashCode());
        MonitoringParameters $requestedParameters = this.getRequestedParameters();
        result = result * 59 + ($requestedParameters == null ? 43 : ((Object)$requestedParameters).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MonitoredItemCreateRequest(itemToMonitor=" + this.getItemToMonitor() + ", monitoringMode=" + this.getMonitoringMode() + ", requestedParameters=" + this.getRequestedParameters() + ")";
    }

    private static final class MonitoredItemCreateRequestBuilderImpl
    extends MonitoredItemCreateRequestBuilder<MonitoredItemCreateRequest, MonitoredItemCreateRequestBuilderImpl> {
        private MonitoredItemCreateRequestBuilderImpl() {
        }

        @Override
        protected MonitoredItemCreateRequestBuilderImpl self() {
            return this;
        }

        @Override
        public MonitoredItemCreateRequest build() {
            return new MonitoredItemCreateRequest(this);
        }
    }

    public static abstract class MonitoredItemCreateRequestBuilder<C extends MonitoredItemCreateRequest, B extends MonitoredItemCreateRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ReadValueId itemToMonitor;
        private MonitoringMode monitoringMode;
        private MonitoringParameters requestedParameters;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MonitoredItemCreateRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(MonitoredItemCreateRequest instance, MonitoredItemCreateRequestBuilder<?, ?> b) {
            b.itemToMonitor(instance.itemToMonitor);
            b.monitoringMode(instance.monitoringMode);
            b.requestedParameters(instance.requestedParameters);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B itemToMonitor(ReadValueId itemToMonitor) {
            this.itemToMonitor = itemToMonitor;
            return (B)this.self();
        }

        public B monitoringMode(MonitoringMode monitoringMode) {
            this.monitoringMode = monitoringMode;
            return (B)this.self();
        }

        public B requestedParameters(MonitoringParameters requestedParameters) {
            this.requestedParameters = requestedParameters;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MonitoredItemCreateRequest.MonitoredItemCreateRequestBuilder(super=" + super.toString() + ", itemToMonitor=" + this.itemToMonitor + ", monitoringMode=" + this.monitoringMode + ", requestedParameters=" + this.requestedParameters + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<MonitoredItemCreateRequest> {
        @Override
        public Class<MonitoredItemCreateRequest> getType() {
            return MonitoredItemCreateRequest.class;
        }

        @Override
        public MonitoredItemCreateRequest decode(SerializationContext context, UaDecoder decoder) {
            ReadValueId itemToMonitor = (ReadValueId)decoder.readStruct("ItemToMonitor", ReadValueId.TYPE_ID);
            MonitoringMode monitoringMode = decoder.readEnum("MonitoringMode", MonitoringMode.class);
            MonitoringParameters requestedParameters = (MonitoringParameters)decoder.readStruct("RequestedParameters", MonitoringParameters.TYPE_ID);
            return new MonitoredItemCreateRequest(itemToMonitor, monitoringMode, requestedParameters);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, MonitoredItemCreateRequest value) {
            encoder.writeStruct("ItemToMonitor", (Object)value.getItemToMonitor(), ReadValueId.TYPE_ID);
            encoder.writeEnum("MonitoringMode", value.getMonitoringMode());
            encoder.writeStruct("RequestedParameters", (Object)value.getRequestedParameters(), MonitoringParameters.TYPE_ID);
        }
    }
}

