/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.HistoryUpdateType;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ModificationInfo
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11216");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11226");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11218");
    private final DateTime modificationTime;
    private final HistoryUpdateType updateType;
    private final String userName;

    public ModificationInfo(DateTime modificationTime, HistoryUpdateType updateType, String userName) {
        this.modificationTime = modificationTime;
        this.updateType = updateType;
        this.userName = userName;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DateTime getModificationTime() {
        return this.modificationTime;
    }

    public HistoryUpdateType getUpdateType() {
        return this.updateType;
    }

    public String getUserName() {
        return this.userName;
    }

    protected ModificationInfo(ModificationInfoBuilder<?, ?> b) {
        super(b);
        this.modificationTime = ((ModificationInfoBuilder)b).modificationTime;
        this.updateType = ((ModificationInfoBuilder)b).updateType;
        this.userName = ((ModificationInfoBuilder)b).userName;
    }

    public static ModificationInfoBuilder<?, ?> builder() {
        return new ModificationInfoBuilderImpl();
    }

    public ModificationInfoBuilder<?, ?> toBuilder() {
        return new ModificationInfoBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModificationInfo)) {
            return false;
        }
        ModificationInfo other = (ModificationInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DateTime this$modificationTime = this.getModificationTime();
        DateTime other$modificationTime = other.getModificationTime();
        if (this$modificationTime == null ? other$modificationTime != null : !((Object)this$modificationTime).equals(other$modificationTime)) {
            return false;
        }
        HistoryUpdateType this$updateType = this.getUpdateType();
        HistoryUpdateType other$updateType = other.getUpdateType();
        if (this$updateType == null ? other$updateType != null : !this$updateType.equals(other$updateType)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModificationInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTime $modificationTime = this.getModificationTime();
        result = result * 59 + ($modificationTime == null ? 43 : ((Object)$modificationTime).hashCode());
        HistoryUpdateType $updateType = this.getUpdateType();
        result = result * 59 + ($updateType == null ? 43 : $updateType.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ModificationInfo(modificationTime=" + this.getModificationTime() + ", updateType=" + this.getUpdateType() + ", userName=" + this.getUserName() + ")";
    }

    private static final class ModificationInfoBuilderImpl
    extends ModificationInfoBuilder<ModificationInfo, ModificationInfoBuilderImpl> {
        private ModificationInfoBuilderImpl() {
        }

        @Override
        protected ModificationInfoBuilderImpl self() {
            return this;
        }

        @Override
        public ModificationInfo build() {
            return new ModificationInfo(this);
        }
    }

    public static abstract class ModificationInfoBuilder<C extends ModificationInfo, B extends ModificationInfoBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private DateTime modificationTime;
        private HistoryUpdateType updateType;
        private String userName;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModificationInfoBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ModificationInfo instance, ModificationInfoBuilder<?, ?> b) {
            b.modificationTime(instance.modificationTime);
            b.updateType(instance.updateType);
            b.userName(instance.userName);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B modificationTime(DateTime modificationTime) {
            this.modificationTime = modificationTime;
            return (B)this.self();
        }

        public B updateType(HistoryUpdateType updateType) {
            this.updateType = updateType;
            return (B)this.self();
        }

        public B userName(String userName) {
            this.userName = userName;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ModificationInfo.ModificationInfoBuilder(super=" + super.toString() + ", modificationTime=" + this.modificationTime + ", updateType=" + this.updateType + ", userName=" + this.userName + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ModificationInfo> {
        @Override
        public Class<ModificationInfo> getType() {
            return ModificationInfo.class;
        }

        @Override
        public ModificationInfo decode(SerializationContext context, UaDecoder decoder) {
            DateTime modificationTime = decoder.readDateTime("ModificationTime");
            HistoryUpdateType updateType = decoder.readEnum("UpdateType", HistoryUpdateType.class);
            String userName = decoder.readString("UserName");
            return new ModificationInfo(modificationTime, updateType, userName);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ModificationInfo value) {
            encoder.writeDateTime("ModificationTime", value.getModificationTime());
            encoder.writeEnum("UpdateType", value.getUpdateType());
            encoder.writeString("UserName", value.getUserName());
        }
    }
}

