/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class GetEndpointsResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=429");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=431");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=430");
    private final ResponseHeader responseHeader;
    private final EndpointDescription[] endpoints;

    public GetEndpointsResponse(ResponseHeader responseHeader, EndpointDescription[] endpoints) {
        this.responseHeader = responseHeader;
        this.endpoints = endpoints;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public EndpointDescription[] getEndpoints() {
        return this.endpoints;
    }

    protected GetEndpointsResponse(GetEndpointsResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((GetEndpointsResponseBuilder)b).responseHeader;
        this.endpoints = ((GetEndpointsResponseBuilder)b).endpoints;
    }

    public static GetEndpointsResponseBuilder<?, ?> builder() {
        return new GetEndpointsResponseBuilderImpl();
    }

    public GetEndpointsResponseBuilder<?, ?> toBuilder() {
        return new GetEndpointsResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetEndpointsResponse)) {
            return false;
        }
        GetEndpointsResponse other = (GetEndpointsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getEndpoints(), other.getEndpoints());
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetEndpointsResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEndpoints());
        return result;
    }

    @Override
    public String toString() {
        return "GetEndpointsResponse(responseHeader=" + this.getResponseHeader() + ", endpoints=" + Arrays.deepToString(this.getEndpoints()) + ")";
    }

    private static final class GetEndpointsResponseBuilderImpl
    extends GetEndpointsResponseBuilder<GetEndpointsResponse, GetEndpointsResponseBuilderImpl> {
        private GetEndpointsResponseBuilderImpl() {
        }

        @Override
        protected GetEndpointsResponseBuilderImpl self() {
            return this;
        }

        @Override
        public GetEndpointsResponse build() {
            return new GetEndpointsResponse(this);
        }
    }

    public static abstract class GetEndpointsResponseBuilder<C extends GetEndpointsResponse, B extends GetEndpointsResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private EndpointDescription[] endpoints;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GetEndpointsResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(GetEndpointsResponse instance, GetEndpointsResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.endpoints(instance.endpoints);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B endpoints(EndpointDescription[] endpoints) {
            this.endpoints = endpoints;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "GetEndpointsResponse.GetEndpointsResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", endpoints=" + Arrays.deepToString(this.endpoints) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<GetEndpointsResponse> {
        @Override
        public Class<GetEndpointsResponse> getType() {
            return GetEndpointsResponse.class;
        }

        @Override
        public GetEndpointsResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            EndpointDescription[] endpoints = (EndpointDescription[])decoder.readStructArray("Endpoints", EndpointDescription.TYPE_ID);
            return new GetEndpointsResponse(responseHeader, endpoints);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, GetEndpointsResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStructArray("Endpoints", (Object[])value.getEndpoints(), EndpointDescription.TYPE_ID);
        }
    }
}

