/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization.codecs;

import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaXmlStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaXmlStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;

public abstract class GenericDataTypeCodec<T>
implements DataTypeCodec<T, UaDecoder, UaEncoder> {
    public final OpcUaBinaryDataTypeCodec<T> asBinaryCodec() {
        return new GenericBinaryDataTypeCodec(this);
    }

    public final OpcUaXmlDataTypeCodec<T> asXmlCodec() {
        return new GenericXmlDataTypeCodec(this);
    }

    private static class GenericXmlDataTypeCodec<T>
    implements OpcUaXmlDataTypeCodec<T> {
        private final GenericDataTypeCodec<T> codec;

        public GenericXmlDataTypeCodec(GenericDataTypeCodec<T> codec) {
            this.codec = codec;
        }

        @Override
        public Class<T> getType() {
            return this.codec.getType();
        }

        @Override
        public T decode(SerializationContext context, OpcUaXmlStreamDecoder reader) throws UaSerializationException {
            return this.codec.decode(context, reader);
        }

        @Override
        public void encode(SerializationContext context, OpcUaXmlStreamEncoder writer, T value) throws UaSerializationException {
            this.codec.encode(context, writer, value);
        }
    }

    private static class GenericBinaryDataTypeCodec<T>
    implements OpcUaBinaryDataTypeCodec<T> {
        private final GenericDataTypeCodec<T> codec;

        public GenericBinaryDataTypeCodec(GenericDataTypeCodec<T> codec) {
            this.codec = codec;
        }

        @Override
        public Class<T> getType() {
            return this.codec.getType();
        }

        @Override
        public T decode(SerializationContext context, OpcUaBinaryStreamDecoder reader) throws UaSerializationException {
            return this.codec.decode(context, reader);
        }

        @Override
        public void encode(SerializationContext context, OpcUaBinaryStreamEncoder writer, T value) throws UaSerializationException {
            this.codec.encode(context, writer, value);
        }
    }
}

