/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.read.partition.CountTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetSeriesSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.partition.GetTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionIdPlan;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.PreDeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.UpdateDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.AddRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.AutoCleanPartitionTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.RemoveRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.OfferRegionMaintainTasksPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.PollSpecificRegionMaintainTaskPlan;
import org.apache.iotdb.confignode.consensus.response.partition.CountTimeSlotListResp;
import org.apache.iotdb.confignode.consensus.response.partition.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.partition.GetRegionIdResp;
import org.apache.iotdb.confignode.consensus.response.partition.GetSeriesSlotListResp;
import org.apache.iotdb.confignode.consensus.response.partition.GetTimeSlotListResp;
import org.apache.iotdb.confignode.consensus.response.partition.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.partition.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.partition.SchemaPartitionResp;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.persistence.partition.DatabasePartitionTable;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainTask;
import org.apache.iotdb.confignode.rpc.thrift.TRegionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionInfo.class);
    private static final int PARTITION_TABLE_BUFFER_SIZE = 0x2000000;
    private final AtomicInteger nextRegionGroupId = new AtomicInteger(-1);
    private final Map<String, DatabasePartitionTable> databasePartitionTables = new ConcurrentHashMap<String, DatabasePartitionTable>();
    private final List<RegionMaintainTask> regionMaintainTaskList = Collections.synchronizedList(new ArrayList());
    private static final String SNAPSHOT_FILENAME = "partition_info.bin";

    public int generateNextRegionGroupId() {
        return this.nextRegionGroupId.incrementAndGet();
    }

    public TSStatus updateDataNode(UpdateDataNodePlan updateDataNodePlan) {
        TDataNodeLocation newDataNodeLocation = updateDataNodePlan.getDataNodeConfiguration().getLocation();
        this.databasePartitionTables.forEach((database, databasePartitionTable) -> {
            if (this.isDatabaseExisted((String)database)) {
                databasePartitionTable.updateDataNode(newDataNodeLocation);
            }
        });
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus createDatabase(DatabaseSchemaPlan plan) {
        String databaseName = plan.getSchema().getName();
        DatabasePartitionTable databasePartitionTable = new DatabasePartitionTable(databaseName);
        this.databasePartitionTables.put(databaseName, databasePartitionTable);
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus createRegionGroups(CreateRegionGroupsPlan plan) {
        AtomicInteger maxRegionId = new AtomicInteger(Integer.MIN_VALUE);
        plan.getRegionGroupMap().forEach((database, regionReplicaSets) -> {
            this.databasePartitionTables.get(database).createRegionGroups((List<TRegionReplicaSet>)regionReplicaSets);
            regionReplicaSets.forEach(regionReplicaSet -> maxRegionId.set(Math.max(maxRegionId.get(), regionReplicaSet.getRegionId().getId())));
        });
        AtomicInteger atomicInteger = this.nextRegionGroupId;
        synchronized (atomicInteger) {
            if (this.nextRegionGroupId.get() < maxRegionId.get()) {
                this.nextRegionGroupId.set(maxRegionId.get());
            }
        }
        TSStatus result = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus offerRegionMaintainTasks(OfferRegionMaintainTasksPlan offerRegionMaintainTasksPlan) {
        List<RegionMaintainTask> list = this.regionMaintainTaskList;
        synchronized (list) {
            this.regionMaintainTaskList.addAll(offerRegionMaintainTasksPlan.getRegionMaintainTaskList());
            return RpcUtils.SUCCESS_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus pollRegionMaintainTask() {
        List<RegionMaintainTask> list = this.regionMaintainTaskList;
        synchronized (list) {
            this.regionMaintainTaskList.remove(0);
            return RpcUtils.SUCCESS_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus pollSpecificRegionMaintainTask(PollSpecificRegionMaintainTaskPlan plan) {
        List<RegionMaintainTask> list = this.regionMaintainTaskList;
        synchronized (list) {
            HashSet<TConsensusGroupId> removingRegionIdSet = new HashSet<TConsensusGroupId>(plan.getRegionIdSet());
            for (int i = 0; i < this.regionMaintainTaskList.size(); ++i) {
                TConsensusGroupId regionId = this.regionMaintainTaskList.get(i).getRegionId();
                if (removingRegionIdSet.contains(regionId)) {
                    this.regionMaintainTaskList.remove(i);
                    removingRegionIdSet.remove(regionId);
                    --i;
                }
                if (removingRegionIdSet.isEmpty()) break;
            }
            return RpcUtils.SUCCESS_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegionMaintainTask> getRegionMaintainEntryList() {
        List<RegionMaintainTask> list = this.regionMaintainTaskList;
        synchronized (list) {
            return new ArrayList<RegionMaintainTask>(this.regionMaintainTaskList);
        }
    }

    public TSStatus preDeleteDatabase(PreDeleteDatabasePlan preDeleteDatabasePlan) {
        PreDeleteDatabasePlan.PreDeleteType preDeleteType = preDeleteDatabasePlan.getPreDeleteType();
        String database = preDeleteDatabasePlan.getStorageGroup();
        DatabasePartitionTable databasePartitionTable = this.databasePartitionTables.get(database);
        if (databasePartitionTable == null) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        switch (preDeleteType) {
            case EXECUTE: {
                databasePartitionTable.setPreDeleted(true);
                break;
            }
            case ROLLBACK: {
                databasePartitionTable.setPreDeleted(false);
                break;
            }
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public boolean isDatabasePreDeleted(String database) {
        DatabasePartitionTable databasePartitionTable = this.databasePartitionTables.get(database);
        return databasePartitionTable != null && !databasePartitionTable.isNotPreDeleted();
    }

    public void deleteDatabase(DeleteDatabasePlan plan) {
        this.databasePartitionTables.remove(plan.getName());
    }

    public DataSet getSchemaPartition(GetSchemaPartitionPlan plan) {
        AtomicBoolean isAllPartitionsExist = new AtomicBoolean(true);
        ConcurrentHashMap<String, SchemaPartitionTable> schemaPartition = new ConcurrentHashMap<String, SchemaPartitionTable>();
        if (plan.getPartitionSlotsMap().isEmpty()) {
            this.databasePartitionTables.forEach((database, databasePartitionTable) -> {
                if (databasePartitionTable.isNotPreDeleted()) {
                    schemaPartition.put((String)database, new SchemaPartitionTable());
                    databasePartitionTable.getSchemaPartition(new ArrayList<TSeriesPartitionSlot>(), (SchemaPartitionTable)schemaPartition.get(database));
                    if (((SchemaPartitionTable)schemaPartition.get(database)).getSchemaPartitionMap().isEmpty()) {
                        schemaPartition.remove(database);
                    }
                }
            });
        } else {
            plan.getPartitionSlotsMap().forEach((database, partitionSlots) -> {
                if (this.isDatabaseExisted((String)database)) {
                    schemaPartition.put((String)database, new SchemaPartitionTable());
                    if (!this.databasePartitionTables.get(database).getSchemaPartition((List<TSeriesPartitionSlot>)partitionSlots, (SchemaPartitionTable)schemaPartition.get(database))) {
                        isAllPartitionsExist.set(false);
                    }
                    if (((SchemaPartitionTable)schemaPartition.get(database)).getSchemaPartitionMap().isEmpty()) {
                        schemaPartition.remove(database);
                    }
                } else {
                    isAllPartitionsExist.set(false);
                }
            });
        }
        return new SchemaPartitionResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), isAllPartitionsExist.get(), schemaPartition);
    }

    public DataSet getDataPartition(GetDataPartitionPlan plan) {
        AtomicBoolean isAllPartitionsExist = new AtomicBoolean(true);
        ConcurrentHashMap<String, DataPartitionTable> dataPartition = new ConcurrentHashMap<String, DataPartitionTable>();
        plan.getPartitionSlotsMap().forEach((database, partitionSlots) -> {
            if (this.isDatabaseExisted((String)database)) {
                dataPartition.put((String)database, new DataPartitionTable());
                if (!this.databasePartitionTables.get(database).getDataPartition((Map<TSeriesPartitionSlot, TTimeSlotList>)partitionSlots, (DataPartitionTable)dataPartition.get(database))) {
                    isAllPartitionsExist.set(false);
                }
                if (((DataPartitionTable)dataPartition.get(database)).getDataPartitionMap().isEmpty()) {
                    dataPartition.remove(database);
                }
            } else {
                isAllPartitionsExist.set(false);
            }
        });
        return new DataPartitionResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), isAllPartitionsExist.get(), dataPartition);
    }

    public TConsensusGroupId getSuccessorDataPartition(String database, TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot) {
        if (this.isDatabaseExisted(database)) {
            return this.databasePartitionTables.get(database).getSuccessorDataPartition(seriesPartitionSlot, timePartitionSlot);
        }
        return null;
    }

    public TConsensusGroupId getPredecessorDataPartition(String database, TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot) {
        if (this.isDatabaseExisted(database)) {
            return this.databasePartitionTables.get(database).getPredecessorDataPartition(seriesPartitionSlot, timePartitionSlot);
        }
        return null;
    }

    public boolean isDatabaseExisted(String database) {
        DatabasePartitionTable databasePartitionTable = this.databasePartitionTables.get(database);
        return databasePartitionTable != null && databasePartitionTable.isNotPreDeleted();
    }

    public TSStatus createSchemaPartition(CreateSchemaPartitionPlan plan) {
        plan.getAssignedSchemaPartition().forEach((database, schemaPartitionTable) -> {
            if (this.isDatabaseExisted((String)database)) {
                this.databasePartitionTables.get(database).createSchemaPartition((SchemaPartitionTable)schemaPartitionTable);
            }
        });
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus createDataPartition(CreateDataPartitionPlan plan) {
        plan.getAssignedDataPartition().forEach((database, dataPartitionTable) -> {
            if (this.isDatabaseExisted((String)database)) {
                this.databasePartitionTables.get(database).createDataPartition((DataPartitionTable)dataPartitionTable);
            }
        });
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus autoCleanPartitionTable(AutoCleanPartitionTablePlan plan) {
        plan.getDatabaseTTLMap().forEach((database, ttl) -> {
            if (this.isDatabaseExisted((String)database) && 0L < ttl && ttl < Long.MAX_VALUE) {
                this.databasePartitionTables.get(database).autoCleanPartitionTable((long)ttl, plan.getCurrentTimeSlot());
            }
        });
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public DataSet getSchemaNodeManagementPartition(List<String> matchedDatabases) {
        SchemaNodeManagementResp schemaNodeManagementResp = new SchemaNodeManagementResp();
        ConcurrentHashMap<String, SchemaPartitionTable> schemaPartitionMap = new ConcurrentHashMap<String, SchemaPartitionTable>();
        matchedDatabases.stream().filter(this::isDatabaseExisted).forEach(database -> {
            schemaPartitionMap.put((String)database, new SchemaPartitionTable());
            this.databasePartitionTables.get(database).getSchemaPartition(new ArrayList<TSeriesPartitionSlot>(), (SchemaPartitionTable)schemaPartitionMap.get(database));
            if (((SchemaPartitionTable)schemaPartitionMap.get(database)).getSchemaPartitionMap().isEmpty()) {
                schemaPartitionMap.remove(database);
            }
        });
        schemaNodeManagementResp.setSchemaPartition(schemaPartitionMap);
        schemaNodeManagementResp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        return schemaNodeManagementResp;
    }

    public DataSet getRegionInfoList(GetRegionInfoListPlan regionsInfoPlan) {
        RegionInfoListResp regionResp = new RegionInfoListResp();
        Vector<TRegionInfo> regionInfoList = new Vector<TRegionInfo>();
        if (this.databasePartitionTables.isEmpty()) {
            regionResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            regionResp.setRegionInfoList(new ArrayList<TRegionInfo>());
            return regionResp;
        }
        TShowRegionReq showRegionReq = regionsInfoPlan.getShowRegionReq();
        List databases = showRegionReq != null ? showRegionReq.getDatabases() : null;
        this.databasePartitionTables.forEach((database, databasePartitionTable) -> {
            if (databases != null && !databases.contains(database)) {
                return;
            }
            regionInfoList.addAll(databasePartitionTable.getRegionInfoList(regionsInfoPlan));
        });
        regionInfoList.sort((o1, o2) -> o1.getConsensusGroupId().getId() != o2.getConsensusGroupId().getId() ? o1.getConsensusGroupId().getId() - o2.getConsensusGroupId().getId() : o1.getDataNodeId() - o2.getDataNodeId());
        regionResp.setRegionInfoList(regionInfoList);
        regionResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return regionResp;
    }

    public boolean isRegionGroupExisted(TConsensusGroupId regionGroupId) {
        return this.databasePartitionTables.values().stream().anyMatch(databasePartitionTable -> databasePartitionTable.containRegionGroup(regionGroupId));
    }

    public TSStatus updateRegionLocation(UpdateRegionLocationPlan req) {
        TSStatus addStatus = this.addRegionLocation(new AddRegionLocationPlan(req.getRegionId(), req.getNewNode()));
        if (addStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return addStatus;
        }
        return this.removeRegionLocation(new RemoveRegionLocationPlan(req.getRegionId(), req.getOldNode()));
    }

    public TSStatus addRegionLocation(AddRegionLocationPlan req) {
        this.databasePartitionTables.values().stream().filter(databasePartitionTable -> databasePartitionTable.containRegionGroup(req.getRegionId())).forEach(databasePartitionTable -> databasePartitionTable.addRegionNewLocation(req.getRegionId(), req.getNewLocation()));
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus removeRegionLocation(RemoveRegionLocationPlan req) {
        this.databasePartitionTables.values().stream().filter(databasePartitionTable -> databasePartitionTable.containRegionGroup(req.getRegionId())).forEach(databasePartitionTable -> databasePartitionTable.removeRegionLocation(req.getRegionId(), req.getDeprecatedLocation()));
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public String getRegionDatabase(TConsensusGroupId regionId) {
        Optional<DatabasePartitionTable> sgPartitionTableOptional = this.databasePartitionTables.values().stream().filter(s -> s.containRegionGroup(regionId)).findFirst();
        return sgPartitionTableOptional.map(DatabasePartitionTable::getDatabaseName).orElse(null);
    }

    public Map<String, List<TSeriesPartitionSlot>> filterUnassignedSchemaPartitionSlots(Map<String, List<TSeriesPartitionSlot>> partitionSlotsMap) {
        ConcurrentHashMap<String, List<TSeriesPartitionSlot>> result = new ConcurrentHashMap<String, List<TSeriesPartitionSlot>>();
        partitionSlotsMap.forEach((database, partitionSlots) -> {
            if (this.isDatabaseExisted((String)database)) {
                result.put((String)database, this.databasePartitionTables.get(database).filterUnassignedSchemaPartitionSlots((List<TSeriesPartitionSlot>)partitionSlots));
            }
        });
        return result;
    }

    public Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> filterUnassignedDataPartitionSlots(Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> partitionSlotsMap) {
        ConcurrentHashMap<String, Map<TSeriesPartitionSlot, TTimeSlotList>> result = new ConcurrentHashMap<String, Map<TSeriesPartitionSlot, TTimeSlotList>>();
        partitionSlotsMap.forEach((database, partitionSlots) -> {
            if (this.isDatabaseExisted((String)database)) {
                result.put((String)database, this.databasePartitionTables.get(database).filterUnassignedDataPartitionSlots((Map<TSeriesPartitionSlot, TTimeSlotList>)partitionSlots));
            }
        });
        return result;
    }

    public List<TRegionReplicaSet> getAllReplicaSets() {
        return this.databasePartitionTables.values().stream().flatMap(DatabasePartitionTable::getAllReplicaSets).collect(Collectors.toList());
    }

    public List<TRegionReplicaSet> getAllReplicaSets(TConsensusGroupType type) {
        ArrayList<TRegionReplicaSet> result = new ArrayList<TRegionReplicaSet>();
        this.databasePartitionTables.values().forEach(databasePartitionTable -> {
            if (databasePartitionTable.isNotPreDeleted()) {
                result.addAll(databasePartitionTable.getAllReplicaSets(type));
            }
        });
        return result;
    }

    public List<TRegionReplicaSet> getAllReplicaSets(String database) {
        if (this.databasePartitionTables.containsKey(database)) {
            return this.databasePartitionTables.get(database).getAllReplicaSets().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<TRegionReplicaSet> getAllReplicaSets(String database, TConsensusGroupType type) {
        if (this.databasePartitionTables.containsKey(database)) {
            return this.databasePartitionTables.get(database).getAllReplicaSets(type);
        }
        return Collections.emptyList();
    }

    public List<TRegionReplicaSet> getAllReplicaSets(int dataNodeId) {
        ArrayList<TRegionReplicaSet> result = new ArrayList<TRegionReplicaSet>();
        this.databasePartitionTables.values().forEach(databasePartitionTable -> result.addAll(databasePartitionTable.getAllReplicaSets(dataNodeId)));
        return result;
    }

    public List<TRegionReplicaSet> getReplicaSets(String database, List<TConsensusGroupId> regionGroupIds) {
        if (this.databasePartitionTables.containsKey(database)) {
            return this.databasePartitionTables.get(database).getReplicaSets(regionGroupIds);
        }
        return Collections.emptyList();
    }

    public int getRegionCount(int dataNodeId, TConsensusGroupType type) {
        AtomicInteger result = new AtomicInteger(0);
        this.databasePartitionTables.values().forEach(databasePartitionTable -> result.getAndAdd(databasePartitionTable.getRegionCount(dataNodeId, type)));
        return result.get();
    }

    public int countDataNodeScatterWidth(int dataNodeId, TConsensusGroupType type, int clusterNodeCount) {
        BitSet scatterSet = new BitSet(clusterNodeCount);
        this.databasePartitionTables.values().forEach(databasePartitionTable -> databasePartitionTable.countDataNodeScatterWidth(dataNodeId, type, scatterSet));
        return Math.max(scatterSet.cardinality() - 1, 0);
    }

    public int getRegionGroupCount(String database, TConsensusGroupType type) throws DatabaseNotExistsException {
        if (!this.isDatabaseExisted(database)) {
            throw new DatabaseNotExistsException(database);
        }
        return this.databasePartitionTables.get(database).getRegionGroupCount(type);
    }

    public Map<String, List<TConsensusGroupId>> getAllRegionGroupIdMap(TConsensusGroupType type) {
        TreeMap<String, List<TConsensusGroupId>> result = new TreeMap<String, List<TConsensusGroupId>>();
        this.databasePartitionTables.forEach((database, databasePartitionTable) -> {
            if (databasePartitionTable.isNotPreDeleted()) {
                result.put((String)database, databasePartitionTable.getAllRegionGroupIds(type));
            }
        });
        return result;
    }

    public List<TConsensusGroupId> getAllRegionGroupIds(String database, TConsensusGroupType type) throws DatabaseNotExistsException {
        if (!this.isDatabaseExisted(database)) {
            throw new DatabaseNotExistsException(database);
        }
        return this.databasePartitionTables.get(database).getAllRegionGroupIds(type);
    }

    public int getAssignedSeriesPartitionSlotsCount(String database) {
        return Optional.ofNullable(this.databasePartitionTables.get(database)).map(DatabasePartitionTable::getAssignedSeriesPartitionSlotsCount).orElse(0);
    }

    public long getAssignedTimePartitionSlotsCount(String database) {
        return Optional.ofNullable(this.databasePartitionTables.get(database)).map(DatabasePartitionTable::getTimeSlotCount).orElse(0L);
    }

    public Set<TDataNodeLocation> getDatabaseRelatedDataNodes(String database, TConsensusGroupType type) {
        return this.databasePartitionTables.get(database).getDatabaseRelatedDataNodes(type);
    }

    public List<Pair<Long, TConsensusGroupId>> getRegionGroupSlotsCounter(String database, TConsensusGroupType type) {
        return this.databasePartitionTables.get(database).getRegionGroupSlotsCounter(type);
    }

    public Set<Integer> getAllSchemaPartition() {
        HashSet<Integer> schemaPartitionSet = new HashSet<Integer>();
        this.databasePartitionTables.values().forEach(i -> schemaPartitionSet.addAll(i.getSchemaRegionIds()));
        return schemaPartitionSet;
    }

    public Map<TSeriesPartitionSlot, TConsensusGroupId> getLastDataAllotTable(String database) {
        if (this.isDatabaseExisted(database)) {
            return this.databasePartitionTables.get(database).getLastDataAllotTable();
        }
        return Collections.emptyMap();
    }

    /*
     * Exception decompiling
     */
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(snapshotFile.toPath(), new OpenOption[0]), 0x2000000);
             TIOStreamTransport tioStreamTransport = new TIOStreamTransport((InputStream)fileInputStream);){
            int i;
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)tioStreamTransport);
            this.clear();
            this.nextRegionGroupId.set(ReadWriteIOUtils.readInt((InputStream)fileInputStream));
            int length = ReadWriteIOUtils.readInt((InputStream)fileInputStream);
            for (i = 0; i < length; ++i) {
                String database = ReadWriteIOUtils.readString((InputStream)fileInputStream);
                if (database == null) {
                    throw new IOException("Failed to load snapshot because get null database name");
                }
                DatabasePartitionTable databasePartitionTable = new DatabasePartitionTable(database);
                databasePartitionTable.deserialize(fileInputStream, (TProtocol)protocol);
                this.databasePartitionTables.put(database, databasePartitionTable);
            }
            length = ReadWriteIOUtils.readInt((InputStream)fileInputStream);
            for (i = 0; i < length; ++i) {
                RegionMaintainTask task = RegionMaintainTask.Factory.create(fileInputStream, (TProtocol)protocol);
                this.regionMaintainTaskList.add(task);
            }
        }
    }

    public DataSet getRegionId(GetRegionIdPlan plan) {
        if (!this.isDatabaseExisted(plan.getDatabase())) {
            return new GetRegionIdResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), new ArrayList<TConsensusGroupId>());
        }
        DatabasePartitionTable databasePartitionTable = this.databasePartitionTables.get(plan.getDatabase());
        return new GetRegionIdResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), databasePartitionTable.getRegionId(plan.getPartitionType(), plan.getSeriesSlotId(), plan.getStartTimeSlotId(), plan.getEndTimeSlotId()).stream().distinct().sorted(Comparator.comparing(TConsensusGroupId::getId)).collect(Collectors.toList()));
    }

    public DataSet getTimeSlotList(GetTimeSlotListPlan plan) {
        if (!plan.getDatabase().equals("")) {
            if (!this.isDatabaseExisted(plan.getDatabase())) {
                return new GetTimeSlotListResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), new ArrayList<TTimePartitionSlot>());
            }
            DatabasePartitionTable sgPartitionTable = this.databasePartitionTables.get(plan.getDatabase());
            return new GetTimeSlotListResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), sgPartitionTable.getTimeSlotList(plan.getSeriesSlotId(), plan.getRegionId(), plan.getStartTime(), plan.getEndTime()).stream().distinct().sorted(Comparator.comparing(TTimePartitionSlot::getStartTime)).collect(Collectors.toList()));
        }
        ArrayList timePartitionSlots = new ArrayList();
        this.databasePartitionTables.forEach((database, databasePartitionTable) -> timePartitionSlots.addAll(databasePartitionTable.getTimeSlotList(plan.getSeriesSlotId(), plan.getRegionId(), plan.getStartTime(), plan.getEndTime())));
        return new GetTimeSlotListResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), timePartitionSlots.stream().distinct().sorted(Comparator.comparing(TTimePartitionSlot::getStartTime)).collect(Collectors.toList()));
    }

    public DataSet countTimeSlotList(CountTimeSlotListPlan plan) {
        if (!plan.getDatabase().equals("")) {
            if (!this.isDatabaseExisted(plan.getDatabase())) {
                return new CountTimeSlotListResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), 0L);
            }
            DatabasePartitionTable sgPartitionTable = this.databasePartitionTables.get(plan.getDatabase());
            return new CountTimeSlotListResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), sgPartitionTable.getTimeSlotList(plan.getSeriesSlotId(), plan.getRegionId(), plan.getStartTime(), plan.getEndTime()).stream().distinct().count());
        }
        ArrayList timePartitionSlots = new ArrayList();
        this.databasePartitionTables.forEach((database, databasePartitionTable) -> timePartitionSlots.addAll(databasePartitionTable.getTimeSlotList(plan.getSeriesSlotId(), plan.getRegionId(), plan.getStartTime(), plan.getEndTime())));
        return new CountTimeSlotListResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), timePartitionSlots.stream().distinct().count());
    }

    public DataSet getSeriesSlotList(GetSeriesSlotListPlan plan) {
        if (!this.isDatabaseExisted(plan.getDatabase())) {
            return new GetSeriesSlotListResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), new ArrayList<TSeriesPartitionSlot>());
        }
        DatabasePartitionTable sgPartitionTable = this.databasePartitionTables.get(plan.getDatabase());
        return new GetSeriesSlotListResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), sgPartitionTable.getSeriesSlotList(plan.getPartitionType()));
    }

    public void getSchemaRegionIds(List<String> databases, Map<String, List<Integer>> schemaRegionIds) {
        for (String database : databases) {
            if (!this.databasePartitionTables.containsKey(database)) continue;
            schemaRegionIds.put(database, this.databasePartitionTables.get(database).getSchemaRegionIds());
        }
    }

    public void getDataRegionIds(List<String> databases, Map<String, List<Integer>> dataRegionIds) {
        for (String database : databases) {
            if (!this.databasePartitionTables.containsKey(database)) continue;
            dataRegionIds.put(database, this.databasePartitionTables.get(database).getDataRegionIds());
        }
    }

    public Optional<TConsensusGroupType> getRegionType(int regionId) {
        return this.databasePartitionTables.values().stream().map(databasePartitionTable -> databasePartitionTable.getRegionType(regionId)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public void clear() {
        this.nextRegionGroupId.set(-1);
        this.databasePartitionTables.clear();
        this.regionMaintainTaskList.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionInfo that = (PartitionInfo)o;
        return this.nextRegionGroupId.get() == that.nextRegionGroupId.get() && this.databasePartitionTables.equals(that.databasePartitionTables) && this.regionMaintainTaskList.equals(that.regionMaintainTaskList);
    }

    public int hashCode() {
        return Objects.hash(this.nextRegionGroupId, this.databasePartitionTables, this.regionMaintainTaskList);
    }
}

