/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.metric.overview;

import com.codahale.metrics.Clock;
import com.codahale.metrics.ExponentialMovingAverages;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MovingAverages;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.enums.PipeRemainingTimeRateAverageTime;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.extractor.IoTDBNonDataRegionExtractor;
import org.apache.iotdb.commons.pipe.metric.PipeRemainingOperator;
import org.apache.iotdb.confignode.manager.pipe.extractor.IoTDBConfigRegionExtractor;

class PipeConfigNodeRemainingTimeOperator
extends PipeRemainingOperator {
    private final Set<IoTDBConfigRegionExtractor> configRegionExtractors = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicReference<Meter> configRegionCommitMeter = new AtomicReference<Object>(null);
    private double lastConfigRegionCommitSmoothingValue = 9.223372036854776E18;

    PipeConfigNodeRemainingTimeOperator(String pipeName, long creationTime) {
        super(pipeName, creationTime);
    }

    double getRemainingTime() {
        double configRegionRemainingTime;
        PipeRemainingTimeRateAverageTime pipeRemainingTimeCommitRateAverageTime = PipeConfig.getInstance().getPipeRemainingTimeCommitRateAverageTime();
        long totalConfigRegionWriteEventCount = this.configRegionExtractors.stream().map(IoTDBNonDataRegionExtractor::getUnTransferredEventCount).reduce(Long::sum).orElse(0L);
        this.configRegionCommitMeter.updateAndGet(meter -> {
            if (Objects.nonNull(meter)) {
                this.lastConfigRegionCommitSmoothingValue = pipeRemainingTimeCommitRateAverageTime.getMeterRate(meter);
            }
            return meter;
        });
        if (totalConfigRegionWriteEventCount <= 0L) {
            this.notifyEmpty();
            configRegionRemainingTime = 0.0;
        } else {
            this.notifyNonEmpty();
            configRegionRemainingTime = this.lastConfigRegionCommitSmoothingValue <= 0.0 ? Double.MAX_VALUE : (double)totalConfigRegionWriteEventCount / this.lastConfigRegionCommitSmoothingValue;
        }
        return configRegionRemainingTime >= 3.1536E7 ? 3.1536E7 : configRegionRemainingTime;
    }

    void register(IoTDBConfigRegionExtractor extractor) {
        this.configRegionExtractors.add(extractor);
    }

    void markConfigRegionCommit() {
        this.configRegionCommitMeter.updateAndGet(meter -> {
            if (Objects.nonNull(meter)) {
                meter.mark();
            }
            return meter;
        });
    }

    public synchronized void thawRate(boolean isStartPipe) {
        super.thawRate(isStartPipe);
        if (this.isStopped) {
            return;
        }
        this.configRegionCommitMeter.compareAndSet(null, new Meter((MovingAverages)new ExponentialMovingAverages(), Clock.defaultClock()));
    }

    public synchronized void freezeRate(boolean isStopPipe) {
        super.freezeRate(isStopPipe);
        this.configRegionCommitMeter.set(null);
    }
}

