/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.coordinator.runtime;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.load.subscriber.ConsensusGroupStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.IClusterStatusSubscriber;
import org.apache.iotdb.confignode.manager.load.subscriber.NodeStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.load.subscriber.RegionGroupStatisticsChangeEvent;
import org.apache.iotdb.confignode.manager.pipe.coordinator.runtime.PipeLeaderChangeHandler;
import org.apache.iotdb.confignode.manager.pipe.coordinator.runtime.PipeMetaSyncer;
import org.apache.iotdb.confignode.manager.pipe.coordinator.runtime.heartbeat.PipeHeartbeat;
import org.apache.iotdb.confignode.manager.pipe.coordinator.runtime.heartbeat.PipeHeartbeatScheduler;

public class PipeRuntimeCoordinator
implements IClusterStatusSubscriber {
    private static final AtomicReference<ExecutorService> procedureSubmitterHolder = new AtomicReference();
    private final ExecutorService procedureSubmitter;
    private final PipeLeaderChangeHandler pipeLeaderChangeHandler;
    private final PipeMetaSyncer pipeMetaSyncer;
    private final PipeHeartbeatScheduler pipeHeartbeatScheduler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public PipeRuntimeCoordinator(ConfigManager configManager) {
        if (procedureSubmitterHolder.get() == null) {
            Class<PipeRuntimeCoordinator> clazz = PipeRuntimeCoordinator.class;
            // MONITORENTER : org.apache.iotdb.confignode.manager.pipe.coordinator.runtime.PipeRuntimeCoordinator.class
            if (procedureSubmitterHolder.get() == null) {
                procedureSubmitterHolder.set(IoTDBThreadPoolFactory.newSingleThreadExecutor((String)ThreadName.PIPE_RUNTIME_PROCEDURE_SUBMITTER.getName()));
            }
            // MONITOREXIT : clazz
        }
        this.procedureSubmitter = procedureSubmitterHolder.get();
        this.pipeLeaderChangeHandler = new PipeLeaderChangeHandler(configManager);
        this.pipeMetaSyncer = new PipeMetaSyncer(configManager);
        this.pipeHeartbeatScheduler = new PipeHeartbeatScheduler(configManager);
    }

    public ExecutorService getProcedureSubmitter() {
        return this.procedureSubmitter;
    }

    public synchronized void onConfigRegionGroupLeaderChanged() {
        this.pipeLeaderChangeHandler.onConfigRegionGroupLeaderChanged();
    }

    @Override
    public void onNodeStatisticsChanged(NodeStatisticsChangeEvent event) {
    }

    @Override
    public void onRegionGroupStatisticsChanged(RegionGroupStatisticsChangeEvent event) {
    }

    @Override
    public synchronized void onConsensusGroupStatisticsChanged(ConsensusGroupStatisticsChangeEvent event) {
        this.pipeLeaderChangeHandler.onConsensusGroupStatisticsChanged(event);
    }

    public void startPipeMetaSync() {
        this.pipeMetaSyncer.start();
    }

    public void stopPipeMetaSync() {
        this.pipeMetaSyncer.stop();
    }

    public void startPipeHeartbeat() {
        this.pipeHeartbeatScheduler.start();
    }

    public void stopPipeHeartbeat() {
        this.pipeHeartbeatScheduler.stop();
    }

    public void parseHeartbeat(int dataNodeId, List<ByteBuffer> pipeMetaByteBufferListFromDataNode, List<Boolean> pipeCompletedListFromAgent, List<Long> pipeRemainingEventCountListFromAgent, List<Double> pipeRemainingTimeListFromAgent) {
        this.pipeHeartbeatScheduler.parseHeartbeat(dataNodeId, new PipeHeartbeat(pipeMetaByteBufferListFromDataNode, pipeCompletedListFromAgent, pipeRemainingEventCountListFromAgent, pipeRemainingTimeListFromAgent));
    }
}

