/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node;

import java.util.Objects;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class NodeMetrics
implements IMetricSet {
    private final NodeManager nodeManager;

    public NodeMetrics(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void bindTo(AbstractMetricService metricService) {
        for (NodeStatus status : NodeStatus.values()) {
            metricService.createAutoGauge(Metric.NODE_NUM.toString(), MetricLevel.CORE, (Object)this.nodeManager, manager -> manager.filterConfigNodeThroughStatus(status).size(), new String[]{Tag.TYPE.toString(), NodeType.ConfigNode.getNodeType(), Tag.STATUS.toString(), status.getStatus()});
            metricService.createAutoGauge(Metric.NODE_NUM.toString(), MetricLevel.CORE, (Object)this.nodeManager, manager -> manager.filterDataNodeThroughStatus(status).size(), new String[]{Tag.TYPE.toString(), NodeType.DataNode.getNodeType(), Tag.STATUS.toString(), status.getStatus()});
        }
    }

    public void unbindFrom(AbstractMetricService metricService) {
        for (NodeStatus status : NodeStatus.values()) {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.NODE_NUM.toString(), new String[]{Tag.TYPE.toString(), NodeType.ConfigNode.getNodeType(), Tag.STATUS.toString(), status.getStatus()});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.NODE_NUM.toString(), new String[]{Tag.TYPE.toString(), NodeType.DataNode.getNodeType(), Tag.STATUS.toString(), status.getStatus()});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMetrics that = (NodeMetrics)o;
        return this.nodeManager.equals(that.nodeManager);
    }

    public int hashCode() {
        return Objects.hash(this.nodeManager);
    }
}

