/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.database;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class SetTTLPlan
extends ConfigPhysicalPlan {
    private String[] pathPattern;
    boolean isDataBase = false;
    private long TTL;

    public SetTTLPlan() {
        super(ConfigPhysicalPlanType.SetTTL);
    }

    public SetTTLPlan(long TTL, String ... pathPatterns) {
        super(ConfigPhysicalPlanType.SetTTL);
        this.pathPattern = pathPatterns;
        this.TTL = TTL;
    }

    public SetTTLPlan(List<String> pathPattern, long TTL) {
        this();
        this.pathPattern = pathPattern.toArray(new String[0]);
        this.TTL = TTL;
    }

    public SetTTLPlan(String[] pathPattern, long TTL) {
        this();
        this.pathPattern = pathPattern;
        this.TTL = TTL;
    }

    public String[] getPathPattern() {
        return this.pathPattern;
    }

    public long getTTL() {
        return this.TTL;
    }

    public void setPathPattern(String[] pathPattern) {
        this.pathPattern = pathPattern;
    }

    public void setTTL(long TTL) {
        this.TTL = TTL;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.pathPattern.length);
        for (String node : this.pathPattern) {
            BasicStructureSerDeUtil.write((String)node, (DataOutputStream)stream);
        }
        stream.writeLong(this.TTL);
        stream.writeBoolean(this.isDataBase);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int length = buffer.getInt();
        this.pathPattern = new String[length];
        for (int i = 0; i < length; ++i) {
            this.pathPattern[i] = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        }
        this.TTL = buffer.getLong();
        this.isDataBase = buffer.get() != 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetTTLPlan setTTLPlan = (SetTTLPlan)o;
        return this.isDataBase == setTTLPlan.isDataBase && this.TTL == setTTLPlan.TTL && Arrays.equals(this.pathPattern, setTTLPlan.pathPattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.pathPattern), this.TTL, this.isDataBase);
    }

    public boolean isDataBase() {
        return this.isDataBase;
    }

    public void setDataBase(boolean dataBase) {
        this.isDataBase = dataBase;
    }
}

