/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.database;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class SetDataReplicationFactorPlan
extends ConfigPhysicalPlan {
    private String database;
    private int dataReplicationFactor;

    public SetDataReplicationFactorPlan() {
        super(ConfigPhysicalPlanType.SetDataReplicationFactor);
    }

    public SetDataReplicationFactorPlan(String database, int dataReplicationFactor) {
        this();
        this.database = database;
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public String getDatabase() {
        return this.database;
    }

    public int getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        BasicStructureSerDeUtil.write((String)this.database, (DataOutputStream)stream);
        stream.writeInt(this.dataReplicationFactor);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.database = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
        this.dataReplicationFactor = buffer.getInt();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetDataReplicationFactorPlan that = (SetDataReplicationFactorPlan)o;
        return this.dataReplicationFactor == that.dataReplicationFactor && this.database.equals(that.database);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.database, this.dataReplicationFactor);
    }
}

