/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.read.ConfigPhysicalReadPlan;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelReq;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ShowModelPlan
extends ConfigPhysicalReadPlan {
    private String modelName;

    public ShowModelPlan() {
        super(ConfigPhysicalPlanType.ShowModel);
    }

    public ShowModelPlan(TShowModelReq showModelReq) {
        super(ConfigPhysicalPlanType.ShowModel);
        if (showModelReq.isSetModelId()) {
            this.modelName = showModelReq.getModelId();
        }
    }

    public boolean isSetModelName() {
        return this.modelName != null;
    }

    public String getModelName() {
        return this.modelName;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((Boolean)(this.modelName != null ? 1 : 0), (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.modelName, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        boolean isSetModelId = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        if (isSetModelId) {
            this.modelName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShowModelPlan that = (ShowModelPlan)o;
        return Objects.equals(this.modelName, that.modelName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelName);
    }
}

