/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TTestConnectionResp;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.DataNodeAsyncRequestRPCHandler;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitTestConnectionTaskRPCHandler
extends DataNodeAsyncRequestRPCHandler<TTestConnectionResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubmitTestConnectionTaskRPCHandler.class);

    public SubmitTestConnectionTaskRPCHandler(CnToDnAsyncRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TTestConnectionResp> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TTestConnectionResp resp) {
        this.responseMap.put(this.requestId, resp);
        this.nodeLocationMap.remove(this.requestId);
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        this.responseMap.put(this.requestId, new TTestConnectionResp().setStatus(new TSStatus(TSStatusCode.CAN_NOT_CONNECT_DATANODE.getStatusCode()).setMessage(e.getMessage())));
        this.nodeLocationMap.remove(this.requestId);
        this.countDownLatch.countDown();
    }
}

