/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class RingBuffer<E> {
    private int read = 0;
    private int write = 0;
    private int count = 0;
    private final E[] buffer;
    private final int maxSize;

    public RingBuffer(int maxSize) {
        this.maxSize = maxSize;
        this.buffer = new Object[maxSize];
    }

    public E get(int index) {
        if (index >= this.count) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
        return this.buffer[(this.read + index) % this.maxSize];
    }

    public void set(int index, E e) {
        if (index >= this.count) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
        this.buffer[(this.read + index) % this.maxSize] = e;
    }

    public void add(@NotNull E e) {
        this.buffer[this.write] = e;
        this.write = (this.write + 1) % this.maxSize;
        if (this.count == this.maxSize) {
            this.read = (this.read + 1) % this.maxSize;
        } else {
            ++this.count;
        }
    }

    public E remove() {
        if (this.count <= 0) {
            throw new NoSuchElementException();
        }
        E e = this.buffer[this.read];
        this.buffer[this.read] = null;
        this.read = (this.read + 1) % this.maxSize;
        --this.count;
        return e;
    }

    public void clear() {
        this.count = 0;
        this.write = 0;
        this.read = 0;
        Arrays.fill(this.buffer, null);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int size() {
        return this.count;
    }
}

