/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UInt32Conversions {
    private UInt32Conversions() {
    }

    @NotNull
    static Boolean uInt32ToBoolean(@NotNull UInteger ui) {
        return ui.intValue() != 0;
    }

    @Nullable
    static UByte uInt32ToByte(@NotNull UInteger ui) {
        long l = ui.longValue();
        if (l <= 255L) {
            return Unsigned.ubyte((long)l);
        }
        return null;
    }

    @NotNull
    static Double uInt32ToDouble(@NotNull UInteger ui) {
        return ui.doubleValue();
    }

    @NotNull
    static Float uInt32ToFloat(@NotNull UInteger ui) {
        return Float.valueOf(ui.floatValue());
    }

    @Nullable
    static Short uInt32ToInt16(@NotNull UInteger ui) {
        int i = ui.intValue();
        if (i <= Short.MAX_VALUE) {
            return (short)i;
        }
        return null;
    }

    @Nullable
    static Integer uInt32ToInt32(@NotNull UInteger ui) {
        long l = ui.longValue();
        if (l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        return null;
    }

    @NotNull
    static Long uInt32ToInt64(@NotNull UInteger ui) {
        return ui.longValue();
    }

    @Nullable
    static Byte uInt32ToSByte(@NotNull UInteger ui) {
        int i = ui.intValue();
        if (i <= 127) {
            return (byte)i;
        }
        return null;
    }

    @NotNull
    static StatusCode uInt32ToStatusCode(@NotNull UInteger ui) {
        return new StatusCode(ui);
    }

    @NotNull
    static String uInt32ToString(@NotNull UInteger ui) {
        return ui.toString();
    }

    @Nullable
    static UShort uInt32ToUInt16(@NotNull UInteger ui) {
        int i = ui.intValue();
        if (i <= 65535) {
            return Unsigned.ushort((int)i);
        }
        return null;
    }

    @NotNull
    static ULong uInt32ToUInt64(@NotNull UInteger ui) {
        return Unsigned.ulong((long)ui.longValue());
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof UInteger) {
            UInteger ui = (UInteger)o;
            return implicit ? UInt32Conversions.implicitConversion(ui, targetType) : UInt32Conversions.explicitConversion(ui, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull UInteger ui, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return UInt32Conversions.uInt32ToBoolean(ui);
            }
            case Byte: {
                return UInt32Conversions.uInt32ToByte(ui);
            }
            case Int16: {
                return UInt32Conversions.uInt32ToInt16(ui);
            }
            case SByte: {
                return UInt32Conversions.uInt32ToSByte(ui);
            }
            case StatusCode: {
                return UInt32Conversions.uInt32ToStatusCode(ui);
            }
            case String: {
                return UInt32Conversions.uInt32ToString(ui);
            }
            case UInt16: {
                return UInt32Conversions.uInt32ToUInt16(ui);
            }
        }
        return UInt32Conversions.implicitConversion(ui, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull UInteger ui, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return UInt32Conversions.uInt32ToDouble(ui);
            }
            case Float: {
                return UInt32Conversions.uInt32ToFloat(ui);
            }
            case Int32: {
                return UInt32Conversions.uInt32ToInt32(ui);
            }
            case Int64: {
                return UInt32Conversions.uInt32ToInt64(ui);
            }
            case UInt64: {
                return UInt32Conversions.uInt32ToUInt64(ui);
            }
        }
        return null;
    }
}

