/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StringConversions {
    private static final DateFormat ISO_8601_UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    private StringConversions() {
    }

    @Nullable
    static Boolean stringToBoolean(@NotNull String s) {
        if (s.equalsIgnoreCase("true") || s.equals("1")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equals("0")) {
            return false;
        }
        return null;
    }

    @Nullable
    static UByte stringToByte(@NotNull String s) {
        try {
            return UByte.valueOf((String)s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    static DateTime stringToDateTime(@NotNull String s) {
        try {
            Date date = StringConversions.iso8601UtcStringToDate(s);
            return new DateTime(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Nullable
    static Double stringToDouble(@NotNull String s) {
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    static ExpandedNodeId stringToExpandedNodeId(@NotNull String s) {
        try {
            return ExpandedNodeId.parse((String)s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    static Float stringToFloat(@NotNull String s) {
        try {
            return Float.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    static UUID stringToGuid(@NotNull String s) {
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    static Short stringToInt16(@NotNull String s) {
        try {
            return Short.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    static Integer stringToInt32(@NotNull String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    static Long stringToInt64(@NotNull String s) {
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    static NodeId stringToNodeId(@NotNull String s) {
        try {
            return NodeId.parse((String)s);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    static Byte stringToSByte(@NotNull String s) {
        try {
            return Byte.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    static LocalizedText stringToLocalizedText(@NotNull String s) {
        return new LocalizedText("", s);
    }

    @NotNull
    static QualifiedName stringToQualifiedName(@NotNull String s) {
        return new QualifiedName(0, s);
    }

    @Nullable
    static UShort stringToUInt16(@NotNull String s) {
        try {
            return UShort.valueOf((String)s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    static UInteger stringToUInt32(@NotNull String s) {
        try {
            return UInteger.valueOf((String)s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    static ULong stringToUInt64(@NotNull String s) {
        try {
            return ULong.valueOf((String)s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date iso8601UtcStringToDate(String s) throws ParseException {
        DateFormat dateFormat = ISO_8601_UTC_DATE_FORMAT;
        synchronized (dateFormat) {
            return ISO_8601_UTC_DATE_FORMAT.parse(s);
        }
    }

    @Nullable
    static Object convert(@NotNull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof String) {
            String s = (String)o;
            return implicit ? StringConversions.implicitConversion(s, targetType) : StringConversions.explicitConversion(s, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull String s, BuiltinDataType targetType) {
        switch (targetType) {
            case DateTime: {
                return StringConversions.stringToDateTime(s);
            }
            case ExpandedNodeId: {
                return StringConversions.stringToExpandedNodeId(s);
            }
            case NodeId: {
                return StringConversions.stringToNodeId(s);
            }
            case LocalizedText: {
                return StringConversions.stringToLocalizedText(s);
            }
            case QualifiedName: {
                return StringConversions.stringToQualifiedName(s);
            }
        }
        return StringConversions.implicitConversion(s, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull String s, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return StringConversions.stringToBoolean(s);
            }
            case Byte: {
                return StringConversions.stringToByte(s);
            }
            case Double: {
                return StringConversions.stringToDouble(s);
            }
            case Float: {
                return StringConversions.stringToFloat(s);
            }
            case Guid: {
                return StringConversions.stringToGuid(s);
            }
            case Int16: {
                return StringConversions.stringToInt16(s);
            }
            case Int32: {
                return StringConversions.stringToInt32(s);
            }
            case Int64: {
                return StringConversions.stringToInt64(s);
            }
            case SByte: {
                return StringConversions.stringToSByte(s);
            }
            case UInt16: {
                return StringConversions.stringToUInt16(s);
            }
            case UInt32: {
                return StringConversions.stringToUInt32(s);
            }
            case UInt64: {
                return StringConversions.stringToUInt64(s);
            }
        }
        return null;
    }

    static {
        ISO_8601_UTC_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

