/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.iotdb.db.protocol.rest.v2.GrafanaApiService;
import org.apache.iotdb.db.protocol.rest.v2.NotFoundException;
import org.apache.iotdb.db.protocol.rest.v2.factories.GrafanaApiServiceFactory;
import org.apache.iotdb.db.protocol.rest.v2.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.v2.model.ExpressionRequest;
import org.apache.iotdb.db.protocol.rest.v2.model.QueryDataSet;
import org.apache.iotdb.db.protocol.rest.v2.model.SQL;

@Path(value="/grafana/v2")
@Api(description="the grafana API")
public class GrafanaApi {
    private final GrafanaApiService delegate;

    public GrafanaApi(@Context ServletConfig servletContext) {
        String implClass;
        GrafanaApiService delegate = null;
        if (servletContext != null && (implClass = servletContext.getInitParameter("GrafanaApi.implementation")) != null && !"".equals(implClass.trim())) {
            try {
                delegate = (GrafanaApiService)Class.forName(implClass).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (delegate == null) {
            delegate = GrafanaApiServiceFactory.getGrafanaApi();
        }
        this.delegate = delegate;
    }

    @POST
    @Path(value="/query/expression")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="expression", notes="expression", response=QueryDataSet.class, authorizations={@Authorization(value="basic")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="QueryDataSet", response=QueryDataSet.class)})
    public Response expression(@ApiParam(value="") @Valid ExpressionRequest expressionRequest, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.expression(expressionRequest, securityContext);
    }

    @GET
    @Path(value="/login")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", response=ExecutionStatus.class, authorizations={@Authorization(value="basic")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="ExecutionStatus", response=ExecutionStatus.class)})
    public Response login(@Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.login(securityContext);
    }

    @POST
    @Path(value="/node")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="node", notes="node", response=String.class, responseContainer="List", authorizations={@Authorization(value="basic")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="NodesResult", response=String.class, responseContainer="List")})
    public Response node(@ApiParam(value="") @Valid List<String> requestBody, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.node(requestBody, securityContext);
    }

    @POST
    @Path(value="/variable")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="variables", notes="variables", response=Object.class, responseContainer="List", authorizations={@Authorization(value="basic")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="VariablesResult", response=Object.class, responseContainer="List")})
    public Response variables(@ApiParam(value="") @Valid SQL SQL2, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.variables(SQL2, securityContext);
    }
}

