/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.server.DataStreamMap;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataStreamMapImpl
implements DataStreamMap {
    public static final Logger LOG = LoggerFactory.getLogger(DataStreamMapImpl.class);
    private final String name;
    private final ConcurrentMap<ClientInvocationId, CompletableFuture<StateMachine.DataStream>> map = new ConcurrentHashMap<ClientInvocationId, CompletableFuture<StateMachine.DataStream>>();

    DataStreamMapImpl(Object name) {
        this.name = name + "-" + JavaUtils.getClassSimpleName(this.getClass());
    }

    public CompletableFuture<StateMachine.DataStream> remove(ClientInvocationId invocationId) {
        return (CompletableFuture)this.map.remove(invocationId);
    }

    public CompletableFuture<StateMachine.DataStream> computeIfAbsent(ClientInvocationId invocationId, Function<ClientInvocationId, CompletableFuture<StateMachine.DataStream>> newDataStream) {
        return this.map.computeIfAbsent(invocationId, newDataStream);
    }

    public String toString() {
        return this.name;
    }
}

