/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.record.datapoint;

import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.record.datapoint.DataPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringDataPoint
extends DataPoint {
    private static final Logger LOG = LoggerFactory.getLogger(StringDataPoint.class);
    private Binary value;

    public StringDataPoint(String measurementId, Binary v) {
        super(TSDataType.TEXT, measurementId);
        this.value = v;
    }

    @Override
    public void writeTo(long time, ChunkWriterImpl writer) {
        if (writer == null) {
            LOG.warn("given IChunkWriter is null, do nothing and return");
            return;
        }
        writer.write(time, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setString(Binary value) {
        this.value = value;
    }
}

