/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TByteBuffer;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftConfigNodeSerDeUtils {
    private ThriftConfigNodeSerDeUtils() {
    }

    private static TBinaryProtocol generateWriteProtocol(ByteBuffer buffer) throws TTransportException {
        TByteBuffer transport = new TByteBuffer(buffer);
        return new TBinaryProtocol((TTransport)transport);
    }

    private static TBinaryProtocol generateReadProtocol(ByteBuffer buffer) throws TTransportException {
        TByteBuffer transport = new TByteBuffer(buffer);
        return new TBinaryProtocol((TTransport)transport);
    }

    private static TBinaryProtocol generateWriteProtocol(OutputStream outputStream) throws TTransportException {
        TIOStreamTransport tioStreamTransport = new TIOStreamTransport(outputStream);
        return new TBinaryProtocol((TTransport)tioStreamTransport);
    }

    private static TBinaryProtocol generateReadProtocol(InputStream inputStream) throws TTransportException {
        TIOStreamTransport tioStreamTransport = new TIOStreamTransport(inputStream);
        return new TBinaryProtocol((TTransport)tioStreamTransport);
    }

    public static void serializeTDatabaseSchema(TDatabaseSchema storageGroupSchema, ByteBuffer buffer) {
        try {
            storageGroupSchema.write((TProtocol)ThriftConfigNodeSerDeUtils.generateWriteProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TStorageGroupSchema failed: ", e);
        }
    }

    public static TDatabaseSchema deserializeTDatabaseSchema(ByteBuffer buffer) {
        TDatabaseSchema storageGroupSchema = new TDatabaseSchema();
        try {
            storageGroupSchema.read((TProtocol)ThriftConfigNodeSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TStorageGroupSchema failed: ", e);
        }
        return storageGroupSchema;
    }

    public static void serializeTDatabaseSchema(TDatabaseSchema storageGroupSchema, OutputStream outputStream) {
        try {
            storageGroupSchema.write((TProtocol)ThriftConfigNodeSerDeUtils.generateWriteProtocol(outputStream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TStorageGroupSchema failed: ", e);
        }
    }

    public static TDatabaseSchema deserializeTDatabaseSchema(InputStream inputStream) {
        TDatabaseSchema storageGroupSchema = new TDatabaseSchema();
        try {
            storageGroupSchema.read((TProtocol)ThriftConfigNodeSerDeUtils.generateReadProtocol(inputStream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TStorageGroupSchema failed: ", e);
        }
        return storageGroupSchema;
    }

    public static void serializeTConfigNodeLocation(TConfigNodeLocation configNodeLocation, ByteBuffer buffer) {
        try {
            configNodeLocation.write((TProtocol)ThriftConfigNodeSerDeUtils.generateWriteProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TConfigNodeLocation failed: ", e);
        }
    }

    public static void serializeTConfigNodeLocation(TConfigNodeLocation configNodeLocation, DataOutputStream stream) {
        try {
            configNodeLocation.write((TProtocol)ThriftConfigNodeSerDeUtils.generateWriteProtocol(stream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TConfigNodeLocation failed: ", e);
        }
    }

    public static TConfigNodeLocation deserializeTConfigNodeLocation(ByteBuffer buffer) {
        TConfigNodeLocation configNodeLocation = new TConfigNodeLocation();
        try {
            configNodeLocation.read((TProtocol)ThriftConfigNodeSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TConfigNodeLocation failed: ", e);
        }
        return configNodeLocation;
    }

    public static void serializeTPipeSinkInfo(TPipeSinkInfo pipeSinkInfo, DataOutputStream stream) {
        try {
            pipeSinkInfo.write((TProtocol)ThriftConfigNodeSerDeUtils.generateWriteProtocol(stream));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Write TPipeSinkInfo failed: ", e);
        }
    }

    public static TPipeSinkInfo deserializeTPipeSinkInfo(ByteBuffer buffer) {
        TPipeSinkInfo pipeSinkInfo = new TPipeSinkInfo();
        try {
            pipeSinkInfo.read((TProtocol)ThriftConfigNodeSerDeUtils.generateReadProtocol(buffer));
        }
        catch (TException e) {
            throw new ThriftSerDeException("Read TPipeSinkInfo failed: ", e);
        }
        return pipeSinkInfo;
    }
}

