/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.subscription;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class SubscriptionMeta {
    private String topicName;
    private String consumerGroupId;
    private Set<String> consumerIds;

    private SubscriptionMeta() {
    }

    public SubscriptionMeta(String topicName, String consumerGroupId, Set<String> consumerIds) {
        this.topicName = topicName;
        this.consumerGroupId = consumerGroupId;
        this.consumerIds = consumerIds;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public Set<String> getConsumerIds() {
        return this.consumerIds;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.topicName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.consumerGroupId, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.consumerIds.size(), (OutputStream)outputStream);
        for (String consumerId : this.consumerIds) {
            ReadWriteIOUtils.write((String)consumerId, (OutputStream)outputStream);
        }
    }

    public void serialize(FileOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.topicName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.consumerGroupId, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.consumerIds.size(), (OutputStream)outputStream);
        for (String consumerId : this.consumerIds) {
            ReadWriteIOUtils.write((String)consumerId, (OutputStream)outputStream);
        }
    }

    public static SubscriptionMeta deserialize(InputStream inputStream) throws IOException {
        SubscriptionMeta subscriptionMeta = new SubscriptionMeta();
        subscriptionMeta.topicName = ReadWriteIOUtils.readString((InputStream)inputStream);
        subscriptionMeta.consumerGroupId = ReadWriteIOUtils.readString((InputStream)inputStream);
        subscriptionMeta.consumerIds = new HashSet<String>();
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            subscriptionMeta.consumerIds.add(ReadWriteIOUtils.readString((InputStream)inputStream));
        }
        return subscriptionMeta;
    }

    public static SubscriptionMeta deserialize(ByteBuffer byteBuffer) {
        SubscriptionMeta subscriptionMeta = new SubscriptionMeta();
        subscriptionMeta.topicName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        subscriptionMeta.consumerGroupId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        subscriptionMeta.consumerIds = new HashSet<String>();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            subscriptionMeta.consumerIds.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        return subscriptionMeta;
    }
}

