/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.ttl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

@NotThreadSafe
public class TTLCache {
    private final CacheNode ttlCacheTree = new CacheNode("root");
    public static final long NULL_TTL = -1L;
    private int ttlCount;

    public TTLCache() {
        this.ttlCacheTree.addChild("**", Long.MAX_VALUE);
        this.ttlCount = 1;
    }

    public void setTTL(String[] nodes, long ttl) {
        if (nodes.length < 2 || ttl < 0L) {
            return;
        }
        CacheNode current = this.ttlCacheTree;
        for (int i = 1; i < nodes.length; ++i) {
            CacheNode child = current.getChild(nodes[i]);
            if (child == null) {
                child = current.addChild(nodes[i], -1L);
            }
            current = child;
        }
        if (current.ttl == -1L) {
            ++this.ttlCount;
        }
        current.ttl = ttl;
    }

    public TSStatus unsetTTL(String[] nodes) {
        if (nodes.length < 2) {
            return new TSStatus(TSStatusCode.ILLEGAL_PATH.getStatusCode()).setMessage(String.join((CharSequence)".", nodes));
        }
        if (nodes.length == 2 && nodes[0].equals("root") && nodes[1].equals("**")) {
            this.ttlCacheTree.getChild((String)"**").ttl = Long.MAX_VALUE;
            return StatusUtils.OK;
        }
        CacheNode current = this.ttlCacheTree;
        int index = 0;
        CacheNode parentOfSubPathToBeRemoved = null;
        for (int i = 1; i < nodes.length; ++i) {
            boolean hasNonDefaultTTL = !current.getChildren().isEmpty() || current.ttl != -1L;
            CacheNode child = current.getChild(nodes[i]);
            if (child == null) {
                return new TSStatus(TSStatusCode.PATH_NOT_EXIST.getStatusCode()).setMessage("Not TTL rule set for " + String.join((CharSequence)".", nodes));
            }
            if (hasNonDefaultTTL) {
                parentOfSubPathToBeRemoved = current;
                index = i;
            }
            current = child;
        }
        if (current.ttl != -1L) {
            --this.ttlCount;
        }
        if (!current.getChildren().isEmpty()) {
            current.ttl = -1L;
            return StatusUtils.OK;
        }
        if (parentOfSubPathToBeRemoved != null) {
            parentOfSubPathToBeRemoved.removeChild(nodes[index]);
        }
        return StatusUtils.OK;
    }

    public long getClosestTTL(String[] nodes) {
        long ttl = this.ttlCacheTree.ttl;
        CacheNode current = this.ttlCacheTree;
        for (int i = 1; i < nodes.length; ++i) {
            CacheNode child = current.getChild("**");
            ttl = child != null ? child.ttl : ttl;
            if ((current = current.getChild(nodes[i])) == null) break;
        }
        ttl = current != null && current.ttl != -1L ? current.ttl : ttl;
        return ttl;
    }

    public long getLastNodeTTL(String[] nodes) {
        CacheNode node = this.ttlCacheTree;
        for (int i = 1; i < nodes.length; ++i) {
            if ((node = node.getChild(nodes[i])) != null) continue;
            return -1L;
        }
        return node.ttl;
    }

    public long getDatabaseMaxTTL(String database) {
        CacheNode node = this.ttlCacheTree.searchChild(database);
        if (node == null) {
            return -1L;
        }
        LinkedList<CacheNode> queue = new LinkedList<CacheNode>();
        queue.add(node);
        long maxTTL = node.ttl;
        while (!queue.isEmpty()) {
            CacheNode current = (CacheNode)queue.poll();
            for (CacheNode child : current.getChildren().values()) {
                queue.add(child);
                maxTTL = Math.max(maxTTL, child.ttl);
            }
        }
        return maxTTL;
    }

    public Map<String, Long> getAllPathTTL() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Map.Entry<String[], Long> entry : this.getAllTTLs().entrySet()) {
            result.put(String.join((CharSequence)String.valueOf('.'), entry.getKey()), entry.getValue());
        }
        return result;
    }

    public Map<String[], Long> getAllTTLs() {
        HashMap<String[], Long> result = new HashMap<String[], Long>();
        ArrayList<String> pathNodes = new ArrayList<String>();
        pathNodes.add("root");
        this.dfsCacheTree(result, pathNodes, this.ttlCacheTree);
        return result;
    }

    private void dfsCacheTree(Map<String[], Long> pathTTLMap, List<String> pathNodes, CacheNode node) {
        if (node.ttl != -1L) {
            pathTTLMap.put(pathNodes.toArray(new String[0]), node.ttl);
        }
        for (Map.Entry<String, CacheNode> entry : node.getChildren().entrySet()) {
            pathNodes.add(entry.getKey());
            this.dfsCacheTree(pathTTLMap, pathNodes, entry.getValue());
            pathNodes.remove(pathNodes.size() - 1);
        }
    }

    public int getTtlCount() {
        return this.ttlCount;
    }

    public void serialize(OutputStream outputStream) throws IOException {
        Map<String, Long> allPathTTLMap = this.getAllPathTTL();
        ReadWriteIOUtils.write((int)allPathTTLMap.size(), (OutputStream)outputStream);
        for (Map.Entry<String, Long> entry : allPathTTLMap.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)entry.getValue(), (OutputStream)outputStream);
        }
        outputStream.flush();
    }

    public void deserialize(InputStream bufferedInputStream) throws IOException, IllegalPathException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)bufferedInputStream); size > 0; --size) {
            String path = ReadWriteIOUtils.readString((InputStream)bufferedInputStream);
            long ttl = ReadWriteIOUtils.readLong((InputStream)bufferedInputStream);
            this.setTTL(PathUtils.splitPathToDetachedNodes(path), ttl);
        }
    }

    public void clear() {
        this.ttlCacheTree.removeAllChildren();
        this.ttlCacheTree.addChild("**", Long.MAX_VALUE);
    }

    static class CacheNode {
        public String name;
        public long ttl;
        private final Map<String, CacheNode> children = new HashMap<String, CacheNode>();

        public CacheNode(String name, long ttl) {
            this.name = name;
            this.ttl = ttl;
        }

        public CacheNode(String name) {
            this.name = name;
            this.ttl = -1L;
        }

        public CacheNode addChild(String name, long ttl) {
            CacheNode newNode = new CacheNode(name, ttl);
            this.children.put(name, newNode);
            return newNode;
        }

        public void removeChild(String name) {
            this.children.remove(name);
        }

        public void removeAllChildren() {
            this.children.clear();
        }

        public CacheNode getChild(String name) {
            if (name.startsWith("root.")) {
                name = name.substring("root.".length());
            }
            return this.children.get(name);
        }

        public CacheNode searchChild(String name) {
            String[] nodeNames = name.split("\\.");
            CacheNode current = this;
            for (String nodeName : nodeNames) {
                if (nodeName.equals("root") || (current = current.getChild(nodeName)) != null) continue;
                return null;
            }
            return current;
        }

        public Map<String, CacheNode> getChildren() {
            return this.children;
        }
    }
}

