/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.iotdb.commons.concurrent.threadpool.IThreadPoolMBean;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.metrics.utils.SystemTag;

public class ThreadPoolMetrics
implements IMetricSet {
    private AbstractMetricService metricService;
    private final Map<String, IThreadPoolMBean> notRegisteredPoolMap = new HashMap<String, IThreadPoolMBean>();
    private final Map<String, IThreadPoolMBean> registeredPoolMap = new HashMap<String, IThreadPoolMBean>();

    public static ThreadPoolMetrics getInstance() {
        return ThreadPoolMetricsHolder.INSTANCE;
    }

    private ThreadPoolMetrics() {
    }

    public synchronized void registerThreadPool(IThreadPoolMBean pool, String name) {
        if (this.metricService == null) {
            this.notRegisteredPoolMap.put(name, pool);
        } else {
            this.registeredPoolMap.put(name, pool);
            this.registerThreadPoolMetrics(name);
        }
    }

    private void registerThreadPoolMetrics(String name) {
        this.metricService.createAutoGauge(SystemMetric.THREAD_POOL_ACTIVE_THREAD_COUNT.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> Optional.ofNullable(this.registeredPoolMap.get(name)).map(IThreadPoolMBean::getActiveCount).orElse(0).intValue(), new String[]{SystemTag.POOL_NAME.toString(), name});
        this.metricService.createAutoGauge(SystemMetric.THREAD_POOL_CORE_SIZE.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> Optional.ofNullable(this.registeredPoolMap.get(name)).map(IThreadPoolMBean::getCorePoolSize).orElse(0).intValue(), new String[]{SystemTag.POOL_NAME.toString(), name});
        this.metricService.createAutoGauge(SystemMetric.THREAD_POOL_WAITING_TASK_COUNT.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> Optional.ofNullable(this.registeredPoolMap.get(name)).map(IThreadPoolMBean::getQueueLength).orElse(0).intValue(), new String[]{SystemTag.POOL_NAME.toString(), name});
        this.metricService.createAutoGauge(SystemMetric.THREAD_POOL_DONE_TASK_COUNT.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> Optional.ofNullable(this.registeredPoolMap.get(name)).map(IThreadPoolMBean::getCompletedTaskCount).orElse(0L).longValue(), new String[]{SystemTag.POOL_NAME.toString(), name});
        this.metricService.createAutoGauge(SystemMetric.THREAD_POOL_LARGEST_POOL_SIZE.toString(), MetricLevel.IMPORTANT, this.registeredPoolMap, map -> Optional.ofNullable(this.registeredPoolMap.get(name)).map(IThreadPoolMBean::getLargestPoolSize).orElse(0).intValue(), new String[]{SystemTag.POOL_NAME.toString(), name});
    }

    public synchronized void unRegisterThreadPool(String name) {
        if (this.metricService == null) {
            this.notRegisteredPoolMap.remove(name);
        } else {
            this.registeredPoolMap.remove(name);
            this.unRegisterThreadPoolMetrics(name);
        }
    }

    private void unRegisterThreadPoolMetrics(String name) {
        this.metricService.remove(MetricType.GAUGE, SystemMetric.THREAD_POOL_ACTIVE_THREAD_COUNT.toString(), new String[]{SystemTag.POOL_NAME.toString(), name});
        this.metricService.remove(MetricType.GAUGE, SystemMetric.THREAD_POOL_CORE_SIZE.toString(), new String[]{SystemTag.POOL_NAME.toString(), name});
        this.metricService.remove(MetricType.GAUGE, SystemMetric.THREAD_POOL_WAITING_TASK_COUNT.toString(), new String[]{SystemTag.POOL_NAME.toString(), name});
        this.metricService.remove(MetricType.GAUGE, SystemMetric.THREAD_POOL_DONE_TASK_COUNT.toString(), new String[]{SystemTag.POOL_NAME.toString(), name});
        this.metricService.remove(MetricType.GAUGE, SystemMetric.THREAD_POOL_LARGEST_POOL_SIZE.toString(), new String[]{SystemTag.POOL_NAME.toString(), name});
    }

    public synchronized void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        for (Map.Entry<String, IThreadPoolMBean> entry : this.notRegisteredPoolMap.entrySet()) {
            this.registerThreadPoolMetrics(entry.getKey());
        }
        this.registeredPoolMap.putAll(this.notRegisteredPoolMap);
        this.notRegisteredPoolMap.clear();
    }

    public synchronized void unbindFrom(AbstractMetricService metricService) {
        for (Map.Entry<String, IThreadPoolMBean> entry : this.registeredPoolMap.entrySet()) {
            this.unRegisterThreadPoolMetrics(entry.getKey());
        }
        this.registeredPoolMap.clear();
        this.notRegisteredPoolMap.clear();
    }

    private static class ThreadPoolMetricsHolder {
        private static final ThreadPoolMetrics INSTANCE = new ThreadPoolMetrics();

        private ThreadPoolMetricsHolder() {
        }
    }
}

