/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.jvm;

import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.function.ToLongFunction;

public class JvmUtils {
    private JvmUtils() {
    }

    static double getUsageValue(MemoryPoolMXBean memoryPoolMxBean, ToLongFunction<MemoryUsage> getter) {
        MemoryUsage usage = JvmUtils.getUsage(memoryPoolMxBean);
        if (usage == null) {
            return Double.NaN;
        }
        return getter.applyAsLong(usage);
    }

    private static MemoryUsage getUsage(MemoryPoolMXBean memoryPoolMxBean) {
        try {
            return memoryPoolMxBean.getUsage();
        }
        catch (InternalError e) {
            return null;
        }
    }
}

