/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.sql;

import java.io.File;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.trigger.executor.TriggerEvent;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.index.common.IndexType;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.AggregationQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteDataOperator;
import org.apache.iotdb.db.qp.logical.crud.FillClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.FillQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromComponent;
import org.apache.iotdb.db.qp.logical.crud.GroupByClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.GroupByFillClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.GroupByFillQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.GroupByQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.InOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.LastQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.LikeOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.RegexpOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectComponent;
import org.apache.iotdb.db.qp.logical.crud.SelectIntoOperator;
import org.apache.iotdb.db.qp.logical.crud.SpecialClauseComponent;
import org.apache.iotdb.db.qp.logical.crud.UDAFQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.UDTFQueryOperator;
import org.apache.iotdb.db.qp.logical.crud.WhereComponent;
import org.apache.iotdb.db.qp.logical.sys.ActivateTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.AlterTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.CancelArchivingOperator;
import org.apache.iotdb.db.qp.logical.sys.ClearCacheOperator;
import org.apache.iotdb.db.qp.logical.sys.CountOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateAlignedTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateContinuousQueryOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateFunctionOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateSnapshotOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.DataAuthOperator;
import org.apache.iotdb.db.qp.logical.sys.DeactivateTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.DeletePartitionOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.DropContinuousQueryOperator;
import org.apache.iotdb.db.qp.logical.sys.DropFunctionOperator;
import org.apache.iotdb.db.qp.logical.sys.DropTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.DropTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.ExportSchemaOperator;
import org.apache.iotdb.db.qp.logical.sys.FlushOperator;
import org.apache.iotdb.db.qp.logical.sys.KillQueryOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadConfigurationOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadFilesOperator;
import org.apache.iotdb.db.qp.logical.sys.MergeOperator;
import org.apache.iotdb.db.qp.logical.sys.PauseArchivingOperator;
import org.apache.iotdb.db.qp.logical.sys.RemoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.ResumeArchivingOperator;
import org.apache.iotdb.db.qp.logical.sys.SetArchivingOperator;
import org.apache.iotdb.db.qp.logical.sys.SetStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.SetSystemModeOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.SettleOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowArchivingOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildNodesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildPathsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowContinuousQueriesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowDevicesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowFunctionsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowLockInfoOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowNodesInTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowPathsSetTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowPathsUsingTemplateOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowQueryResourceOperate;
import org.apache.iotdb.db.qp.logical.sys.ShowStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTemplatesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTriggersOperator;
import org.apache.iotdb.db.qp.logical.sys.StartTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.StopTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.UnSetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.UnloadFileOperator;
import org.apache.iotdb.db.qp.logical.sys.UnsetTemplateOperator;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParser;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParserBaseVisitor;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LinearFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.db.query.executor.fill.ValueFill;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.db.query.expression.binary.AdditionExpression;
import org.apache.iotdb.db.query.expression.binary.DivisionExpression;
import org.apache.iotdb.db.query.expression.binary.ModuloExpression;
import org.apache.iotdb.db.query.expression.binary.MultiplicationExpression;
import org.apache.iotdb.db.query.expression.binary.SubtractionExpression;
import org.apache.iotdb.db.query.expression.unary.ConstantOperand;
import org.apache.iotdb.db.query.expression.unary.FunctionExpression;
import org.apache.iotdb.db.query.expression.unary.NegationExpression;
import org.apache.iotdb.db.query.expression.unary.TimeSeriesOperand;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class IoTDBSqlVisitor
extends IoTDBSqlParserBaseVisitor<Operator> {
    private static final String DELETE_RANGE_ERROR_MSG = "For delete statement, where clause can only contain atomic expressions like : time > XXX, time <= XXX, or two atomic expressions connected by 'AND'";
    private static final String DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG = "For delete statement, where clause can only contain time expressions, value filter is not currently supported.";
    private static final Pattern leveledPathNodePattern = Pattern.compile("\\$\\{\\w+}");
    private ZoneId zoneId;
    private QueryOperator queryOp;
    private IoTDBConstant.ClientVersion clientVersion = IoTDBConstant.ClientVersion.V_0_13;

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setClientVersion(IoTDBConstant.ClientVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public Operator visitSingleStatement(IoTDBSqlParser.SingleStatementContext ctx) {
        Operator operator = (Operator)this.visit((ParseTree)ctx.statement());
        if (ctx.DEBUG() != null) {
            operator.setDebug(true);
        }
        return operator;
    }

    public Operator visitSetStorageGroup(IoTDBSqlParser.SetStorageGroupContext ctx) {
        SetStorageGroupOperator setStorageGroupOperator = new SetStorageGroupOperator(53);
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        setStorageGroupOperator.setPath(path);
        return setStorageGroupOperator;
    }

    public Operator visitCreateStorageGroup(IoTDBSqlParser.CreateStorageGroupContext ctx) {
        SetStorageGroupOperator setStorageGroupOperator = new SetStorageGroupOperator(53);
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        setStorageGroupOperator.setPath(path);
        return setStorageGroupOperator;
    }

    public Operator visitCreateNonAlignedTimeseries(IoTDBSqlParser.CreateNonAlignedTimeseriesContext ctx) {
        CreateTimeSeriesOperator createTimeSeriesOperator = new CreateTimeSeriesOperator(51);
        createTimeSeriesOperator.setPath(this.parseFullPath(ctx.fullPath()));
        if (ctx.attributeClauses() != null) {
            this.parseAttributeClauses(ctx.attributeClauses(), createTimeSeriesOperator);
        }
        return createTimeSeriesOperator;
    }

    public Operator visitCreateAlignedTimeseries(IoTDBSqlParser.CreateAlignedTimeseriesContext ctx) {
        CreateAlignedTimeSeriesOperator createAlignedTimeSeriesOperator = new CreateAlignedTimeSeriesOperator(51);
        createAlignedTimeSeriesOperator.setPrefixPath(this.parseFullPath(ctx.fullPath()));
        this.parseAlignedMeasurements(ctx.alignedMeasurements(), createAlignedTimeSeriesOperator);
        return createAlignedTimeSeriesOperator;
    }

    public void parseAlignedMeasurements(IoTDBSqlParser.AlignedMeasurementsContext ctx, CreateAlignedTimeSeriesOperator createAlignedTimeSeriesOperator) {
        for (int i = 0; i < ctx.nodeNameWithoutWildcard().size(); ++i) {
            createAlignedTimeSeriesOperator.addMeasurement(this.parseNodeName(ctx.nodeNameWithoutWildcard(i).getText()));
            this.parseAttributeClauses(ctx.attributeClauses(i), createAlignedTimeSeriesOperator);
        }
    }

    public void parseAttributeClauses(IoTDBSqlParser.AttributeClausesContext ctx, CreateTimeSeriesOperator createTimeSeriesOperator) {
        if (ctx.alias() != null) {
            createTimeSeriesOperator.setAlias(this.parseNodeName(ctx.alias().nodeNameCanInExpr().getText()));
        }
        String dataType = ctx.dataType.getText().toUpperCase();
        TSDataType tsDataType = TSDataType.valueOf((String)dataType);
        createTimeSeriesOperator.setDataType(tsDataType);
        IoTDBDescriptor ioTDBDescriptor = IoTDBDescriptor.getInstance();
        TSEncoding encoding = ioTDBDescriptor.getDefaultEncodingByType(tsDataType);
        if (Objects.nonNull(ctx.encoding)) {
            String encodingString = ctx.encoding.getText().toUpperCase();
            encoding = TSEncoding.valueOf((String)encodingString);
        }
        createTimeSeriesOperator.setEncoding(encoding);
        List properties = ctx.propertyClause();
        CompressionType compressor = ctx.compressor != null ? CompressionType.valueOf((String)ctx.compressor.getText().toUpperCase()) : TSFileDescriptor.getInstance().getConfig().getCompressor();
        HashMap<String, String> props = null;
        if (ctx.propertyClause(0) != null) {
            props = new HashMap<String, String>(properties.size());
            for (IoTDBSqlParser.PropertyClauseContext property : properties) {
                props.put(this.parseIdentifier(property.identifier().getText()).toLowerCase(), this.parseStringLiteral(property.propertyValue().getText().toLowerCase()));
            }
        }
        createTimeSeriesOperator.setCompressor(compressor);
        createTimeSeriesOperator.setProps(props);
        if (ctx.tagClause() != null) {
            this.parseTagClause(ctx.tagClause(), createTimeSeriesOperator);
        }
        if (ctx.attributeClause() != null) {
            this.parseAttributeClause(ctx.attributeClause(), createTimeSeriesOperator);
        }
    }

    public void parseAttributeClauses(IoTDBSqlParser.AttributeClausesContext ctx, CreateAlignedTimeSeriesOperator createAlignedTimeSeriesOperator) {
        if (ctx.alias() != null) {
            throw new SQLParserException("create aligned timeseries: alias is not supported yet.");
        }
        String dataTypeString = ctx.dataType.getText().toUpperCase();
        TSDataType dataType = TSDataType.valueOf((String)dataTypeString);
        createAlignedTimeSeriesOperator.addDataType(dataType);
        TSEncoding encoding = IoTDBDescriptor.getInstance().getDefaultEncodingByType(dataType);
        if (Objects.nonNull(ctx.encoding)) {
            String encodingString = ctx.encoding.getText().toUpperCase();
            encoding = TSEncoding.valueOf((String)encodingString);
        }
        createAlignedTimeSeriesOperator.addEncoding(encoding);
        CompressionType compressor = TSFileDescriptor.getInstance().getConfig().getCompressor();
        if (ctx.compressor != null) {
            String compressorString = ctx.compressor.getText().toUpperCase();
            compressor = CompressionType.valueOf((String)compressorString);
        }
        createAlignedTimeSeriesOperator.addCompressor(compressor);
        if (ctx.propertyClause(0) != null) {
            throw new SQLParserException("create aligned timeseries: property is not supported yet.");
        }
        if (ctx.tagClause() != null) {
            throw new SQLParserException("create aligned timeseries: tag is not supported yet.");
        }
        if (ctx.attributeClause() != null) {
            throw new SQLParserException("create aligned timeseries: attribute is not supported yet.");
        }
    }

    public Operator visitCreateSchemaTemplate(IoTDBSqlParser.CreateSchemaTemplateContext ctx) {
        CreateTemplateOperator createTemplateOperator = new CreateTemplateOperator(112);
        createTemplateOperator.setName(this.parseIdentifier(ctx.templateName.getText()));
        if (ctx.ALIGNED() != null) {
            ArrayList<String> measurements = new ArrayList<String>();
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
            for (IoTDBSqlParser.TemplateMeasurementClauseContext templateClauseContext : ctx.templateMeasurementClause()) {
                measurements.add(this.parseNodeName(templateClauseContext.nodeNameWithoutWildcard().getText()));
                this.parseAttributeClause(templateClauseContext.attributeClauses(), dataTypes, encodings, compressors);
            }
            createTemplateOperator.addMeasurements(measurements);
            createTemplateOperator.addDataTypes(dataTypes);
            createTemplateOperator.addEncodings(encodings);
            createTemplateOperator.addCompressor(compressors);
        } else {
            for (IoTDBSqlParser.TemplateMeasurementClauseContext templateClauseContext : ctx.templateMeasurementClause()) {
                this.parseTemplateMeasurementClause(templateClauseContext, createTemplateOperator);
            }
        }
        return createTemplateOperator;
    }

    private void parseTemplateMeasurementClause(IoTDBSqlParser.TemplateMeasurementClauseContext ctx, CreateTemplateOperator createTemplateOperator) {
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        measurements.add(this.parseNodeName(ctx.nodeNameWithoutWildcard().getText()));
        this.parseAttributeClause(ctx.attributeClauses(), dataTypes, encodings, compressors);
        createTemplateOperator.addMeasurements(measurements);
        createTemplateOperator.addDataTypes(dataTypes);
        createTemplateOperator.addEncodings(encodings);
        createTemplateOperator.addCompressor(compressors);
    }

    void parseAttributeClause(IoTDBSqlParser.AttributeClausesContext ctx, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) {
        if (ctx.alias() != null) {
            throw new SQLParserException("schema template: alias is not supported yet.");
        }
        String dataTypeString = ctx.dataType.getText().toUpperCase();
        TSDataType dataType = TSDataType.valueOf((String)dataTypeString);
        dataTypes.add(dataType);
        TSEncoding encoding = IoTDBDescriptor.getInstance().getDefaultEncodingByType(dataType);
        if (Objects.nonNull(ctx.encoding)) {
            String encodingString = ctx.encoding.getText().toUpperCase();
            encoding = TSEncoding.valueOf((String)encodingString);
        }
        encodings.add(encoding);
        CompressionType compressor = TSFileDescriptor.getInstance().getConfig().getCompressor();
        if (ctx.compressor != null) {
            String compressorString = ctx.compressor.getText().toUpperCase();
            compressor = CompressionType.valueOf((String)compressorString);
        }
        compressors.add(compressor);
        if (ctx.propertyClause(0) != null) {
            throw new SQLParserException("schema template: property is not supported yet.");
        }
        if (ctx.tagClause() != null) {
            throw new SQLParserException("schema template: tag is not supported yet.");
        }
        if (ctx.attributeClause() != null) {
            throw new SQLParserException("schema template: attribute is not supported yet.");
        }
    }

    public Operator visitCreateTimeseriesOfSchemaTemplate(IoTDBSqlParser.CreateTimeseriesOfSchemaTemplateContext ctx) {
        ActivateTemplateOperator operator = new ActivateTemplateOperator(114);
        operator.setPrefixPath(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitDeactivateSchemaTemplate(IoTDBSqlParser.DeactivateSchemaTemplateContext ctx) {
        DeactivateTemplateOperator operator = new DeactivateTemplateOperator(124);
        operator.setPrefixPath(this.parsePrefixPath(ctx.prefixPath()));
        operator.setTemplateName(this.parseIdentifier(ctx.templateName.getText()));
        return operator;
    }

    public Operator visitCreateFunction(IoTDBSqlParser.CreateFunctionContext ctx) {
        CreateFunctionOperator createFunctionOperator = new CreateFunctionOperator(92);
        createFunctionOperator.setUdfName(this.parseIdentifier(ctx.udfName.getText()));
        createFunctionOperator.setClassName(this.parseStringLiteral(ctx.className.getText()));
        return createFunctionOperator;
    }

    public Operator visitCreateTrigger(IoTDBSqlParser.CreateTriggerContext ctx) {
        CreateTriggerOperator createTriggerOperator = new CreateTriggerOperator(100);
        createTriggerOperator.setTriggerName(this.parseIdentifier(ctx.triggerName.getText()));
        createTriggerOperator.setEvent(ctx.triggerEventClause().BEFORE() != null ? TriggerEvent.BEFORE_INSERT : TriggerEvent.AFTER_INSERT);
        createTriggerOperator.setFullPath(this.parseFullPath(ctx.fullPath()));
        createTriggerOperator.setClassName(this.parseStringLiteral(ctx.className.getText()));
        if (ctx.triggerAttributeClause() != null) {
            for (IoTDBSqlParser.TriggerAttributeContext triggerAttributeContext : ctx.triggerAttributeClause().triggerAttribute()) {
                createTriggerOperator.addAttribute(this.parseStringLiteral(triggerAttributeContext.key.getText()), this.parseStringLiteral(triggerAttributeContext.value.getText()));
            }
        }
        return createTriggerOperator;
    }

    public Operator visitCreateContinuousQuery(IoTDBSqlParser.CreateContinuousQueryContext ctx) {
        CreateContinuousQueryOperator createContinuousQueryOperator = new CreateContinuousQueryOperator(106);
        createContinuousQueryOperator.setQuerySql(ctx.getText());
        createContinuousQueryOperator.setContinuousQueryName(this.parseIdentifier(ctx.continuousQueryName.getText()));
        if (ctx.resampleClause() != null) {
            this.parseResampleClause(ctx.resampleClause(), createContinuousQueryOperator);
        }
        this.parseCqSelectIntoClause(ctx.cqSelectIntoClause(), createContinuousQueryOperator);
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        sb.append(ctx.cqSelectIntoClause().selectClause().getText().substring(6));
        sb.append(" from ");
        sb.append(ctx.cqSelectIntoClause().fromClause().prefixPath(0).getText());
        sb.append(" group by ([now() - ");
        String groupByInterval = ctx.cqSelectIntoClause().cqGroupByTimeClause().DURATION_LITERAL().getText();
        if (createContinuousQueryOperator.getForInterval() == 0L) {
            sb.append(groupByInterval);
        } else {
            List durations = ctx.resampleClause().DURATION_LITERAL();
            sb.append(((TerminalNode)durations.get(durations.size() - 1)).getText());
        }
        sb.append(", now()), ");
        sb.append(groupByInterval);
        sb.append(")");
        if (this.queryOp.isGroupByLevel()) {
            sb.append(", level = ");
            int[] levels = this.queryOp.getSpecialClauseComponent().getLevels();
            sb.append(levels[0]);
            for (int i = 1; i < levels.length; ++i) {
                sb.append(String.format(", %d", levels[i]));
            }
        }
        createContinuousQueryOperator.setQuerySql(sb.toString());
        if (createContinuousQueryOperator.getEveryInterval() == 0L) {
            createContinuousQueryOperator.setEveryInterval(((GroupByClauseComponent)this.queryOp.getSpecialClauseComponent()).getUnit());
        }
        if (createContinuousQueryOperator.getEveryInterval() < IoTDBDescriptor.getInstance().getConfig().getContinuousQueryMinimumEveryInterval()) {
            throw new SQLParserException("CQ: every interval should not be lower than the minimum value you configured.");
        }
        if (createContinuousQueryOperator.getForInterval() == 0L) {
            createContinuousQueryOperator.setForInterval(((GroupByClauseComponent)this.queryOp.getSpecialClauseComponent()).getUnit());
        }
        return createContinuousQueryOperator;
    }

    public void parseCqSelectIntoClause(IoTDBSqlParser.CqSelectIntoClauseContext ctx, CreateContinuousQueryOperator createContinuousQueryOperator) {
        this.queryOp = new GroupByQueryOperator();
        this.parseSelectClause(ctx.selectClause());
        this.parseFromClause(ctx.fromClause());
        if (this.queryOp.getSelectComponent().getResultColumns().size() > 1) {
            throw new SQLParserException("CQ: CQ currently does not support multiple result columns.");
        }
        if (this.queryOp.getFromComponent().getPrefixPaths().size() > 1) {
            throw new SQLParserException("CQ: CQ currently does not support multiple series.");
        }
        this.parseCqGroupByTimeClause(ctx.cqGroupByTimeClause(), createContinuousQueryOperator);
        if (this.queryOp.isGroupByLevel()) {
            int[] groupByQueryLevels = this.queryOp.getSpecialClauseComponent().getLevels();
            int fromPrefixLevelLimit = this.queryOp.getFromComponent().getPrefixPaths().get(0).getNodeLength();
            if (Arrays.stream(groupByQueryLevels).max().getAsInt() >= fromPrefixLevelLimit) {
                throw new SQLParserException("CQ: Level should not exceed the <from_prefix> length.");
            }
        }
        createContinuousQueryOperator.setTargetPath(this.parseIntoPath(ctx.intoPath()));
        createContinuousQueryOperator.setQueryOperator(this.queryOp);
    }

    public void parseCqGroupByTimeClause(IoTDBSqlParser.CqGroupByTimeClauseContext ctx, CreateContinuousQueryOperator createContinuousQueryOperator) {
        GroupByClauseComponent groupByClauseComponent = new GroupByClauseComponent();
        long groupByInterval = this.parseTimeUnitOrSlidingStep(ctx.DURATION_LITERAL().getText(), true, groupByClauseComponent);
        groupByClauseComponent.setUnit(groupByInterval);
        createContinuousQueryOperator.setGroupByTimeInterval(groupByInterval);
        createContinuousQueryOperator.setGroupByTimeIntervalString(ctx.DURATION_LITERAL().getText());
        groupByClauseComponent.setSlidingStep(groupByClauseComponent.getUnit());
        groupByClauseComponent.setSlidingStepByMonth(groupByClauseComponent.isIntervalByMonth());
        groupByClauseComponent.setLeftCRightO(true);
        if (ctx.LEVEL() != null && ctx.INTEGER_LITERAL() != null) {
            int[] levels = new int[ctx.INTEGER_LITERAL().size()];
            for (int i = 0; i < ctx.INTEGER_LITERAL().size(); ++i) {
                levels[i] = Integer.parseInt(((TerminalNode)ctx.INTEGER_LITERAL().get(i)).getText());
            }
            groupByClauseComponent.setLevels(levels);
        }
        this.queryOp.setSpecialClauseComponent(groupByClauseComponent);
    }

    public void parseResampleClause(IoTDBSqlParser.ResampleClauseContext ctx, CreateContinuousQueryOperator operator) {
        if (ctx.DURATION_LITERAL().size() == 1) {
            if (ctx.EVERY() != null) {
                operator.setEveryInterval(DateTimeUtils.convertDurationStrToLong(ctx.DURATION_LITERAL(0).getText()));
            } else if (ctx.FOR() != null) {
                operator.setForInterval(DateTimeUtils.convertDurationStrToLong(ctx.DURATION_LITERAL(0).getText()));
            }
        } else if (ctx.DURATION_LITERAL().size() == 2) {
            operator.setEveryInterval(DateTimeUtils.convertDurationStrToLong(ctx.DURATION_LITERAL(0).getText()));
            operator.setForInterval(DateTimeUtils.convertDurationStrToLong(ctx.DURATION_LITERAL(1).getText()));
        }
        if (ctx.BOUNDARY() != null) {
            operator.setFirstExecutionTimeBoundary(this.parseDateExpression(ctx.dateExpression()));
        }
    }

    public Operator visitCreateSnapshot(IoTDBSqlParser.CreateSnapshotContext ctx) {
        return new CreateSnapshotOperator(89);
    }

    public Operator visitAlterTimeseries(IoTDBSqlParser.AlterTimeseriesContext ctx) {
        AlterTimeSeriesOperator alterTimeSeriesOperator = new AlterTimeSeriesOperator(80);
        alterTimeSeriesOperator.setPath(this.parseFullPath(ctx.fullPath()));
        this.parseAlterClause(ctx.alterClause(), alterTimeSeriesOperator);
        return alterTimeSeriesOperator;
    }

    private void parseAlterClause(IoTDBSqlParser.AlterClauseContext ctx, AlterTimeSeriesOperator alterTimeSeriesOperator) {
        HashMap<String, String> alterMap = new HashMap<String, String>();
        if (ctx.RENAME() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.RENAME);
            alterMap.put(this.parseIdentifier(ctx.beforeName.getText()), this.parseIdentifier(ctx.currentName.getText()));
        } else if (ctx.SET() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.SET);
            this.setMap(ctx, alterMap);
        } else if (ctx.DROP() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.DROP);
            for (IoTDBSqlParser.IdentifierContext dropId : ctx.identifier()) {
                alterMap.put(this.parseIdentifier(dropId.getText()), null);
            }
        } else if (ctx.TAGS() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.ADD_TAGS);
            this.setMap(ctx, alterMap);
        } else if (ctx.ATTRIBUTES() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.ADD_ATTRIBUTES);
            this.setMap(ctx, alterMap);
        } else {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.UPSERT);
            if (ctx.aliasClause() != null) {
                this.parseAliasClause(ctx.aliasClause(), alterTimeSeriesOperator);
            }
            if (ctx.tagClause() != null) {
                this.parseTagClause(ctx.tagClause(), alterTimeSeriesOperator);
            }
            if (ctx.attributeClause() != null) {
                this.parseAttributeClause(ctx.attributeClause(), alterTimeSeriesOperator);
            }
        }
        alterTimeSeriesOperator.setAlterMap(alterMap);
    }

    public void parseAliasClause(IoTDBSqlParser.AliasClauseContext ctx, AlterTimeSeriesOperator alterTimeSeriesOperator) {
        if (alterTimeSeriesOperator != null && ctx.identifier() != null) {
            alterTimeSeriesOperator.setAlias(this.parseIdentifier(ctx.identifier().getText()));
        }
    }

    public Operator visitDeleteStorageGroup(IoTDBSqlParser.DeleteStorageGroupContext ctx) {
        ArrayList<PartialPath> deletePaths = new ArrayList<PartialPath>();
        List prefixPaths = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPaths) {
            deletePaths.add(this.parsePrefixPath(prefixPath));
        }
        DeleteStorageGroupOperator deleteStorageGroupOperator = new DeleteStorageGroupOperator(62);
        deleteStorageGroupOperator.setDeletePathList(deletePaths);
        return deleteStorageGroupOperator;
    }

    public Operator visitDeleteTimeseries(IoTDBSqlParser.DeleteTimeseriesContext ctx) {
        ArrayList<PartialPath> deletePaths = new ArrayList<PartialPath>();
        List prefixPaths = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPaths) {
            deletePaths.add(this.parsePrefixPath(prefixPath));
        }
        DeleteTimeSeriesOperator deleteTimeSeriesOperator = new DeleteTimeSeriesOperator(52);
        deleteTimeSeriesOperator.setDeletePathList(deletePaths);
        return deleteTimeSeriesOperator;
    }

    public Operator visitDeletePartition(IoTDBSqlParser.DeletePartitionContext ctx) {
        DeletePartitionOperator deletePartitionOperator = new DeletePartitionOperator(88);
        deletePartitionOperator.setStorageGroupName(this.parsePrefixPath(ctx.prefixPath()));
        HashSet<Long> idSet = new HashSet<Long>();
        for (TerminalNode terminalNode : ctx.INTEGER_LITERAL()) {
            idSet.add(Long.parseLong(terminalNode.getText()));
        }
        deletePartitionOperator.setPartitionIds(idSet);
        return deletePartitionOperator;
    }

    public Operator visitDropFunction(IoTDBSqlParser.DropFunctionContext ctx) {
        DropFunctionOperator dropFunctionOperator = new DropFunctionOperator(93);
        dropFunctionOperator.setUdfName(this.parseIdentifier(ctx.udfName.getText()));
        return dropFunctionOperator;
    }

    public Operator visitDropTrigger(IoTDBSqlParser.DropTriggerContext ctx) {
        DropTriggerOperator dropTriggerOperator = new DropTriggerOperator(101);
        dropTriggerOperator.setTriggerName(this.parseIdentifier(ctx.triggerName.getText()));
        return dropTriggerOperator;
    }

    public Operator visitDropContinuousQuery(IoTDBSqlParser.DropContinuousQueryContext ctx) {
        DropContinuousQueryOperator dropContinuousQueryOperator = new DropContinuousQueryOperator(107);
        dropContinuousQueryOperator.setContinuousQueryName(this.parseIdentifier(ctx.continuousQueryName.getText()));
        return dropContinuousQueryOperator;
    }

    public Operator visitDropSchemaTemplate(IoTDBSqlParser.DropSchemaTemplateContext ctx) {
        DropTemplateOperator dropTemplateOperator = new DropTemplateOperator(118);
        dropTemplateOperator.setTemplateName(this.parseIdentifier(ctx.templateName.getText()));
        return dropTemplateOperator;
    }

    public Operator visitSetTTL(IoTDBSqlParser.SetTTLContext ctx) {
        SetTTLOperator operator = new SetTTLOperator(63);
        operator.setStorageGroup(this.parsePrefixPath(ctx.prefixPath()));
        operator.setDataTTL(Long.parseLong(ctx.INTEGER_LITERAL().getText()));
        return operator;
    }

    public Operator visitUnsetTTL(IoTDBSqlParser.UnsetTTLContext ctx) {
        UnSetTTLOperator operator = new UnSetTTLOperator(64);
        operator.setStorageGroup(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitSetSchemaTemplate(IoTDBSqlParser.SetSchemaTemplateContext ctx) {
        SetTemplateOperator operator = new SetTemplateOperator(113);
        operator.setPrefixPath(this.parsePrefixPath(ctx.prefixPath()));
        operator.setTemplateName(this.parseIdentifier(ctx.templateName.getText()));
        return operator;
    }

    public Operator visitUnsetSchemaTemplate(IoTDBSqlParser.UnsetSchemaTemplateContext ctx) {
        UnsetTemplateOperator operator = new UnsetTemplateOperator(115);
        operator.setPrefixPath(this.parsePrefixPath(ctx.prefixPath()));
        operator.setTemplateName(this.parseIdentifier(ctx.templateName.getText()));
        return operator;
    }

    public Operator visitSetArchiving(IoTDBSqlParser.SetArchivingContext ctx) {
        SetArchivingOperator operator = new SetArchivingOperator(63);
        if (ctx.storageGroup != null) {
            operator.setStorageGroup(this.parsePrefixPath(ctx.storageGroup));
        }
        if (ctx.ttl != null) {
            operator.setTTL(Long.parseLong(ctx.ttl.getText()));
        }
        if (ctx.startTime != null) {
            operator.setStartTime(this.parseDateFormat(ctx.startTime.getText()));
        }
        if (ctx.targetDir != null) {
            FSFactory fsFactory = FSFactoryProducer.getFSFactory();
            File targetDir = fsFactory.getFile(this.parseStringLiteral(ctx.targetDir.getText()));
            if (!targetDir.exists()) {
                throw new SQLParserException("unknown directory");
            }
            if (!targetDir.isDirectory()) {
                throw new SQLParserException("not a directory");
            }
            operator.setTargetDir(targetDir);
        }
        for (IoTDBSqlParser.SetArchivingClauseContext setArchivingClauseContext : ctx.setArchivingClause()) {
            this.parseSetArchivingClause(operator, setArchivingClauseContext);
        }
        return operator;
    }

    private void parseSetArchivingClause(SetArchivingOperator operator, IoTDBSqlParser.SetArchivingClauseContext ctx) {
        if (ctx.storageGroup != null) {
            operator.setStorageGroup(this.parsePrefixPath(ctx.storageGroup));
        }
        if (ctx.ttl != null) {
            operator.setTTL(Long.parseLong(ctx.ttl.getText()));
        }
        if (ctx.startTime != null) {
            operator.setStartTime(this.parseDateFormat(ctx.startTime.getText()));
        }
        if (ctx.targetDir != null) {
            FSFactory fsFactory = FSFactoryProducer.getFSFactory();
            File targetDir = fsFactory.getFile(this.parseStringLiteral(ctx.targetDir.getText()));
            if (!targetDir.exists()) {
                throw new SQLParserException("unknown directory");
            }
            if (!targetDir.isDirectory()) {
                throw new SQLParserException("not a directory");
            }
            operator.setTargetDir(targetDir);
        }
    }

    public Operator visitCancelArchiving(IoTDBSqlParser.CancelArchivingContext ctx) {
        CancelArchivingOperator operator = new CancelArchivingOperator(64);
        if (ctx.storageGroup != null) {
            operator.setStorageGroup(this.parsePrefixPath(ctx.storageGroup));
        } else if (ctx.taskId != null) {
            operator.setTaskId(Long.parseLong(ctx.taskId.getText()));
        } else {
            throw new SQLParserException("cancel archiving unknown case");
        }
        return operator;
    }

    public Operator visitPauseArchiving(IoTDBSqlParser.PauseArchivingContext ctx) {
        PauseArchivingOperator operator = new PauseArchivingOperator(63);
        if (ctx.storageGroup != null) {
            operator.setStorageGroup(this.parsePrefixPath(ctx.storageGroup));
        } else if (ctx.taskId != null) {
            operator.setTaskId(Long.parseLong(ctx.taskId.getText()));
        } else {
            throw new SQLParserException("pause archiving unknown case");
        }
        return operator;
    }

    public Operator visitResumeArchiving(IoTDBSqlParser.ResumeArchivingContext ctx) {
        ResumeArchivingOperator operator = new ResumeArchivingOperator(64);
        if (ctx.storageGroup != null) {
            operator.setStorageGroup(this.parsePrefixPath(ctx.storageGroup));
        } else if (ctx.taskId != null) {
            operator.setTaskId(Long.parseLong(ctx.taskId.getText()));
        } else {
            throw new SQLParserException("resume archiving unknown case");
        }
        return operator;
    }

    public Operator visitShowArchiving(IoTDBSqlParser.ShowArchivingContext ctx) {
        ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
        if (ctx.ON() != null) {
            List prefixPathList = ctx.prefixPath();
            for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPathList) {
                storageGroups.add(this.parsePrefixPath(prefixPath));
            }
        }
        return new ShowArchivingOperator(storageGroups, ctx.ALL() != null);
    }

    public Operator visitStartTrigger(IoTDBSqlParser.StartTriggerContext ctx) {
        StartTriggerOperator startTriggerOperator = new StartTriggerOperator(102);
        startTriggerOperator.setTriggerName(this.parseIdentifier(ctx.triggerName.getText()));
        return startTriggerOperator;
    }

    public Operator visitStopTrigger(IoTDBSqlParser.StopTriggerContext ctx) {
        StopTriggerOperator stopTriggerOperator = new StopTriggerOperator(103);
        stopTriggerOperator.setTriggerName(this.parseIdentifier(ctx.triggerName.getText()));
        return stopTriggerOperator;
    }

    public Operator visitShowStorageGroup(IoTDBSqlParser.ShowStorageGroupContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowStorageGroupOperator(74, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowStorageGroupOperator(74, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowDevices(IoTDBSqlParser.ShowDevicesContext ctx) {
        ShowDevicesOperator showDevicesOperator = ctx.prefixPath() != null ? new ShowDevicesOperator(76, this.parsePrefixPath(ctx.prefixPath())) : new ShowDevicesOperator(76, new PartialPath(SQLConstant.getSingleRootArray()));
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), showDevicesOperator);
        }
        if (ctx.WITH() != null) {
            showDevicesOperator.setSgCol(true);
        }
        return showDevicesOperator;
    }

    public Operator visitShowTimeseries(IoTDBSqlParser.ShowTimeseriesContext ctx) {
        boolean orderByHeat = ctx.LATEST() != null;
        ShowTimeSeriesOperator showTimeSeriesOperator = ctx.prefixPath() != null ? new ShowTimeSeriesOperator(73, this.parsePrefixPath(ctx.prefixPath()), orderByHeat) : new ShowTimeSeriesOperator(73, new PartialPath(SQLConstant.getSingleRootArray()), orderByHeat);
        if (ctx.showWhereClause() != null) {
            this.parseShowWhereClause(ctx.showWhereClause(), showTimeSeriesOperator);
        }
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), showTimeSeriesOperator);
        }
        return showTimeSeriesOperator;
    }

    private void parseShowWhereClause(IoTDBSqlParser.ShowWhereClauseContext ctx, ShowTimeSeriesOperator operator) {
        IoTDBSqlParser.PropertyValueContext propertyValueContext;
        if (ctx.containsExpression() != null) {
            operator.setContains(true);
            propertyValueContext = ctx.containsExpression().propertyValue();
            operator.setKey(this.parseIdentifier(ctx.containsExpression().identifier().getText()));
        } else {
            operator.setContains(false);
            propertyValueContext = ctx.propertyClause().propertyValue();
            operator.setKey(this.parseIdentifier(ctx.propertyClause().identifier().getText()));
        }
        operator.setValue(this.parseStringLiteral(propertyValueContext.getText()));
    }

    public Operator visitShowChildPaths(IoTDBSqlParser.ShowChildPathsContext ctx) {
        PartialPath path = ctx.prefixPath() != null ? this.parsePrefixPath(ctx.prefixPath()) : new PartialPath(SQLConstant.getSingleRootArray());
        ShowChildPathsOperator operator = new ShowChildPathsOperator(75, path);
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), operator);
        }
        return operator;
    }

    public Operator visitShowChildNodes(IoTDBSqlParser.ShowChildNodesContext ctx) {
        PartialPath path = ctx.prefixPath() != null ? this.parsePrefixPath(ctx.prefixPath()) : new PartialPath(SQLConstant.getSingleRootArray());
        ShowChildNodesOperator operator = new ShowChildNodesOperator(99, path);
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), operator);
        }
        return operator;
    }

    public Operator visitShowFunctions(IoTDBSqlParser.ShowFunctionsContext ctx) {
        return new ShowFunctionsOperator(94);
    }

    public Operator visitShowTriggers(IoTDBSqlParser.ShowTriggersContext ctx) {
        return new ShowTriggersOperator(104);
    }

    public Operator visitShowContinuousQueries(IoTDBSqlParser.ShowContinuousQueriesContext ctx) {
        return new ShowContinuousQueriesOperator(108);
    }

    public Operator visitShowTTL(IoTDBSqlParser.ShowTTLContext ctx) {
        ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
        List prefixPathList = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPathList) {
            storageGroups.add(this.parsePrefixPath(prefixPath));
        }
        return new ShowTTLOperator(storageGroups);
    }

    public Operator visitShowAllTTL(IoTDBSqlParser.ShowAllTTLContext ctx) {
        ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
        return new ShowTTLOperator(storageGroups);
    }

    public Operator visitShowSchemaTemplates(IoTDBSqlParser.ShowSchemaTemplatesContext ctx) {
        return new ShowTemplatesOperator(119);
    }

    public Operator visitShowNodesInSchemaTemplate(IoTDBSqlParser.ShowNodesInSchemaTemplateContext ctx) {
        String templateName = this.parseIdentifier(ctx.templateName.getText());
        return new ShowNodesInTemplateOperator(120, templateName);
    }

    public Operator visitShowPathsSetSchemaTemplate(IoTDBSqlParser.ShowPathsSetSchemaTemplateContext ctx) {
        String templateName = this.parseIdentifier(ctx.templateName.getText());
        return new ShowPathsSetTemplateOperator(121, templateName);
    }

    public Operator visitShowPathsUsingSchemaTemplate(IoTDBSqlParser.ShowPathsUsingSchemaTemplateContext ctx) {
        String templateName = this.parseIdentifier(ctx.templateName.getText());
        return new ShowPathsUsingTemplateOperator(122, templateName);
    }

    public Operator visitCountStorageGroup(IoTDBSqlParser.CountStorageGroupContext ctx) {
        IoTDBSqlParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        return new CountOperator(96, path);
    }

    public Operator visitCountDevices(IoTDBSqlParser.CountDevicesContext ctx) {
        IoTDBSqlParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        return new CountOperator(95, path);
    }

    public Operator visitCountTimeseries(IoTDBSqlParser.CountTimeseriesContext ctx) {
        PartialPath path;
        IoTDBSqlParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath partialPath = path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        if (ctx.INTEGER_LITERAL() != null) {
            return new CountOperator(78, path, Integer.parseInt(ctx.INTEGER_LITERAL().getText()));
        }
        return new CountOperator(77, path);
    }

    public Operator visitCountNodes(IoTDBSqlParser.CountNodesContext ctx) {
        return new CountOperator(79, this.parsePrefixPath(ctx.prefixPath()), Integer.parseInt(ctx.INTEGER_LITERAL().getText()));
    }

    public Operator visitSelectStatement(IoTDBSqlParser.SelectStatementContext ctx) {
        WhereComponent whereComponent;
        if (ctx.specialClause() != null) {
            this.queryOp = (QueryOperator)this.visit((ParseTree)ctx.specialClause());
        }
        if (this.queryOp == null) {
            this.queryOp = new QueryOperator();
        }
        this.parseSelectClause(ctx.selectClause());
        this.parseFromClause(ctx.fromClause());
        if (ctx.whereClause() != null && (whereComponent = this.parseWhereClause(ctx.whereClause())) != null) {
            this.queryOp.setWhereComponent(whereComponent);
        }
        this.queryOp.setEnableTracing(ctx.TRACING() != null);
        return ctx.intoClause() == null ? this.queryOp : this.parseAndConstructSelectIntoOperator(ctx);
    }

    private SelectIntoOperator parseAndConstructSelectIntoOperator(IoTDBSqlParser.SelectStatementContext ctx) {
        if (this.queryOp.getFromComponent().getPrefixPaths().size() != 1) {
            throw new SQLParserException("select into: the number of prefix paths in the from clause should be 1.");
        }
        int sourcePathsCount = this.queryOp.getSelectComponent().getResultColumns().size();
        if (sourcePathsCount != ctx.intoClause().intoPath().size()) {
            throw new SQLParserException("select into: the number of source paths and the number of target paths should be the same.");
        }
        SelectIntoOperator selectIntoOperator = new SelectIntoOperator();
        selectIntoOperator.setQueryOperator(this.queryOp);
        ArrayList<PartialPath> intoPaths = new ArrayList<PartialPath>();
        for (int i = 0; i < sourcePathsCount; ++i) {
            intoPaths.add(this.parseIntoPath(ctx.intoClause().intoPath(i)));
        }
        selectIntoOperator.setIntoPaths(intoPaths);
        selectIntoOperator.setIntoPathsAligned(ctx.intoClause().ALIGNED() != null);
        return selectIntoOperator;
    }

    private PartialPath parseIntoPath(IoTDBSqlParser.IntoPathContext intoPathContext) {
        int levelLimitOfSourcePrefixPath = this.queryOp.isGroupByLevel() ? Arrays.stream(this.queryOp.getSpecialClauseComponent().getLevels()).max().getAsInt() : this.queryOp.getFromComponent().getPrefixPaths().get(0).getNodeLength() - 1;
        PartialPath intoPath = null;
        if (intoPathContext.fullPath() != null) {
            intoPath = this.parseFullPath(intoPathContext.fullPath());
            Matcher m = leveledPathNodePattern.matcher(intoPath.getFullPath());
            while (m.find()) {
                int nodeIndex;
                String param = m.group();
                try {
                    nodeIndex = Integer.parseInt(param.substring(2, param.length() - 1).trim());
                }
                catch (NumberFormatException e) {
                    throw new SQLParserException("the x of ${x} should be an integer.");
                }
                if (nodeIndex >= 1 && levelLimitOfSourcePrefixPath >= nodeIndex) continue;
                throw new SQLParserException("the x of ${x} should be greater than 0 and equal to or less than <level> or the length of queried path prefix.");
            }
        } else if (intoPathContext.nodeNameWithoutWildcard() != null) {
            int i;
            List nodeNameWithoutStars = intoPathContext.nodeNameWithoutWildcard();
            String[] intoPathNodes = new String[1 + levelLimitOfSourcePrefixPath + nodeNameWithoutStars.size()];
            intoPathNodes[0] = "root";
            for (i = 1; i <= levelLimitOfSourcePrefixPath; ++i) {
                intoPathNodes[i] = "${" + i + "}";
            }
            for (i = 1; i <= nodeNameWithoutStars.size(); ++i) {
                intoPathNodes[levelLimitOfSourcePrefixPath + i] = this.parseNodeName(((IoTDBSqlParser.NodeNameWithoutWildcardContext)nodeNameWithoutStars.get(i - 1)).getText());
            }
            intoPath = new PartialPath(intoPathNodes);
        }
        return intoPath;
    }

    public Operator visitSpecialLimitStatement(IoTDBSqlParser.SpecialLimitStatementContext ctx) {
        return (Operator)this.visit((ParseTree)ctx.specialLimit());
    }

    public Operator visitOrderByTimeStatement(IoTDBSqlParser.OrderByTimeStatementContext ctx) {
        this.queryOp = new QueryOperator();
        this.parseOrderByTimeClause(ctx.orderByTimeClause());
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitGroupByTimeStatement(IoTDBSqlParser.GroupByTimeStatementContext ctx) {
        this.queryOp = new GroupByQueryOperator();
        this.parseGroupByTimeClause(ctx.groupByTimeClause());
        if (ctx.orderByTimeClause() != null) {
            this.parseOrderByTimeClause(ctx.orderByTimeClause());
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitGroupByFillStatement(IoTDBSqlParser.GroupByFillStatementContext ctx) {
        this.queryOp = new GroupByFillQueryOperator();
        this.parseGroupByFillClause(ctx.groupByFillClause());
        if (ctx.orderByTimeClause() != null) {
            this.parseOrderByTimeClause(ctx.orderByTimeClause());
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitGroupByLevelStatement(IoTDBSqlParser.GroupByLevelStatementContext ctx) {
        this.queryOp = new AggregationQueryOperator();
        this.parseGroupByLevelClause(ctx.groupByLevelClause());
        if (ctx.orderByTimeClause() != null) {
            this.parseOrderByTimeClause(ctx.orderByTimeClause());
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitFillStatement(IoTDBSqlParser.FillStatementContext ctx) {
        this.queryOp = new FillQueryOperator();
        this.parseFillClause(ctx.fillClause());
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause());
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitLimitStatement(IoTDBSqlParser.LimitStatementContext ctx) {
        if (this.queryOp == null) {
            this.queryOp = new QueryOperator();
        }
        this.parseLimitClause(ctx.limitClause(), this.queryOp);
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause());
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitSlimitStatement(IoTDBSqlParser.SlimitStatementContext ctx) {
        if (this.queryOp == null) {
            this.queryOp = new QueryOperator();
        }
        this.parseSlimitClause(ctx.slimitClause());
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), this.queryOp);
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitWithoutNullStatement(IoTDBSqlParser.WithoutNullStatementContext ctx) {
        if (this.queryOp == null) {
            this.queryOp = new QueryOperator();
        }
        this.parseWithoutNullClause(ctx.withoutNullClause());
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), this.queryOp);
        }
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause());
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitAlignByDeviceClauseOrDisableAlignStatement(IoTDBSqlParser.AlignByDeviceClauseOrDisableAlignStatementContext ctx) {
        if (this.queryOp == null) {
            this.queryOp = new QueryOperator();
        }
        this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        return this.queryOp;
    }

    private void parseAlignByDeviceClauseOrDisableAlign(IoTDBSqlParser.AlignByDeviceClauseOrDisableAlignContext ctx) {
        SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
        if (specialClauseComponent == null) {
            specialClauseComponent = new SpecialClauseComponent();
        }
        if (ctx.alignByDeviceClause() != null) {
            this.parseAlignByDeviceClause(specialClauseComponent);
        } else {
            this.parseDisableAlign(specialClauseComponent);
        }
        this.queryOp.setSpecialClauseComponent(specialClauseComponent);
    }

    private void parseAlignByDeviceClause(SpecialClauseComponent specialClauseComponent) {
        specialClauseComponent.setAlignByDevice(true);
    }

    private void parseDisableAlign(SpecialClauseComponent specialClauseComponent) {
        specialClauseComponent.setAlignByTime(false);
    }

    private void parseOrderByTimeClause(IoTDBSqlParser.OrderByTimeClauseContext ctx) {
        if (ctx.DESC() != null) {
            SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
            if (specialClauseComponent == null) {
                specialClauseComponent = new SpecialClauseComponent();
            }
            specialClauseComponent.setAscending(false);
            this.queryOp.setSpecialClauseComponent(specialClauseComponent);
        }
    }

    private void parseGroupByTimeClause(IoTDBSqlParser.GroupByTimeClauseContext ctx) {
        GroupByClauseComponent groupByClauseComponent = new GroupByClauseComponent();
        groupByClauseComponent.setLeftCRightO(ctx.timeInterval().LS_BRACKET() != null);
        groupByClauseComponent.setUnit(this.parseTimeUnitOrSlidingStep(ctx.DURATION_LITERAL(0).getText(), true, groupByClauseComponent));
        if (groupByClauseComponent.getUnit() <= 0L) {
            throw new SQLParserException("The second parameter time interval should be a positive integer.");
        }
        if (ctx.DURATION_LITERAL().size() == 2) {
            groupByClauseComponent.setSlidingStep(this.parseTimeUnitOrSlidingStep(ctx.DURATION_LITERAL(1).getText(), false, groupByClauseComponent));
            if (groupByClauseComponent.getSlidingStep() < groupByClauseComponent.getUnit()) {
                throw new SQLParserException("The third parameter sliding step shouldn't be smaller than the second parameter time interval.");
            }
        } else {
            groupByClauseComponent.setSlidingStep(groupByClauseComponent.getUnit());
            groupByClauseComponent.setSlidingStepByMonth(groupByClauseComponent.isIntervalByMonth());
        }
        this.parseTimeInterval(ctx.timeInterval(), groupByClauseComponent);
        if (ctx.LEVEL() != null && ctx.INTEGER_LITERAL() != null) {
            int[] levels = new int[ctx.INTEGER_LITERAL().size()];
            for (int i = 0; i < ctx.INTEGER_LITERAL().size(); ++i) {
                levels[i] = Integer.parseInt(((TerminalNode)ctx.INTEGER_LITERAL().get(i)).getText());
            }
            groupByClauseComponent.setLevels(levels);
        }
        this.queryOp.setSpecialClauseComponent(groupByClauseComponent);
    }

    private void parseGroupByFillClause(IoTDBSqlParser.GroupByFillClauseContext ctx) {
        GroupByFillClauseComponent groupByFillClauseComponent = new GroupByFillClauseComponent();
        groupByFillClauseComponent.setLeftCRightO(ctx.timeInterval().LS_BRACKET() != null);
        groupByFillClauseComponent.setUnit(this.parseTimeUnitOrSlidingStep(ctx.DURATION_LITERAL(0).getText(), true, groupByFillClauseComponent));
        if (ctx.DURATION_LITERAL().size() == 2) {
            groupByFillClauseComponent.setSlidingStep(this.parseTimeUnitOrSlidingStep(ctx.DURATION_LITERAL(1).getText(), false, groupByFillClauseComponent));
            if (groupByFillClauseComponent.getSlidingStep() < groupByFillClauseComponent.getUnit()) {
                throw new SQLParserException("The third parameter sliding step shouldn't be smaller than the second parameter time interval.");
            }
        } else {
            groupByFillClauseComponent.setSlidingStep(groupByFillClauseComponent.getUnit());
            groupByFillClauseComponent.setSlidingStepByMonth(groupByFillClauseComponent.isIntervalByMonth());
        }
        this.parseTimeInterval(ctx.timeInterval(), groupByFillClauseComponent);
        if (ctx.fillClause().oldTypeClause().size() > 0) {
            List list = ctx.fillClause().oldTypeClause();
            EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
            for (IoTDBSqlParser.OldTypeClauseContext typeClause : list) {
                if (typeClause.ALL() != null) {
                    this.parseAllTypeClause(typeClause, fillTypes);
                    continue;
                }
                this.parsePrimitiveTypeClause(typeClause, fillTypes);
            }
            int usePrevious = 0;
            int useLinear = 0;
            int useValue = 0;
            for (IFill iFill : fillTypes.values()) {
                if (iFill instanceof PreviousFill) {
                    usePrevious = 1;
                }
                if (iFill instanceof LinearFill) {
                    useLinear = 1;
                }
                if (!(iFill instanceof ValueFill)) continue;
                useValue = 1;
            }
            if (usePrevious + useLinear + useValue > 1) {
                throw new SQLParserException("The old type logic could only use one type of fill");
            }
            groupByFillClauseComponent.setFillTypes(fillTypes);
        } else {
            groupByFillClauseComponent.setSingleFill(this.getSingleIFill(ctx.fillClause()));
        }
        this.queryOp.setSpecialClauseComponent(groupByFillClauseComponent);
    }

    public void parseGroupByLevelClause(IoTDBSqlParser.GroupByLevelClauseContext ctx) {
        SpecialClauseComponent groupByLevelClauseComponent = new SpecialClauseComponent();
        int[] levels = new int[ctx.INTEGER_LITERAL().size()];
        for (int i = 0; i < ctx.INTEGER_LITERAL().size(); ++i) {
            levels[i] = Integer.parseInt(((TerminalNode)ctx.INTEGER_LITERAL().get(i)).getText());
        }
        groupByLevelClauseComponent.setLevels(levels);
        this.queryOp.setSpecialClauseComponent(groupByLevelClauseComponent);
    }

    public void parseFillClause(IoTDBSqlParser.FillClauseContext ctx) {
        FillClauseComponent fillClauseComponent = new FillClauseComponent();
        if (ctx.oldTypeClause().size() > 0) {
            List list = ctx.oldTypeClause();
            EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
            for (IoTDBSqlParser.OldTypeClauseContext typeClause : list) {
                if (typeClause.ALL() != null) {
                    if (typeClause.linearClause() != null) {
                        throw new SQLParserException("fill all doesn't support linear fill");
                    }
                    this.parseAllTypeClause(typeClause, fillTypes);
                    break;
                }
                this.parsePrimitiveTypeClause(typeClause, fillTypes);
            }
            fillClauseComponent.setFillTypes(fillTypes);
        } else {
            fillClauseComponent.setSingleFill(this.getSingleIFill(ctx));
        }
        this.queryOp.setSpecialClauseComponent(fillClauseComponent);
    }

    private void parseTimeInterval(IoTDBSqlParser.TimeIntervalContext timeInterval, GroupByClauseComponent groupByClauseComponent) {
        long currentTime = DateTimeUtils.currentTime();
        long startTime = this.parseTimeValue(timeInterval.timeValue(0), currentTime);
        long endTime = this.parseTimeValue(timeInterval.timeValue(1), currentTime);
        groupByClauseComponent.setStartTime(startTime);
        groupByClauseComponent.setEndTime(endTime);
        if (startTime >= endTime) {
            throw new SQLParserException("Start time should be smaller than endTime in GroupBy");
        }
    }

    private void parseWithoutNullClause(IoTDBSqlParser.WithoutNullClauseContext ctx) {
        SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
        if (specialClauseComponent == null) {
            specialClauseComponent = new SpecialClauseComponent();
        }
        List expressionContexts = ctx.expression();
        for (IoTDBSqlParser.ExpressionContext expressionContext : expressionContexts) {
            specialClauseComponent.addWithoutNullColumn(this.parseExpression(expressionContext));
        }
        specialClauseComponent.setWithoutAnyNull(ctx.ANY() != null);
        specialClauseComponent.setWithoutAllNull(ctx.ALL() != null);
        this.queryOp.setSpecialClauseComponent(specialClauseComponent);
    }

    private IFill getSingleIFill(IoTDBSqlParser.FillClauseContext ctx) {
        int defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        if (ctx.linearClause() != null) {
            if (ctx.linearClause().DURATION_LITERAL(0) != null) {
                String beforeStr = ctx.linearClause().DURATION_LITERAL(0).getText();
                String afterStr = ctx.linearClause().DURATION_LITERAL(1).getText();
                return new LinearFill(beforeStr, afterStr);
            }
            return new LinearFill(defaultFillInterval, (long)defaultFillInterval);
        }
        if (ctx.previousClause() != null) {
            if (ctx.previousClause().DURATION_LITERAL() != null) {
                String preRangeStr = ctx.previousClause().DURATION_LITERAL().getText();
                return new PreviousFill(preRangeStr);
            }
            return new PreviousFill(defaultFillInterval);
        }
        if (ctx.specificValueClause() != null) {
            if (ctx.specificValueClause().constant() != null) {
                return new ValueFill(ctx.specificValueClause().constant().getText());
            }
            throw new SQLParserException("fill value cannot be null");
        }
        if (ctx.previousUntilLastClause() != null) {
            if (ctx.previousUntilLastClause().DURATION_LITERAL() != null) {
                String preRangeStr = ctx.previousUntilLastClause().DURATION_LITERAL().getText();
                return new PreviousFill(preRangeStr, true);
            }
            return new PreviousFill(defaultFillInterval, true);
        }
        throw new SQLParserException("unknown single fill type");
    }

    private void parseAllTypeClause(IoTDBSqlParser.OldTypeClauseContext ctx, Map<TSDataType, IFill> fillTypes) {
        String preRangeStr;
        IFill fill;
        int defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        if (ctx.linearClause() != null) {
            if (ctx.linearClause().DURATION_LITERAL(0) != null) {
                String beforeStr = ctx.linearClause().DURATION_LITERAL(0).getText();
                String afterStr = ctx.linearClause().DURATION_LITERAL(1).getText();
                fill = new LinearFill(beforeStr, afterStr);
            } else {
                fill = new LinearFill(defaultFillInterval, (long)defaultFillInterval);
            }
        } else if (ctx.previousClause() != null) {
            if (ctx.previousClause().DURATION_LITERAL() != null) {
                preRangeStr = ctx.previousClause().DURATION_LITERAL().getText();
                fill = new PreviousFill(preRangeStr);
            } else {
                fill = new PreviousFill(defaultFillInterval);
            }
        } else {
            if (ctx.specificValueClause() != null) {
                throw new SQLParserException("fill all doesn't support value fill");
            }
            if (ctx.previousUntilLastClause().DURATION_LITERAL() != null) {
                preRangeStr = ctx.previousUntilLastClause().DURATION_LITERAL().getText();
                fill = new PreviousFill(preRangeStr, true);
            } else {
                fill = new PreviousFill(defaultFillInterval, true);
            }
        }
        for (TSDataType tsDataType : TSDataType.values()) {
            if (tsDataType == TSDataType.VECTOR || fill instanceof LinearFill && (tsDataType == TSDataType.BOOLEAN || tsDataType == TSDataType.TEXT)) continue;
            fillTypes.put(tsDataType, fill.copy());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePrimitiveTypeClause(IoTDBSqlParser.OldTypeClauseContext ctx, Map<TSDataType, IFill> fillTypes) {
        TSDataType dataType = this.parseType(ctx.dataType.getText());
        if (dataType == TSDataType.VECTOR) {
            throw new SQLParserException(String.format("type %s cannot use fill function", dataType));
        }
        if (ctx.linearClause() != null && (dataType == TSDataType.TEXT || dataType == TSDataType.BOOLEAN)) {
            throw new SQLParserException(String.format("type %s cannot use %s fill function", dataType, ctx.linearClause().LINEAR().getText()));
        }
        int defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        if (ctx.linearClause() != null) {
            if (ctx.linearClause().DURATION_LITERAL(0) != null) {
                String beforeRangeStr = ctx.linearClause().DURATION_LITERAL(0).getText();
                String afterRangeStr = ctx.linearClause().DURATION_LITERAL(1).getText();
                LinearFill fill = new LinearFill(beforeRangeStr, afterRangeStr);
                fillTypes.put(dataType, fill);
                return;
            } else {
                fillTypes.put(dataType, new LinearFill(defaultFillInterval, (long)defaultFillInterval));
            }
            return;
        } else if (ctx.previousClause() != null) {
            if (ctx.previousClause().DURATION_LITERAL() != null) {
                String beforeStr = ctx.previousClause().DURATION_LITERAL().getText();
                fillTypes.put(dataType, new PreviousFill(beforeStr));
                return;
            } else {
                fillTypes.put(dataType, new PreviousFill(defaultFillInterval));
            }
            return;
        } else if (ctx.specificValueClause() != null) {
            if (ctx.specificValueClause().constant() == null) throw new SQLParserException("fill value cannot be null");
            fillTypes.put(dataType, new ValueFill(ctx.specificValueClause().constant().getText(), dataType));
            return;
        } else if (ctx.previousUntilLastClause().DURATION_LITERAL() != null) {
            String preRangeStr = ctx.previousUntilLastClause().DURATION_LITERAL().getText();
            fillTypes.put(dataType, new PreviousFill(preRangeStr, true));
            return;
        } else {
            fillTypes.put(dataType, new PreviousFill(defaultFillInterval, true));
        }
    }

    private TSDataType parseType(String datatype) {
        String type;
        switch (type = datatype.toLowerCase()) {
            case "int32": {
                return TSDataType.INT32;
            }
            case "int64": {
                return TSDataType.INT64;
            }
            case "float": {
                return TSDataType.FLOAT;
            }
            case "double": {
                return TSDataType.DOUBLE;
            }
            case "boolean": {
                return TSDataType.BOOLEAN;
            }
            case "text": {
                return TSDataType.TEXT;
            }
        }
        throw new SQLParserException("not a valid fill type : " + type);
    }

    public Operator visitInsertStatement(IoTDBSqlParser.InsertStatementContext ctx) {
        InsertOperator insertOp = new InsertOperator(24);
        insertOp.setDevice(this.parsePrefixPath(ctx.prefixPath()));
        boolean isTimeDefault = this.parseInsertColumnSpec(ctx.insertColumnsSpec(), insertOp);
        this.parseInsertValuesSpec(ctx.insertValuesSpec(), insertOp, isTimeDefault);
        insertOp.setAligned(ctx.ALIGNED() != null);
        return insertOp;
    }

    private boolean parseInsertColumnSpec(IoTDBSqlParser.InsertColumnsSpecContext ctx, InsertOperator insertOp) {
        ArrayList<String> measurementList = new ArrayList<String>();
        for (IoTDBSqlParser.NodeNameWithoutWildcardContext measurementName : ctx.nodeNameWithoutWildcard()) {
            measurementList.add(this.parseNodeName(measurementName.getText()));
        }
        insertOp.setMeasurementList(measurementList.toArray(new String[0]));
        return ctx.TIME() == null && ctx.TIMESTAMP() == null;
    }

    private void parseInsertValuesSpec(IoTDBSqlParser.InsertValuesSpecContext ctx, InsertOperator insertOp, boolean isTimeDefault) {
        List insertMultiValues = ctx.insertMultiValue();
        ArrayList<String[]> valueLists = new ArrayList<String[]>();
        long[] timeArray = new long[insertMultiValues.size()];
        for (int i = 0; i < insertMultiValues.size(); ++i) {
            long timestamp;
            ArrayList<String> valueList = new ArrayList<String>();
            if (((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).timeValue() != null) {
                if (isTimeDefault) {
                    if (insertMultiValues.size() != 1) {
                        throw new SQLParserException("need timestamps when insert multi rows");
                    }
                    valueList.add(((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).timeValue().getText());
                    timestamp = DateTimeUtils.currentTime();
                } else {
                    timestamp = this.parseTimeValue(((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).timeValue(), DateTimeUtils.currentTime());
                }
                timestamp = this.parseTimeValue(((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).timeValue(), DateTimeUtils.currentTime());
            } else {
                if (!isTimeDefault) {
                    throw new SQLParserException("the measurementList's size is not consistent with the valueList's size");
                }
                if (insertMultiValues.size() != 1) {
                    throw new SQLParserException("need timestamps when insert multi rows");
                }
                timestamp = this.parseDateFormat("now()");
            }
            timeArray[i] = timestamp;
            List values = ((IoTDBSqlParser.InsertMultiValueContext)insertMultiValues.get(i)).measurementValue();
            for (IoTDBSqlParser.MeasurementValueContext value : values) {
                for (IoTDBSqlParser.ConstantContext constant : value.constant()) {
                    if (constant.STRING_LITERAL() != null) {
                        valueList.add(this.parseStringLiteralInInsertValue(constant.getText()));
                        continue;
                    }
                    valueList.add(constant.getText());
                }
            }
            valueLists.add(valueList.toArray(new String[0]));
        }
        insertOp.setTimes(timeArray);
        insertOp.setValueLists(valueLists);
    }

    public Operator visitDeleteStatement(IoTDBSqlParser.DeleteStatementContext ctx) {
        DeleteDataOperator deleteDataOp = new DeleteDataOperator(25);
        List prefixPaths = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixPath : prefixPaths) {
            deleteDataOp.addPath(this.parsePrefixPath(prefixPath));
        }
        if (ctx.whereClause() != null) {
            WhereComponent whereComponent = this.parseWhereClause(ctx.whereClause());
            Pair<Long, Long> timeInterval = this.parseDeleteTimeInterval(whereComponent.getFilterOperator());
            deleteDataOp.setStartTime((Long)timeInterval.left);
            deleteDataOp.setEndTime((Long)timeInterval.right);
        } else {
            deleteDataOp.setStartTime(Long.MIN_VALUE);
            deleteDataOp.setEndTime(Long.MAX_VALUE);
        }
        return deleteDataOp;
    }

    private Pair<Long, Long> parseDeleteTimeInterval(FilterOperator filterOperator) {
        if (!filterOperator.isLeaf() && filterOperator.getFilterType() != FilterConstant.FilterType.KW_AND) {
            throw new SQLParserException(DELETE_RANGE_ERROR_MSG);
        }
        if (filterOperator.isLeaf()) {
            return this.calcOperatorInterval(filterOperator);
        }
        List<FilterOperator> children = filterOperator.getChildren();
        FilterOperator lOperator = children.get(0);
        FilterOperator rOperator = children.get(1);
        if (!lOperator.isLeaf() || !rOperator.isLeaf()) {
            throw new SQLParserException(DELETE_RANGE_ERROR_MSG);
        }
        Pair<Long, Long> leftOpInterval = this.calcOperatorInterval(lOperator);
        Pair<Long, Long> rightOpInterval = this.calcOperatorInterval(rOperator);
        Pair parsedInterval = new Pair((Object)Math.max((Long)leftOpInterval.left, (Long)rightOpInterval.left), (Object)Math.min((Long)leftOpInterval.right, (Long)rightOpInterval.right));
        if ((Long)parsedInterval.left > (Long)parsedInterval.right) {
            throw new SQLParserException("Invalid delete range: [" + parsedInterval.left + ", " + parsedInterval.right + "]");
        }
        return parsedInterval;
    }

    public Operator visitCreateUser(IoTDBSqlParser.CreateUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_USER);
        authorOperator.setUserName(ctx.userName.getText());
        authorOperator.setPassWord(this.parseStringLiteral(ctx.password.getText()));
        return authorOperator;
    }

    public Operator visitCreateRole(IoTDBSqlParser.CreateRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_ROLE);
        authorOperator.setRoleName(ctx.roleName.getText());
        return authorOperator;
    }

    public Operator visitAlterUser(IoTDBSqlParser.AlterUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(46, AuthorOperator.AuthorType.UPDATE_USER);
        authorOperator.setUserName(ctx.userName.getText());
        authorOperator.setNewPassword(this.parseStringLiteral(ctx.password.getText()));
        return authorOperator;
    }

    public Operator visitGrantUser(IoTDBSqlParser.GrantUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_USER);
        authorOperator.setUserName(ctx.userName.getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitGrantRole(IoTDBSqlParser.GrantRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE);
        authorOperator.setRoleName(ctx.roleName.getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitGrantRoleToUser(IoTDBSqlParser.GrantRoleToUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_USER_ROLE);
        authorOperator.setRoleName(ctx.roleName.getText());
        authorOperator.setUserName(ctx.userName.getText());
        return authorOperator;
    }

    public Operator visitRevokeUser(IoTDBSqlParser.RevokeUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_USER);
        authorOperator.setUserName(ctx.userName.getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitRevokeRole(IoTDBSqlParser.RevokeRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_ROLE);
        authorOperator.setRoleName(ctx.roleName.getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitRevokeRoleFromUser(IoTDBSqlParser.RevokeRoleFromUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_USER_ROLE);
        authorOperator.setRoleName(ctx.roleName.getText());
        authorOperator.setUserName(ctx.userName.getText());
        return authorOperator;
    }

    public Operator visitDropUser(IoTDBSqlParser.DropUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_USER);
        authorOperator.setUserName(ctx.userName.getText());
        return authorOperator;
    }

    public Operator visitDropRole(IoTDBSqlParser.DropRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_ROLE);
        authorOperator.setRoleName(ctx.roleName.getText());
        return authorOperator;
    }

    public Operator visitListUser(IoTDBSqlParser.ListUserContext ctx) {
        return new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER);
    }

    public Operator visitListRole(IoTDBSqlParser.ListRoleContext ctx) {
        return new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE);
    }

    public Operator visitListPrivilegesUser(IoTDBSqlParser.ListPrivilegesUserContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
        operator.setUserName(ctx.userName.getText());
        operator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitListPrivilegesRole(IoTDBSqlParser.ListPrivilegesRoleContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
        operator.setRoleName(ctx.roleName.getText());
        operator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitListUserPrivileges(IoTDBSqlParser.ListUserPrivilegesContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
        operator.setUserName(ctx.userName.getText());
        return operator;
    }

    public Operator visitListRolePrivileges(IoTDBSqlParser.ListRolePrivilegesContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
        operator.setRoleName(ctx.roleName.getText());
        return operator;
    }

    public Operator visitListAllRoleOfUser(IoTDBSqlParser.ListAllRoleOfUserContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_ROLES);
        operator.setUserName(ctx.userName.getText());
        return operator;
    }

    public Operator visitListAllUserOfRole(IoTDBSqlParser.ListAllUserOfRoleContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_USERS);
        operator.setRoleName(ctx.roleName.getText());
        return operator;
    }

    private String[] parsePrivilege(IoTDBSqlParser.PrivilegesContext ctx) {
        List privilegeList = ctx.privilegeValue();
        ArrayList<String> privileges = new ArrayList<String>();
        for (IoTDBSqlParser.PrivilegeValueContext privilegeValue : privilegeList) {
            privileges.add(privilegeValue.getText());
        }
        return privileges.toArray(new String[0]);
    }

    public Operator visitMerge(IoTDBSqlParser.MergeContext ctx) {
        return new MergeOperator(82);
    }

    public Operator visitFullMerge(IoTDBSqlParser.FullMergeContext ctx) {
        return new MergeOperator(83);
    }

    public Operator visitFlush(IoTDBSqlParser.FlushContext ctx) {
        FlushOperator flushOperator = new FlushOperator(81);
        if (ctx.BOOLEAN_LITERAL() != null) {
            flushOperator.setSeq(Boolean.parseBoolean(ctx.BOOLEAN_LITERAL().getText()));
        }
        if (ctx.prefixPath(0) != null) {
            ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
            for (IoTDBSqlParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
                storageGroups.add(this.parsePrefixPath(prefixPathContext));
            }
            flushOperator.setStorageGroupList(storageGroups);
        }
        return flushOperator;
    }

    public Operator visitClearCache(IoTDBSqlParser.ClearCacheContext ctx) {
        return new ClearCacheOperator(84);
    }

    public Operator visitSettle(IoTDBSqlParser.SettleContext ctx) {
        SettleOperator settleOperator = new SettleOperator(111);
        if (ctx.prefixPath() != null) {
            PartialPath sgPath = this.parsePrefixPath(ctx.prefixPath());
            settleOperator.setSgPath(sgPath);
            settleOperator.setIsSgPath(true);
        } else {
            String tsFilePath = this.parseStringLiteral(ctx.tsFilePath.getText());
            settleOperator.setTsFilePath(tsFilePath);
            settleOperator.setIsSgPath(false);
        }
        return settleOperator;
    }

    public Operator visitSetSystemStatus(IoTDBSqlParser.SetSystemStatusContext ctx) {
        if (ctx.READONLY() != null) {
            return new SetSystemModeOperator(110, true);
        }
        return new SetSystemModeOperator(110, false);
    }

    public Operator visitShowVersion(IoTDBSqlParser.ShowVersionContext ctx) {
        return new ShowOperator(72);
    }

    public Operator visitShowFlushInfo(IoTDBSqlParser.ShowFlushInfoContext ctx) {
        return new ShowOperator(67);
    }

    public Operator visitShowLockInfo(IoTDBSqlParser.ShowLockInfoContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowLockInfoOperator(105, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowLockInfoOperator(105, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowQueryResource(IoTDBSqlParser.ShowQueryResourceContext ctx) {
        return new ShowQueryResourceOperate(123);
    }

    public Operator visitShowQueryProcesslist(IoTDBSqlParser.ShowQueryProcesslistContext ctx) {
        return new ShowOperator(97);
    }

    public Operator visitKillQuery(IoTDBSqlParser.KillQueryContext ctx) {
        KillQueryOperator killQueryOperator = new KillQueryOperator(98);
        if (ctx.INTEGER_LITERAL() != null) {
            killQueryOperator.setQueryId(Integer.parseInt(ctx.INTEGER_LITERAL().getText()));
        }
        return killQueryOperator;
    }

    public Operator visitGrantWatermarkEmbedding(IoTDBSqlParser.GrantWatermarkEmbeddingContext ctx) {
        List usernameList = ctx.usernameWithRoot();
        ArrayList<String> users = new ArrayList<String>();
        for (IoTDBSqlParser.UsernameWithRootContext username : usernameList) {
            users.add(username.getText());
        }
        return new DataAuthOperator(34, users);
    }

    public Operator visitRevokeWatermarkEmbedding(IoTDBSqlParser.RevokeWatermarkEmbeddingContext ctx) {
        List usernameList = ctx.usernameWithRoot();
        ArrayList<String> users = new ArrayList<String>();
        for (IoTDBSqlParser.UsernameWithRootContext username : usernameList) {
            users.add(username.getText());
        }
        return new DataAuthOperator(35, users);
    }

    public Operator visitLoadConfiguration(IoTDBSqlParser.LoadConfigurationContext ctx) {
        if (ctx.GLOBAL() != null) {
            return new LoadConfigurationOperator(LoadConfigurationOperator.LoadConfigurationOperatorType.GLOBAL);
        }
        return new LoadConfigurationOperator(LoadConfigurationOperator.LoadConfigurationOperatorType.LOCAL);
    }

    public Operator visitLoadTimeseries(IoTDBSqlParser.LoadTimeseriesContext ctx) {
        if (ctx.prefixPath().nodeName().size() < 3) {
            throw new SQLParserException("data load command: child count < 3\n");
        }
        String csvPath = ctx.fileName.getText();
        StringContainer sc = new StringContainer(".");
        List nodeNames = ctx.prefixPath().nodeName();
        sc.addTail(new String[]{ctx.prefixPath().ROOT().getText()});
        for (IoTDBSqlParser.NodeNameContext nodeName : nodeNames) {
            sc.addTail(new String[]{this.parseNodeName(nodeName)});
        }
        return new LoadDataOperator(45, this.parseFilePath(csvPath), sc.toString());
    }

    public Operator visitLoadFile(IoTDBSqlParser.LoadFileContext ctx) {
        LoadFilesOperator loadFilesOperator = new LoadFilesOperator(new File(this.parseFilePath(ctx.fileName.getText())), true, IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel(), true);
        if (ctx.loadFilesClause() != null) {
            this.parseLoadFiles(loadFilesOperator, ctx.loadFilesClause());
        }
        return loadFilesOperator;
    }

    private void parseLoadFiles(LoadFilesOperator operator, IoTDBSqlParser.LoadFilesClauseContext ctx) {
        if (ctx.AUTOREGISTER() != null) {
            operator.setAutoCreateSchema(Boolean.parseBoolean(ctx.BOOLEAN_LITERAL().getText()));
        } else if (ctx.SGLEVEL() != null) {
            operator.setSgLevel(Integer.parseInt(ctx.INTEGER_LITERAL().getText()));
        } else if (ctx.VERIFY() != null) {
            operator.setVerifyMetadata(Boolean.parseBoolean(ctx.BOOLEAN_LITERAL().getText()));
        } else {
            throw new SQLParserException(String.format("load tsfile format %s error, please input AUTOREGISTER | SGLEVEL | VERIFY.", ctx.getText()));
        }
        if (ctx.loadFilesClause() != null) {
            this.parseLoadFiles(operator, ctx.loadFilesClause());
        }
    }

    public Operator visitRemoveFile(IoTDBSqlParser.RemoveFileContext ctx) {
        return new RemoveFileOperator(new File(this.parseFilePath(ctx.fileName.getText())));
    }

    public Operator visitUnloadFile(IoTDBSqlParser.UnloadFileContext ctx) {
        return new UnloadFileOperator(new File(this.parseFilePath(ctx.srcFileName.getText())), new File(this.parseFilePath(ctx.dstFileDir.getText())));
    }

    public Operator visitExportSchema(IoTDBSqlParser.ExportSchemaContext ctx) {
        return new ExportSchemaOperator(new File(this.parseFilePath(ctx.dstDir.getText())));
    }

    private PartialPath parseFullPath(IoTDBSqlParser.FullPathContext ctx) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutWildcard();
        String[] path = new String[nodeNamesWithoutStar.size() + 1];
        int i = 0;
        if (ctx.ROOT() != null) {
            path[0] = ctx.ROOT().getText();
        }
        for (IoTDBSqlParser.NodeNameWithoutWildcardContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            path[++i] = this.parseNodeName(nodeNameWithoutStar.getText());
        }
        return new PartialPath(path);
    }

    private PartialPath parsePrefixPath(IoTDBSqlParser.PrefixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size() + 1];
        path[0] = ctx.ROOT().getText();
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i + 1] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
        }
        return new PartialPath(path);
    }

    private PartialPath parseSuffixPath(IoTDBSqlParser.SuffixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size()];
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i] = this.parseNodeName((IoTDBSqlParser.NodeNameContext)nodeNames.get(i));
        }
        return new PartialPath(path);
    }

    private PartialPath parseSuffixPathCanInExpr(IoTDBSqlParser.SuffixPathCanInExprContext ctx) {
        List nodeNames = ctx.nodeNameCanInExpr();
        String[] path = new String[nodeNames.size()];
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i] = this.parseNodeName(((IoTDBSqlParser.NodeNameCanInExprContext)nodeNames.get(i)).getText());
        }
        return new PartialPath(path);
    }

    private PartialPath convertConstantToPath(String src) throws IllegalPathException {
        return new PartialPath(src);
    }

    public String parseNodeName(IoTDBSqlParser.NodeNameContext ctx) {
        String src = ctx.getText();
        if (2 <= src.length() && src.charAt(0) == '`' && src.charAt(src.length() - 1) == '`') {
            return src.substring(1, src.length() - 1);
        }
        return src;
    }

    public long parseDateFormat(String timestampStr) throws SQLParserException {
        if (timestampStr == null || "".equals(timestampStr.trim())) {
            throw new SQLParserException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return DateTimeUtils.currentTime();
        }
        try {
            return DateTimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    public long parseDateFormat(String timestampStr, long currentTime) throws SQLParserException {
        if (timestampStr == null || "".equals(timestampStr.trim())) {
            throw new SQLParserException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return currentTime;
        }
        try {
            return DateTimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    private Long parseDateExpression(IoTDBSqlParser.DateExpressionContext ctx) {
        long time = this.parseDateFormat(ctx.getChild(0).getText());
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if ("+".equals(ctx.getChild(i).getText())) {
                time += DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
                continue;
            }
            time -= DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
        }
        return time;
    }

    private Long parseDateExpression(IoTDBSqlParser.DateExpressionContext ctx, long currentTime) {
        long time = this.parseDateFormat(ctx.getChild(0).getText(), currentTime);
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if ("+".equals(ctx.getChild(i).getText())) {
                time += DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
                continue;
            }
            time -= DateTimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
        }
        return time;
    }

    private long parseTimeValue(IoTDBSqlParser.TimeValueContext ctx, long currentTime) {
        if (ctx.INTEGER_LITERAL() != null) {
            try {
                return Long.parseLong(ctx.INTEGER_LITERAL().getText());
            }
            catch (NumberFormatException e) {
                throw new SQLParserException(String.format("Can not parse %s to long value", ctx.INTEGER_LITERAL().getText()));
            }
        }
        if (ctx.dateExpression() != null) {
            return this.parseDateExpression(ctx.dateExpression(), currentTime);
        }
        return this.parseDateFormat(ctx.datetimeLiteral().getText(), currentTime);
    }

    private Expression parseExpression(IoTDBSqlParser.ExpressionContext context) {
        if (context.unaryInBracket != null) {
            return this.parseExpression(context.unaryInBracket);
        }
        if (context.unaryAfterSign != null) {
            return context.MINUS() != null ? new NegationExpression(this.parseExpression(context.unaryAfterSign)) : this.parseExpression(context.unaryAfterSign);
        }
        if (context.leftExpression != null && context.rightExpression != null) {
            Expression leftExpression = this.parseExpression(context.leftExpression);
            Expression rightExpression = this.parseExpression(context.rightExpression);
            if (context.STAR() != null) {
                return new MultiplicationExpression(leftExpression, rightExpression);
            }
            if (context.DIV() != null) {
                return new DivisionExpression(leftExpression, rightExpression);
            }
            if (context.MOD() != null) {
                return new ModuloExpression(leftExpression, rightExpression);
            }
            if (context.PLUS() != null) {
                return new AdditionExpression(leftExpression, rightExpression);
            }
            if (context.MINUS() != null) {
                return new SubtractionExpression(leftExpression, rightExpression);
            }
        }
        if (context.functionName() != null) {
            return this.parseFunctionExpression(context);
        }
        if (context.suffixPathCanInExpr() != null) {
            return new TimeSeriesOperand(this.parseSuffixPathCanInExpr(context.suffixPathCanInExpr()));
        }
        if (context.constant() != null) {
            try {
                IoTDBSqlParser.ConstantContext constantContext = context.constant();
                if (this.clientVersion.equals((Object)IoTDBConstant.ClientVersion.V_0_13)) {
                    if (constantContext.BOOLEAN_LITERAL() != null) {
                        return new ConstantOperand(TSDataType.BOOLEAN, constantContext.BOOLEAN_LITERAL().getText());
                    }
                    if (constantContext.STRING_LITERAL() != null) {
                        String text = constantContext.STRING_LITERAL().getText();
                        return new ConstantOperand(TSDataType.TEXT, this.parseStringLiteral(text));
                    }
                    if (constantContext.INTEGER_LITERAL() != null) {
                        return new ConstantOperand(TSDataType.INT64, constantContext.INTEGER_LITERAL().getText());
                    }
                    if (constantContext.realLiteral() != null) {
                        return new ConstantOperand(TSDataType.DOUBLE, constantContext.realLiteral().getText());
                    }
                    throw new SQLParserException("Unsupported constant operand: " + constantContext.getText());
                }
                if (this.clientVersion.equals((Object)IoTDBConstant.ClientVersion.V_0_12)) {
                    return new TimeSeriesOperand(this.convertConstantToPath(context.constant().getText()));
                }
            }
            catch (IllegalPathException | QueryProcessException e) {
                throw new SQLParserException(e.getMessage());
            }
        }
        throw new UnsupportedOperationException();
    }

    private Expression parseFunctionExpression(IoTDBSqlParser.ExpressionContext functionClause) {
        FunctionExpression functionExpression = new FunctionExpression(this.parseIdentifier(functionClause.functionName().getText()));
        boolean hasNonPureConstantSubExpression = false;
        for (IoTDBSqlParser.ExpressionContext expression : functionClause.expression()) {
            Expression subexpression = this.parseExpression(expression);
            if (!subexpression.isConstantOperand()) {
                hasNonPureConstantSubExpression = true;
            }
            functionExpression.addExpression(subexpression);
        }
        if (!hasNonPureConstantSubExpression) {
            throw new SQLParserException("Invalid function expression, all the arguments are constant operands: " + functionClause.getText());
        }
        for (IoTDBSqlParser.FunctionAttributeContext functionAttribute : functionClause.functionAttribute()) {
            functionExpression.addAttribute(this.parseStringLiteral(functionAttribute.functionAttributeKey.getText()), this.parseStringLiteral(functionAttribute.functionAttributeValue.getText()));
        }
        return functionExpression;
    }

    private FilterOperator parseOrExpression(IoTDBSqlParser.OrExpressionContext ctx) {
        if (ctx.andExpression().size() == 1) {
            return this.parseAndExpression(ctx.andExpression(0));
        }
        FilterOperator binaryOp = new FilterOperator(FilterConstant.FilterType.KW_OR);
        if (ctx.andExpression().size() > 2) {
            binaryOp.addChildOperator(this.parseAndExpression(ctx.andExpression(0)));
            binaryOp.addChildOperator(this.parseAndExpression(ctx.andExpression(1)));
            for (int i = 2; i < ctx.andExpression().size(); ++i) {
                FilterOperator op = new FilterOperator(FilterConstant.FilterType.KW_OR);
                op.addChildOperator(binaryOp);
                op.addChildOperator(this.parseAndExpression(ctx.andExpression(i)));
                binaryOp = op;
            }
        } else {
            for (IoTDBSqlParser.AndExpressionContext andExpressionContext : ctx.andExpression()) {
                binaryOp.addChildOperator(this.parseAndExpression(andExpressionContext));
            }
        }
        return binaryOp;
    }

    private FilterOperator parseAndExpression(IoTDBSqlParser.AndExpressionContext ctx) {
        if (ctx.predicate().size() == 1) {
            return this.parsePredicate(ctx.predicate(0));
        }
        FilterOperator binaryOp = new FilterOperator(FilterConstant.FilterType.KW_AND);
        int size = ctx.predicate().size();
        if (size > 2) {
            binaryOp.addChildOperator(this.parsePredicate(ctx.predicate(0)));
            binaryOp.addChildOperator(this.parsePredicate(ctx.predicate(1)));
            for (int i = 2; i < size; ++i) {
                FilterOperator op = new FilterOperator(FilterConstant.FilterType.KW_AND);
                op.addChildOperator(binaryOp);
                op.addChildOperator(this.parsePredicate(ctx.predicate(i)));
                binaryOp = op;
            }
        } else {
            for (IoTDBSqlParser.PredicateContext predicateContext : ctx.predicate()) {
                binaryOp.addChildOperator(this.parsePredicate(predicateContext));
            }
        }
        return binaryOp;
    }

    private FilterOperator parsePredicate(IoTDBSqlParser.PredicateContext ctx) {
        PartialPath path = null;
        if (ctx.OPERATOR_NOT() != null) {
            FilterOperator notOp = new FilterOperator(FilterConstant.FilterType.KW_NOT);
            notOp.addChildOperator(this.parseOrExpression(ctx.orExpression()));
            return notOp;
        }
        if (ctx.LR_BRACKET() != null && ctx.OPERATOR_NOT() == null) {
            return this.parseOrExpression(ctx.orExpression());
        }
        if (ctx.REGEXP() != null || ctx.LIKE() != null) {
            if (ctx.suffixPath() != null) {
                path = this.parseSuffixPath(ctx.suffixPath());
            } else if (ctx.fullPath() != null) {
                path = this.parseFullPath(ctx.fullPath());
            }
            if (path == null) {
                throw new SQLParserException("Path is null, please check the sql.");
            }
            return ctx.REGEXP() != null ? new RegexpOperator(FilterConstant.FilterType.REGEXP, path, ctx.STRING_LITERAL().getText(), false) : new LikeOperator(FilterConstant.FilterType.LIKE, path, ctx.STRING_LITERAL().getText(), false);
        }
        if (ctx.TIME() != null || ctx.TIMESTAMP() != null) {
            path = new PartialPath(SQLConstant.getSingleTimeArray());
        }
        if (ctx.fullPath() != null) {
            path = this.parseFullPath(ctx.fullPath());
        }
        if (ctx.suffixPath() != null) {
            path = this.parseSuffixPath(ctx.suffixPath());
        }
        if (path == null) {
            throw new SQLParserException("Path is null, please check the sql.");
        }
        if (ctx.inClause() != null) {
            return this.parseInOperator(ctx.inClause(), path);
        }
        return this.parseBasicFunctionOperator(ctx, path);
    }

    private FilterOperator parseBasicFunctionOperator(IoTDBSqlParser.PredicateContext ctx, PartialPath path) {
        BasicFunctionOperator basic;
        if (ctx.constant().dateExpression() != null) {
            if (!path.equals(SQLConstant.TIME_PATH)) {
                throw new SQLParserException(path.getFullPath(), "Date can only be used to time");
            }
            basic = new BasicFunctionOperator(FilterConstant.lexerToFilterType.get(ctx.comparisonOperator().type.getType()), path, Long.toString(this.parseDateExpression(ctx.constant().dateExpression())));
        } else {
            basic = new BasicFunctionOperator(FilterConstant.lexerToFilterType.get(ctx.comparisonOperator().type.getType()), path, this.parseStringLiteral(ctx.constant().getText()));
        }
        return basic;
    }

    private FilterOperator parseInOperator(IoTDBSqlParser.InClauseContext ctx, PartialPath path) {
        HashSet<String> values = new HashSet<String>();
        boolean not = ctx.OPERATOR_NOT() != null;
        for (IoTDBSqlParser.ConstantContext constant : ctx.constant()) {
            if (constant.dateExpression() != null) {
                if (!path.equals(SQLConstant.TIME_PATH)) {
                    throw new SQLParserException(path.getFullPath(), "Date can only be used to time");
                }
                values.add(Long.toString(this.parseDateExpression(constant.dateExpression())));
                continue;
            }
            values.add(constant.getText());
        }
        return new InOperator(FilterConstant.FilterType.IN, path, not, values);
    }

    private void parseIndexPredicate(IoTDBSqlParser.IndexPredicateClauseContext ctx) {
        Map<String, Object> props;
        PartialPath path = ctx.suffixPath() != null ? this.parseSuffixPath(ctx.suffixPath()) : this.parseFullPath(ctx.fullPath());
        if (ctx.LIKE() != null) {
            if (this.queryOp.getSelectComponent().getResultColumns().size() != 1) {
                throw new SQLParserException("Index query statement allows only one select path");
            }
            if (!path.equals(this.queryOp.getSelectComponent().getResultColumns().get(0).getExpression().toString())) {
                throw new SQLParserException("In the index query statement, the path in select element and the index predicate should be same");
            }
            props = this.queryOp.getProps() != null ? this.queryOp.getProps() : new HashMap<String, Object>();
            props.put("PATTERN", this.parseSequence(ctx.sequenceClause(0)));
            this.queryOp.setIndexType(IndexType.RTREE_PAA);
        } else if (ctx.CONTAIN() != null) {
            ArrayList<double[]> compositePattern = new ArrayList<double[]>();
            ArrayList<Double> thresholds = new ArrayList<Double>();
            for (int i = 0; i < ctx.sequenceClause().size(); ++i) {
                compositePattern.add(this.parseSequence(ctx.sequenceClause(i)));
                thresholds.add(Double.parseDouble(ctx.constant(i).getText()));
            }
            props = this.queryOp.getProps() != null ? this.queryOp.getProps() : new HashMap<String, Object>();
            ArrayList<ResultColumn> resultColumns = new ArrayList<ResultColumn>();
            resultColumns.add(new ResultColumn(new TimeSeriesOperand(path)));
            this.queryOp.getSelectComponent().setResultColumns(resultColumns);
            props.put("PATTERN", compositePattern);
            props.put("THRESHOLD", thresholds);
            this.queryOp.setIndexType(IndexType.ELB_INDEX);
        } else {
            throw new SQLParserException("Unknown index predicate: " + ctx);
        }
        this.queryOp.setProps(props);
    }

    private double[] parseSequence(IoTDBSqlParser.SequenceClauseContext ctx) {
        int seqLen = ctx.constant().size();
        double[] sequence = new double[seqLen];
        for (int i = 0; i < seqLen; ++i) {
            sequence[i] = Double.parseDouble(ctx.constant(i).getText());
        }
        return sequence;
    }

    public void parseSelectClause(IoTDBSqlParser.SelectClauseContext ctx) {
        SelectComponent selectComponent = new SelectComponent(this.zoneId);
        if (ctx.topClause() != null) {
            this.visitTopClause(ctx.topClause());
        } else if (ctx.LAST() != null) {
            this.queryOp = new LastQueryOperator(this.queryOp);
        }
        HashSet<String> aliasSet = new HashSet<String>();
        for (IoTDBSqlParser.ResultColumnContext resultColumnContext : ctx.resultColumn()) {
            ResultColumn resultColumn = this.parseResultColumn(resultColumnContext);
            if (resultColumn.hasAlias()) {
                aliasSet.add(resultColumn.getAlias());
            }
            selectComponent.addResultColumn(resultColumn);
        }
        if (!this.hasDecidedQueryType()) {
            if (selectComponent.hasUserDefinedAggregationFunction()) {
                this.queryOp = new UDAFQueryOperator(new AggregationQueryOperator(this.queryOp));
            } else if (selectComponent.hasPlainAggregationFunction()) {
                this.queryOp = new AggregationQueryOperator(this.queryOp);
            } else if (selectComponent.hasTimeSeriesGeneratingFunction()) {
                this.queryOp = new UDTFQueryOperator(this.queryOp);
            }
        } else if (selectComponent.hasUserDefinedAggregationFunction()) {
            this.queryOp = new UDAFQueryOperator((AggregationQueryOperator)this.queryOp);
        }
        this.queryOp.setAliasSet(aliasSet);
        this.queryOp.setSelectComponent(selectComponent);
    }

    public Operator visitTopClause(IoTDBSqlParser.TopClauseContext ctx) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        int top = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        if (top <= 0 || top > 1000) {
            throw new SQLParserException(String.format("TOP <N>: N should be greater than 0 and less than 1000, current N is %d", top));
        }
        props.put("TOP_K", top);
        this.queryOp.setProps(props);
        return this.queryOp;
    }

    private ResultColumn parseResultColumn(IoTDBSqlParser.ResultColumnContext resultColumnContext) {
        Expression expression = this.parseExpression(resultColumnContext.expression());
        if (expression.isConstantOperand()) {
            throw new SQLParserException("Constant operand is not allowed: " + expression);
        }
        return new ResultColumn(expression, resultColumnContext.AS() == null ? null : this.parseIdentifier(resultColumnContext.identifier().getText()));
    }

    public void parseFromClause(IoTDBSqlParser.FromClauseContext ctx) {
        FromComponent fromComponent = new FromComponent();
        List prefixFromPaths = ctx.prefixPath();
        for (IoTDBSqlParser.PrefixPathContext prefixFromPath : prefixFromPaths) {
            PartialPath path = this.parsePrefixPath(prefixFromPath);
            fromComponent.addPrefixTablePath(path);
        }
        this.queryOp.setFromComponent(fromComponent);
    }

    public WhereComponent parseWhereClause(IoTDBSqlParser.WhereClauseContext ctx) {
        if (ctx.indexPredicateClause() != null) {
            this.parseIndexPredicate(ctx.indexPredicateClause());
            return null;
        }
        FilterOperator whereOp = new FilterOperator();
        whereOp.addChildOperator(this.parseOrExpression(ctx.orExpression()));
        return new WhereComponent(whereOp.getChildren().get(0));
    }

    public void parseTagClause(IoTDBSqlParser.TagClauseContext ctx, Operator operator) {
        Map<String, String> tags = this.extractMap(ctx.propertyClause(), ctx.propertyClause(0));
        if (operator instanceof CreateTimeSeriesOperator) {
            ((CreateTimeSeriesOperator)operator).setTags(tags);
        } else if (operator instanceof AlterTimeSeriesOperator) {
            ((AlterTimeSeriesOperator)operator).setTagsMap(tags);
        }
    }

    public void parseAttributeClause(IoTDBSqlParser.AttributeClauseContext ctx, Operator operator) {
        Map<String, String> attributes = this.extractMap(ctx.propertyClause(), ctx.propertyClause(0));
        if (operator instanceof CreateTimeSeriesOperator) {
            ((CreateTimeSeriesOperator)operator).setAttributes(attributes);
        } else if (operator instanceof AlterTimeSeriesOperator) {
            ((AlterTimeSeriesOperator)operator).setAttributesMap(attributes);
        }
    }

    private void parseLimitClause(IoTDBSqlParser.LimitClauseContext ctx, Operator operator) {
        int limit;
        try {
            limit = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. LIMIT <N>: N should be Int32.");
        }
        if (limit <= 0) {
            throw new SQLParserException("LIMIT <N>: N should be greater than 0.");
        }
        if (operator instanceof ShowTimeSeriesOperator) {
            ((ShowTimeSeriesOperator)operator).setLimit(limit);
        } else if (operator instanceof ShowDevicesOperator) {
            ((ShowDevicesOperator)operator).setLimit(limit);
        } else if (operator instanceof ShowChildPathsOperator) {
            ((ShowChildPathsOperator)operator).setLimit(limit);
        } else if (operator instanceof ShowChildNodesOperator) {
            ((ShowChildNodesOperator)operator).setLimit(limit);
        } else {
            SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
            if (specialClauseComponent == null) {
                specialClauseComponent = new SpecialClauseComponent();
            }
            specialClauseComponent.setRowLimit(limit);
            this.queryOp.setSpecialClauseComponent(specialClauseComponent);
        }
        if (ctx.offsetClause() != null) {
            this.parseOffsetClause(ctx.offsetClause(), operator);
        }
    }

    private void parseOffsetClause(IoTDBSqlParser.OffsetClauseContext ctx, Operator operator) {
        int offset;
        try {
            offset = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. OFFSET <OFFSETValue>: OFFSETValue should be Int32.");
        }
        if (offset < 0) {
            throw new SQLParserException("OFFSET <OFFSETValue>: OFFSETValue should >= 0.");
        }
        if (operator instanceof ShowTimeSeriesOperator) {
            ((ShowTimeSeriesOperator)operator).setOffset(offset);
        } else if (operator instanceof ShowDevicesOperator) {
            ((ShowDevicesOperator)operator).setOffset(offset);
        } else if (operator instanceof ShowChildNodesOperator) {
            ((ShowChildNodesOperator)operator).setOffset(offset);
        } else if (operator instanceof ShowChildPathsOperator) {
            ((ShowChildPathsOperator)operator).setOffset(offset);
        } else {
            SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
            if (specialClauseComponent == null) {
                specialClauseComponent = new SpecialClauseComponent();
            }
            specialClauseComponent.setRowOffset(offset);
            this.queryOp.setSpecialClauseComponent(specialClauseComponent);
        }
    }

    private void parseSlimitClause(IoTDBSqlParser.SlimitClauseContext ctx) {
        int slimit;
        try {
            slimit = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. SLIMIT <SN>: SN should be Int32.");
        }
        if (slimit <= 0) {
            throw new SQLParserException("SLIMIT <SN>: SN should be greater than 0.");
        }
        SpecialClauseComponent specialClauseComponent = this.queryOp.getSpecialClauseComponent();
        if (specialClauseComponent == null) {
            specialClauseComponent = new SpecialClauseComponent();
        }
        specialClauseComponent.setSeriesLimit(slimit);
        this.queryOp.setSpecialClauseComponent(specialClauseComponent);
        if (ctx.soffsetClause() != null) {
            this.parseSoffsetClause(ctx.soffsetClause(), this.queryOp);
        }
    }

    public void parseSoffsetClause(IoTDBSqlParser.SoffsetClauseContext ctx, QueryOperator queryOp) {
        int soffset;
        try {
            soffset = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. SOFFSET <SOFFSETValue>: SOFFSETValue should be Int32.");
        }
        if (soffset < 0) {
            throw new SQLParserException("SOFFSET <SOFFSETValue>: SOFFSETValue should >= 0.");
        }
        SpecialClauseComponent specialClauseComponent = queryOp.getSpecialClauseComponent();
        if (specialClauseComponent == null) {
            specialClauseComponent = new SpecialClauseComponent();
        }
        specialClauseComponent.setSeriesOffset(soffset);
        queryOp.setSpecialClauseComponent(specialClauseComponent);
    }

    private boolean hasDecidedQueryType() {
        return this.queryOp instanceof GroupByQueryOperator || this.queryOp instanceof FillQueryOperator || this.queryOp instanceof LastQueryOperator || this.queryOp instanceof AggregationQueryOperator || this.queryOp instanceof UDTFQueryOperator || this.queryOp instanceof UDAFQueryOperator;
    }

    private String parseStringLiteral(String src) {
        if (2 <= src.length() && (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"' || src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'')) {
            String unescapeString = StringEscapeUtils.unescapeJava((String)src.substring(1, src.length() - 1));
            return unescapeString.length() == 0 ? "" : unescapeString;
        }
        return src;
    }

    private String parseStringLiteralInInsertValue(String src) {
        if (2 <= src.length() && (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"' || src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'')) {
            return StringEscapeUtils.unescapeJava((String)src);
        }
        return src;
    }

    private String parseIdentifier(String src) {
        if (2 <= src.length() && src.charAt(0) == '`' && src.charAt(src.length() - 1) == '`') {
            return StringEscapeUtils.unescapeJava((String)src.substring(1, src.length() - 1));
        }
        return src;
    }

    private String parseNodeName(String src) {
        if (2 <= src.length() && src.charAt(0) == '`' && src.charAt(src.length() - 1) == '`') {
            return src.substring(1, src.length() - 1);
        }
        return src;
    }

    public String parseFilePath(String src) {
        return src.substring(1, src.length() - 1);
    }

    private long parseTimeUnitOrSlidingStep(String durationStr, boolean isParsingTimeUnit, GroupByClauseComponent groupByComponent) {
        if (durationStr.toLowerCase().contains("mo")) {
            if (isParsingTimeUnit) {
                groupByComponent.setIntervalByMonth(true);
            } else {
                groupByComponent.setSlidingStepByMonth(true);
            }
        }
        return DateTimeUtils.convertDurationStrToLong(durationStr);
    }

    private void setMap(IoTDBSqlParser.AlterClauseContext ctx, Map<String, String> alterMap) {
        List tagsList = ctx.propertyClause();
        if (ctx.propertyClause(0) != null) {
            for (IoTDBSqlParser.PropertyClauseContext property : tagsList) {
                String value = this.parseStringLiteral(property.propertyValue().getText());
                alterMap.put(this.parseIdentifier(property.identifier().getText()), value);
            }
        }
    }

    private Map<String, String> extractMap(List<IoTDBSqlParser.PropertyClauseContext> property2, IoTDBSqlParser.PropertyClauseContext property3) {
        HashMap<String, String> tags = new HashMap<String, String>(property2.size());
        if (property3 != null) {
            for (IoTDBSqlParser.PropertyClauseContext property : property2) {
                tags.put(this.parseIdentifier(property.identifier().getText()), this.parseStringLiteral(property.propertyValue().getText()));
            }
        }
        return tags;
    }

    private Pair<Long, Long> calcOperatorInterval(FilterOperator filterOperator) {
        if (filterOperator.getSinglePath() != null && !"time".equals(filterOperator.getSinglePath().getMeasurement())) {
            throw new SQLParserException(DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG);
        }
        long time = Long.parseLong(((BasicFunctionOperator)filterOperator).getValue());
        switch (filterOperator.getFilterType()) {
            case LESSTHAN: {
                return new Pair((Object)Long.MIN_VALUE, (Object)(time - 1L));
            }
            case LESSTHANOREQUALTO: {
                return new Pair((Object)Long.MIN_VALUE, (Object)time);
            }
            case GREATERTHAN: {
                return new Pair((Object)(time + 1L), (Object)Long.MAX_VALUE);
            }
            case GREATERTHANOREQUALTO: {
                return new Pair((Object)time, (Object)Long.MAX_VALUE);
            }
            case EQUAL: {
                return new Pair((Object)time, (Object)time);
            }
        }
        throw new SQLParserException(DELETE_RANGE_ERROR_MSG);
    }
}

