/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.reader.mult;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.iotdb.cluster.query.reader.mult.AbstractMultPointReader;
import org.apache.iotdb.cluster.query.reader.mult.AssignPathAscPriorityMergeReader;
import org.apache.iotdb.cluster.query.reader.mult.AssignPathDescPriorityMergeReader;
import org.apache.iotdb.cluster.query.reader.mult.IAssignPathPriorityMergeReader;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class AssignPathManagedMergeReader
implements ManagedSeriesReader,
IPointReader {
    private static final int BATCH_SIZE = 4096;
    private volatile boolean managedByPool;
    private volatile boolean hasRemaining;
    private BatchData batchData;
    private TSDataType dataType;
    private final IAssignPathPriorityMergeReader underlyingReader;

    public AssignPathManagedMergeReader(String fullPath, TSDataType dataType, boolean isAscending) {
        this.underlyingReader = isAscending ? new AssignPathAscPriorityMergeReader(fullPath) : new AssignPathDescPriorityMergeReader(fullPath);
        this.dataType = dataType;
    }

    public void addReader(AbstractMultPointReader reader, long priority) throws IOException {
        this.underlyingReader.addReader(reader, priority);
    }

    public boolean isManagedByQueryManager() {
        return this.managedByPool;
    }

    public void setManagedByQueryManager(boolean managedByQueryManager) {
        this.managedByPool = managedByQueryManager;
    }

    public boolean hasRemaining() {
        return this.hasRemaining;
    }

    public void setHasRemaining(boolean hasRemaining) {
        this.hasRemaining = hasRemaining;
    }

    public boolean hasNextBatch() throws IOException {
        if (this.batchData != null) {
            return true;
        }
        this.constructBatch();
        return this.batchData != null;
    }

    private void constructBatch() throws IOException {
        if (this.underlyingReader.hasNextTimeValuePair()) {
            this.batchData = new BatchData(this.dataType);
            while (this.underlyingReader.hasNextTimeValuePair() && this.batchData.length() < 4096) {
                TimeValuePair next = this.underlyingReader.nextTimeValuePair();
                this.batchData.putAnObject(next.getTimestamp(), next.getValue().getValue());
            }
        }
    }

    public BatchData nextBatch() throws IOException {
        if (!this.hasNextBatch()) {
            throw new NoSuchElementException();
        }
        BatchData ret = this.batchData;
        this.batchData = null;
        return ret;
    }

    public boolean hasNextTimeValuePair() throws IOException {
        return this.underlyingReader.hasNextTimeValuePair();
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        return this.underlyingReader.nextTimeValuePair();
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        return this.underlyingReader.currentTimeValuePair();
    }

    public void close() throws IOException {
        this.underlyingReader.close();
    }
}

