/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
*/

package main

import "github.com/apache/incubator-yunikorn-k8shim/pkg/common/events"

type ShimSchedulerEvent struct {
	event events.SchedulerEventType
}

func (rs ShimSchedulerEvent) GetEvent() events.SchedulerEventType {
	return rs.event
}

func (rs ShimSchedulerEvent) GetArgs() []interface{} {
	return nil
}

// -------------------------------------------------------------------
// event to trigger scheduler registration
// --------------------------------------------------------------------
type RegisterSchedulerEvent struct {
	event events.SchedulerEventType
}

func newRegisterSchedulerEvent() RegisterSchedulerEvent {
	return RegisterSchedulerEvent{
		event: events.RegisterScheduler,
	}
}

func (rs RegisterSchedulerEvent) GetEvent() events.SchedulerEventType {
	return rs.event
}

func (rs RegisterSchedulerEvent) GetArgs() []interface{} {
	return nil
}
